/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.jdeveloper.db.ConnectionInfo;

public abstract class ConnectionSelector {
    private static final List<ConnectionSelector> m_selectors = new CopyOnWriteArrayList<ConnectionSelector>();

    public static void registerSelector(ConnectionSelector impl) {
        m_selectors.add(0, impl);
    }

    public static boolean selectConnection(final ConnectionInfo conn, final Context ideContext, final boolean open) {
        boolean retval = false;
        if (conn.getStoreName() != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                retval = ConnectionSelector.selectConnectionImpl(conn, ideContext, open);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionSelector.selectConnectionImpl(conn, ideContext, open);
                    }
                });
            }
        }
        return retval;
    }

    private static boolean selectConnectionImpl(ConnectionInfo conn, Context ideContext, boolean open) {
        boolean retval = false;
        for (ConnectionSelector impl : m_selectors) {
            if (!impl.findAndSelectConnection(conn, ideContext, open)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public abstract boolean findAndSelectConnection(ConnectionInfo var1, Context var2, boolean var3);
}

