/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.adapter;

import java.net.URL;
import java.util.Hashtable;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;

public class DefaultContextWrapper
implements DatabaseContextManager.ContextWrapper {
    private static final String INITIAL_CONTEXT_FACTORY = "oracle.adf.share.jndi.InitialContextFactoryImpl";
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";
    private static DefaultContextWrapper s_instance;
    private AdfJndiContext m_context;
    private URL m_url;
    private final ReferenceWorker m_worker;
    private Level m_logLevel = Level.SEVERE;

    public static DefaultContextWrapper getInstance() {
        if (s_instance == null) {
            DefaultContextWrapper wrapper;
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            if (Product.isJDeveloper()) {
                DefaultContextWrapper.getLogger().severe("Default context should not be created in JDeveloper as rescat context should be used.");
            } else {
                String productID = ProductInformation.getProductID();
                boolean isLoaded = er.isFullyLoaded(productID);
                if (!isLoaded) {
                    DefaultContextWrapper.getLogger().severe("Connections should not be initialised before " + productID + " is loaded.");
                }
            }
            URL dirURL = er.getSystemDirectory("oracle.jdeveloper.db.connection");
            URL fileURL = URLFactory.newURL((URL)dirURL, (String)CONNECTIONS_FILE_NAME);
            if (!URLFileSystem.exists((URL)dirURL)) {
                URLFileSystem.mkdirs((URL)fileURL);
            }
            s_instance = wrapper = new DefaultContextWrapper(fileURL, (String)null);
            DatabaseProviderHelper.setDefaultWorker((ReferenceWorker)wrapper.getReferenceWorker());
        }
        return s_instance;
    }

    public DefaultContextWrapper(URL url) {
        this(url, DefaultContextWrapper.generateNewKey());
    }

    public DefaultContextWrapper(URL url, String key) {
        this(url, DefaultContextWrapper.createDefaultWorker(key));
    }

    private DefaultContextWrapper(URL url, ReferenceWorker worker) {
        this.m_url = url;
        this.m_worker = worker;
        this.m_logLevel = Level.FINE;
    }

    @Override
    public Context getDatabaseContext() {
        if (this.m_context == null && this.m_url != null) {
            try {
                this.m_context = DefaultContextWrapper.newContext(this.m_url, this.m_worker);
            }
            catch (NamingException nme) {
                String msg = "Failed to create naming Context for db connections at url: " + this.m_url.toExternalForm();
                DefaultContextWrapper.getLogger().log(this.m_logLevel, msg, nme);
            }
        }
        return this.m_context;
    }

    @Override
    public void saveDatabaseContext() throws NamingException {
        if (this.m_context != null) {
            this.m_context.save();
        }
    }

    public void reset(URL url) {
        this.m_url = url;
        this.m_context = null;
    }

    public ReferenceWorker getReferenceWorker() {
        return this.m_worker;
    }

    private static String generateNewKey() {
        return UUID.randomUUID().toString();
    }

    private static String getSystemKey() {
        String retval;
        if (!Ide.isRunning() || Product.isJDeveloper()) {
            String testKey = System.getProperty("db.junit.system.id");
            if (testKey == null) {
                DefaultContextWrapper.getLogger().fine("No system key for JDeveloper - a credential store is used.");
                retval = null;
            } else {
                retval = testKey;
            }
        } else {
            String prefKey = "db.system.id";
            HashStructure prefs = Preferences.getPreferences().getProperties();
            retval = prefs.getString("db.system.id");
            if (retval == null) {
                retval = DefaultContextWrapper.generateNewKey();
                prefs.putString("db.system.id", retval);
            }
        }
        return retval;
    }

    private static ReferenceWorker createDefaultWorker(String key) {
        Object retval = null;
        if (!ModelUtil.hasLength((String)key)) {
            key = DefaultContextWrapper.getSystemKey();
        }
        return key == null ? null : ReferenceWorker.createDefaultWorker((String)key);
    }

    private static AdfJndiContext newContext(URL url, ReferenceWorker worker) throws NamingException {
        long startTime = System.currentTimeMillis();
        Hashtable<String, String> env = new Hashtable<String, String>();
        String path = url.getPath();
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", path);
        if (worker != null) {
            env.put(ReferenceWorker.KEY, (String)worker);
        }
        AdfInitialContext c = AdfInitialContext.newAdfInitialContext(env, DefaultContextWrapper.class);
        DefaultContextWrapper.getLogger().log(Level.FINE, "Creating AdfJndiContext at {0} took {1}ms", new Object[]{path, System.currentTimeMillis() - startTime});
        return c;
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DefaultContextWrapper.class);
    }

    public static DefaultContextWrapper createLegacyWrapper(URL url) {
        return new DefaultContextWrapper(url, ReferenceWorker.createLegacyWorker());
    }
}

