/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.ide.Context;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class StorePicker
extends JComboBox {
    private final DefaultComboBoxModel m_model = (DefaultComboBoxModel)this.getModel();
    private final Context m_ideContext;

    public StorePicker() {
        this((Context)null);
    }

    public StorePicker(Context ideContext) {
        super(new NonNullableComboBoxModel());
        this.m_ideContext = ideContext;
        for (String s : this.listStores()) {
            this.m_model.addElement(s);
        }
        final DefaultListCellRenderer delegate = new DefaultListCellRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String storeName = (String)value;
                value = StorePicker.this.getShortLabel(storeName);
                JLabel retval = (JLabel)delegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                retval.setIcon(StorePicker.this.getIcon(storeName));
                return retval;
            }
        });
    }

    protected String getShortLabel(String storeName) {
        DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
        return stores.getShortLabel(storeName);
    }

    protected Icon getIcon(String storeName) {
        DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
        return stores.getIcon(storeName);
    }

    public String getStore() {
        return (String)this.m_model.getSelectedItem();
    }

    public boolean setStore(String storeName) {
        if (this.m_model.getIndexOf(storeName) >= 0) {
            this.m_model.setSelectedItem(storeName);
            return true;
        }
        return false;
    }

    protected Collection<String> listStores() {
        return DatabaseConnectionStores.getInstance().listStores(this.m_ideContext);
    }

    protected final Context getContext() {
        return this.m_ideContext;
    }

    public void addItem(Object anObject) {
        throw new UnsupportedOperationException();
    }
}

