/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.sql.Connection;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;

public class ConnectionInfo
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.jdeveloper.db.ConnectionInfo";
    private static final String STORE_NAME_KEY = "StoreName";
    private static final String CONN_NAME_KEY = "ConnectionName";

    public ConnectionInfo(String store, String conn) {
        this(HashStructure.newInstance());
        this.setStoreName(store);
        this.setConnectionName(conn);
    }

    public ConnectionInfo(String qualifiedName) {
        this(HashStructure.newInstance());
        this.setQualifiedName(qualifiedName);
    }

    private ConnectionInfo(HashStructure data) {
        super(data);
    }

    public String getStoreName() {
        return this._hash.getString(STORE_NAME_KEY);
    }

    public void setStoreName(String store) {
        this._hash.putString(STORE_NAME_KEY, store);
    }

    public String getConnectionName() {
        return this._hash.getString(CONN_NAME_KEY);
    }

    public void setConnectionName(String conn) {
        this._hash.putString(CONN_NAME_KEY, conn);
    }

    public String getQualifiedName() {
        String storeName = this.getStoreName();
        String connName = this.getConnectionName();
        return DatabaseFactory.encodeIdentifier((String)storeName, (String)connName);
    }

    public void setQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            this.setStoreName(null);
            this.setConnectionName(null);
        } else {
            String[] bits = DatabaseFactory.decodeIdentifier((String)qualifiedName);
            this.setStoreName(bits[0]);
            this.setConnectionName(bits[1]);
        }
    }

    public DBObjectProviderID getProviderID() {
        return new DBObjectProviderID("db", (Object)this.getQualifiedName());
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean isValid() {
        return this.getReferenceable() != null;
    }

    public DatabaseProvider getReferenceable() {
        return DatabaseConnectionStores.getReferenceable(this.getStoreName(), this.getConnectionName());
    }

    public Connection getConnection() throws ConnectionException {
        DatabaseConnections store = DatabaseConnectionStores.getInstance().getStore(this.getStoreName());
        if (store != null) {
            return store.getConnection(this.getConnectionName());
        }
        return null;
    }

    public Database getDatabase() throws DBException {
        DatabaseConnections store = DatabaseConnectionStores.getInstance().getStore(this.getStoreName());
        if (store != null) {
            return store.getDatabase(this.getConnectionName());
        }
        return null;
    }

    public static ConnectionInfo getConnectionInfo(PropertyStorage ps) {
        return ConnectionInfo.getConnectionInfo(ps, DATA_KEY);
    }

    public static ConnectionInfo getConnectionInfo(PropertyStorage ps, String key) {
        HashStructure hash = ps == null ? HashStructure.newInstance() : ps.getProperties();
        return new ConnectionInfo(hash.getOrCreateHashStructure(key));
    }
}

