/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.validators.ValidationLevel;

public final class ValidationContext<T extends DBObject> {
    private final T m_orig;
    private final T m_upd;
    private final String[] m_props;
    private final ValidationLevel m_level;

    public ValidationContext(T originalObject, T updatedObject, ValidationLevel level, String ... props) {
        if (updatedObject == null) {
            throw new IllegalArgumentException("updatedObject is null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level is null");
        }
        if (props != null && (props.length == 0 || props.length == 1 && props[0] == null)) {
            props = null;
        }
        this.m_orig = originalObject;
        this.m_upd = updatedObject;
        this.m_level = level;
        this.m_props = props;
    }

    public T getOriginalObject() {
        return this.m_orig;
    }

    public T getUpdatedObject() {
        return this.m_upd;
    }

    public String[] getProperties() {
        return this.m_props;
    }

    public ValidationLevel getLevel() {
        return this.m_level;
    }
}

