/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSchemaObjectUsage
extends AbstractProviderUsageSQLFragment
implements DBObjectUsage {
    public AbstractSchemaObjectUsage() {
    }

    public AbstractSchemaObjectUsage(DBObjectID id) {
        this.setObjectID(id);
    }

    @Override
    public void setObjectID(DBObjectID id) {
        this.setProperty("objectID", id);
    }

    @Override
    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public void setQualified(boolean qualified) {
        this.setProperty("qualified", qualified);
    }

    public boolean isQualified() {
        return (Boolean)this.getProperty("qualified", false);
    }

    @Override
    public String getSQLText() {
        DBObjectID objectID = this.getObjectID();
        if (objectID != null) {
            String dbName = null;
            String schema = null;
            String name = null;
            if (objectID instanceof BaseObjectID) {
                dbName = ((BaseObjectID)objectID).getDatabaseName();
                schema = ((BaseObjectID)objectID).getSchemaName();
                name = ((BaseObjectID)objectID).getName();
            }
            if (!ModelUtil.hasLength(schema) || !ModelUtil.hasLength(name)) {
                try {
                    SchemaObject obj = (SchemaObject)objectID.resolveID();
                    if (obj != null) {
                        name = obj.getName();
                        Schema s = obj.getSchema();
                        if (s != null) {
                            schema = s.getName();
                            if (s.getID() instanceof BaseObjectID) {
                                dbName = ((BaseObjectID)s.getID()).getDatabaseName();
                            }
                        }
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger(this).log(Level.WARNING, "Couldn't resolve ID for SQL: " + dbe.getMessage());
                }
            }
            StringBuilder buff = new StringBuilder();
            if (this.shouldQualify(schema)) {
                buff.append(this.getExternalName(schema, "SCHEMA")).append(".");
            }
            buff.append(this.getExternalName(name, "TABLE"));
            if (ModelUtil.hasLength((String)dbName)) {
                buff.append("@").append(dbName);
            }
            return buff.toString();
        }
        return null;
    }

    private boolean shouldQualify(String schemaName) {
        Schema ourSchema;
        DatabaseDescriptor desc;
        boolean retval = schemaName == null ? false : (this.isQualified() ? true : ((desc = this.getDatabaseDescriptor()) != null && desc.areNamesEqual(schemaName, desc.getPublicSchemaName(), "SCHEMA", false) ? false : (ourSchema = DBUtil.getSchema(this)) != null && !this.areNamesEqual(ourSchema.getName(), schemaName, "SCHEMA", false)));
        return retval;
    }
}

