/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.MultiMap;

class MetadataGenerator {
    private List<Class<? extends Copyable>> m_beans;
    private MultiMap<String, PropertyInfo> m_extraProps;

    public Collection<Class<? extends Copyable>> getBeans() {
        this.init();
        return this.m_beans;
    }

    public MultiMap<String, PropertyInfo> getExtraProperties() {
        this.init();
        return this.m_extraProps;
    }

    private synchronized void init() {
        if (this.m_beans == null) {
            this.loadMetadata();
        }
    }

    private static void logException(Exception e) {
        e.printStackTrace();
    }

    private void loadMetadata() {
        this.m_beans = new ArrayList<Class<? extends Copyable>>();
        this.m_extraProps = new MultiMap();
        try {
            Collection<Class> allClasses = this.getClasses();
            for (Class clz : allClasses) {
                int mod = clz.getModifiers();
                if (Copyable.class.isAssignableFrom(clz) && Modifier.isPublic(mod) && clz.getAnnotation(Deprecated.class) == null && !Difference.class.isAssignableFrom(clz)) {
                    this.m_beans.add(clz);
                }
                MetadataGenerator.findExtendedProperties(clz, this.m_extraProps);
            }
        }
        catch (ClassNotFoundException e) {
            MetadataGenerator.logException(e);
        }
        Collections.sort(this.m_beans, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> a, Class<?> b) {
                String an = a == null ? "" : a.getName();
                String bn = b == null ? "" : b.getName();
                return an.compareTo(bn);
            }
        });
    }

    static void findExtendedProperties(Class<?> clz, MultiMap<String, PropertyInfo> map) {
        try {
            for (Field f : clz.getDeclaredFields()) {
                try {
                    int mod = f.getModifiers();
                    if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !f.isAnnotationPresent(PropertyKey.class)) continue;
                    if (f.getType() != String.class) {
                        throw new IllegalArgumentException("PropertyKey fields must be Strings");
                    }
                    String name = (String)f.get(null);
                    if (name == null) continue;
                    if (map.containsKey((Object)name)) {
                        throw new IllegalArgumentException(name + " has already been used by " + map.get((Object)name));
                    }
                    map.add((Object)name, (Object)PropertyInfo.createPropertyInfo(name, f));
                }
                catch (IllegalArgumentException e) {
                    MetadataGenerator.logException(e);
                }
                catch (IllegalAccessException e) {
                    MetadataGenerator.logException(e);
                }
            }
        }
        catch (SecurityException e) {
            MetadataGenerator.logException(e);
        }
    }

    private Collection<Class> getClasses() throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>();
        ClassLoader cld = DBObject.class.getClassLoader();
        if (cld == null) {
            throw new ClassNotFoundException("Can't get class loader.");
        }
        URL resource = cld.getResource("oracle/javatools/db/DBObject.class");
        if (resource == null) {
            throw new ClassNotFoundException("Can't find oracle.javatools.db.DBObject on classpath.");
        }
        URL directory = URLFileSystem.getParent((URL)resource);
        this.addClasses(classes, directory);
        return classes;
    }

    private void addClasses(Collection<Class> classes, URL directory) {
        String packag = URLFileSystem.getPath((URL)directory);
        packag = packag.substring(packag.lastIndexOf("oracle")).replace('/', '.');
        for (URL file : URLFileSystem.list((URL)directory)) {
            if (URLFileSystem.isDirectory((URL)file)) {
                this.addClasses(classes, file);
                continue;
            }
            if (!URLFileSystem.hasSuffix((URL)file, (String)".class")) continue;
            try {
                classes.add(Class.forName(packag + URLFileSystem.getName((URL)file)));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

