/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.StringTokenizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBLog;

public class PlSqlCompilerOptions
extends HashStructureAdapter {
    public static final String KEY = "PlSqlCompilerOptions";
    private static final String GENERATE_DEBUG = "generateDebugPlsql";

    public PlSqlCompilerOptions(HashStructure hash) {
        super(hash);
    }

    public WarningValue getWarningValue(WarningCategory category) {
        String val;
        if (category != null && (val = this._hash.getString(category.toString())) != null) {
            try {
                return WarningValue.valueOf(val);
            }
            catch (IllegalArgumentException ex) {
                DBLog.logStackTrace(ex);
            }
        }
        return null;
    }

    public void setWarningValue(WarningCategory category, WarningValue value) {
        if (category != null) {
            this._hash.putString(category.toString(), value == null ? null : value.toString());
        }
    }

    public void setWarningFlags(String flags) {
        this._hash.clear();
        StringTokenizer t = new StringTokenizer(flags, "|");
        while (t.hasMoreTokens()) {
            String pair = t.nextToken();
            int idx = pair.indexOf(58);
            if (idx <= 0) continue;
            try {
                WarningValue val = WarningValue.valueOf(pair.substring(0, idx));
                WarningCategory cat = WarningCategory.valueOf(pair.substring(idx + 1));
                this.setWarningValue(cat, val);
            }
            catch (IllegalArgumentException ex) {
                DBLog.logStackTrace(ex);
            }
        }
    }

    public String getWarningFlags() {
        StringBuffer buf = new StringBuffer();
        for (WarningCategory category : WarningCategory.values()) {
            WarningValue value = this.getWarningValue(category);
            if (value == null) continue;
            buf.append((Object)value).append(':').append((Object)category).append('|');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public boolean isGeneratePlSqlDebugInfo() {
        return this._hash.getBoolean(GENERATE_DEBUG, true);
    }

    public void setGeneratePlSqlDebugInfo(boolean boo) {
        this._hash.putBoolean(GENERATE_DEBUG, boo);
    }

    public static enum WarningValue {
        ENABLE,
        DISABLE,
        ERROR;

    }

    public static enum WarningCategory {
        ALL,
        INFORMATIONAL,
        SEVERE,
        PERFORMANCE;

    }
}

