/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.PropertyKey;

public class OracleTableProperties
extends AbstractChildDBObject {
    public static final String TYPE = "OracleTableProperties";
    @PropertyKey(value=OracleTableProperties.class, childOf={Table.class, TablePartition.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleTableProperties";

    @Override
    public String getType() {
        return "OracleTableProperties";
    }

    public void setTableCompression(OracleTableCompression tableCompression) {
        this.setProperty("tableCompression", (Object)tableCompression);
    }

    public OracleTableCompression getTableCompression() {
        return (OracleTableCompression)((Object)this.getProperty("tableCompression"));
    }

    public void setParallelDegree(Integer parallel) {
        this.setProperty("parallelDegree", parallel);
    }

    public Integer getParallelDegree() {
        return (Integer)this.getProperty("parallelDegree");
    }

    public static OracleTableProperties findOrCreateOracleTableProperties(DBObject dbObject) {
        OracleTableProperties otp = (OracleTableProperties)dbObject.getProperty("OracleTableProperties");
        if (otp == null) {
            otp = new OracleTableProperties();
            dbObject.setProperty("OracleTableProperties", otp);
        }
        return otp;
    }

    public static enum OracleTableCompression {
        NOCOMPRESS("NOCOMPRESS"),
        COMPRESS("COMPRESS"),
        ROW_STORE_COMPRESS_ADVANCED("ROW STORE COMPRESS ADVANCED"),
        COMPRESS_FOR_ALL_OPERATIONS("COMPRESS FOR ALL OPERATIONS"),
        COMPRESS_FOR_DIRECT_LOAD_OPERATIONS("COMPRESS FOR DIRECT_LOAD OPERATIONS"),
        COMPRESS_FOR_OLTP("COMPRESS FOR OLTP"),
        COMPRESS_FOR_ARCHIVE_LOW("COMPRESS FOR ARCHIVE LOW"),
        COMPRESS_FOR_ARCHIVE_HIGH("COMPRESS FOR ARCHIVE HIGH"),
        COMPRESS_FOR_QUERY_LOW("COMPRESS FOR QUERY LOW"),
        COMPRESS_FOR_QUERY_HIGH("COMPRESS FOR QUERY HIGH"),
        COLUMN_STORE_COMPRESS_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_ARCHIVE_LOW_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR ARCHIVE LOW ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_ARCHIVE_HIGH_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR ARCHIVE HIGH ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_QUERY_LOW_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR QUERY LOW ROW LEVEL LOCKING"),
        COLUMN_STORE_COMPRESS_FOR_QUERY_HIGH_ROW_LEVEL_LOCKING("COLUMN STORE COMPRESS FOR QUERY HIGH ROW LEVEL LOCKING");

        private String m_value;

        private OracleTableCompression(String value) {
            this.m_value = value;
        }

        public String getValue() {
            return this.m_value;
        }

        public String toString() {
            return this.getValue();
        }

        public static OracleTableCompression migrateFrom(Object value) {
            String stringVal;
            OracleTableCompression comp = null;
            if (value instanceof Boolean) {
                Boolean boolVal = (Boolean)value;
                if (boolVal != null) {
                    comp = boolVal.equals(Boolean.TRUE) ? COMPRESS : NOCOMPRESS;
                }
            } else if (value instanceof String && (stringVal = (String)value) != null) {
                comp = stringVal.toUpperCase().equals(COMPRESS.toString()) ? COMPRESS : NOCOMPRESS;
            }
            return comp;
        }

        public static Boolean convertToBoolean(OracleTableCompression comp) {
            Boolean retval = null;
            if (comp != null) {
                retval = comp == NOCOMPRESS ? Boolean.FALSE : Boolean.TRUE;
            }
            return retval;
        }
    }
}

