/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

public class OracleInMemoryColumnProperties
extends AbstractChildDBObject {
    public static final String TYPE = "OracleInMemoryColumnProperties";
    @PropertyKey(value=OracleInMemoryColumnProperties[].class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String CLAUSE_KEY = "OracleInMemoryColumnProperties";

    public OracleInMemoryColumnProperties() {
        this.setInMemory(true);
    }

    @Override
    public String getType() {
        return "OracleInMemoryColumnProperties";
    }

    public boolean isInMemory() {
        return (Boolean)this.getProperty("inMemory", true);
    }

    public void setInMemory(boolean im) {
        this.setProperty("inMemory", im);
    }

    public OracleInMemoryProperties.InMemoryCompression getInMemoryCompression() {
        return (OracleInMemoryProperties.InMemoryCompression)((Object)this.getProperty("inMemoryCompression"));
    }

    public void setInMemoryCompression(OracleInMemoryProperties.InMemoryCompression c) {
        this.setProperty("inMemoryCompression", (Object)c);
    }

    @References(value=Column.class, internal=true)
    public DBObjectID[] getColumnIDs() {
        return (DBObjectID[])this.getProperty("columnIDs");
    }

    public void setColumnIDs(DBObjectID[] colIDs) {
        this.setProperty("columnIDs", colIDs);
    }

    @Override
    @Transient
    public String getName() {
        Table tab;
        String retval = null;
        DBObjectID[] ids = this.getColumnIDs();
        if (ids != null && (tab = DBUtil.findParentOfType(this.getParent(), Table.class)) != null) {
            StringBuilder buff = new StringBuilder();
            for (DBObjectID id : this.getColumnIDs()) {
                DBObject c;
                String name = null;
                if (id instanceof BaseObjectID) {
                    name = ((BaseObjectID)id).getName();
                }
                if (!ModelUtil.hasLength(name) && (c = tab.findOwnedObject(id)) != null) {
                    name = c.getName();
                }
                if (!ModelUtil.hasLength((String)name)) continue;
                if (buff.length() > 0) {
                    buff.append(", ");
                }
                buff.append(name);
            }
            retval = buff.toString();
        }
        return retval;
    }
}

