/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

public class LOBDescriptor
extends AbstractChildDBObject {
    public static final String TYPE = "LOB DESCRIPTOR";
    @Deprecated
    public static final String LOB_PARAMETER_CACHE = LOBCache.CACHE.toString();
    @Deprecated
    public static final String LOB_PARAMETER_NOCACHE = LOBCache.NOCACHE.toString();
    @Deprecated
    public static final String LOB_PARAMETER_CACHEREADS = LOBCache.CACHE_READS.toString();

    public LOBDescriptor() {
        this.setRetention(false);
    }

    @Override
    public String getName() {
        Relation rel;
        String name = super.getName();
        if (!ModelUtil.hasLength((String)name) && (rel = this.findParent(Relation.class)) != null) {
            name = "";
            for (DBObjectID colID : this.getColumns()) {
                DBObject col;
                if (colID == null || !((col = rel.findOwnedObject(colID)) instanceof Column)) continue;
                if (name.length() > 0) {
                    name = name + ", ";
                }
                name = name + col.getName();
            }
            this.setName(name);
        }
        return name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setLOBSegName(String name) {
        this.setProperty("LOBSegName", name);
    }

    @TextProperty(internalName=true)
    public String getLOBSegName() {
        return (String)this.getProperty("LOBSegName");
    }

    public void setColumns(DBObjectID[] columns) {
        this.getChildSupport("columns").setChildArray(columns);
        this.setName(null);
    }

    public DBObjectID[] getColumns() {
        return this.getChildSupport("columns").getChildArray(DBObjectID.class);
    }

    public void addColumn(DBObjectID column) {
        if (column != null) {
            this.getChildSupport("columns").addChild(column);
            this.setName(null);
        }
    }

    public void removeColumn(DBObjectID column) {
        if (this.getChildSupport("columns").removeChild(column)) {
            this.setName(null);
        }
    }

    public void setChunk(Integer chunk) {
        this.setProperty("chunk", chunk);
    }

    public Integer getChunk() {
        return (Integer)this.getProperty("chunk");
    }

    public void setPctVersion(Integer pctVersion) {
        this.setProperty("pctVersion", pctVersion);
    }

    public Integer getPctVersion() {
        return (Integer)this.getProperty("pctVersion");
    }

    public void setFreepools(Integer freepools) {
        this.setProperty("freepools", freepools);
    }

    public Integer getFreepools() {
        return (Integer)this.getProperty("freepools");
    }

    public void setStorage(OracleStorageProperties storage) {
        this.setProperty("storage", storage);
    }

    public OracleStorageProperties getStorage() {
        return (OracleStorageProperties)this.getProperty("storage");
    }

    public void setRetention(boolean retention) {
        this.setProperty("retention", retention);
    }

    public boolean isRetention() {
        return (Boolean)this.getProperty("retention", false);
    }

    @Deprecated
    @Transient
    public void setStorageEnabledInRow(boolean storageEnabledInRow) {
        this.setStorageInRow(storageEnabledInRow);
    }

    @Deprecated
    public boolean isStorageEnabledInRow() {
        Boolean boo = this.getStorageInRow();
        return !Boolean.FALSE.equals(boo);
    }

    public void setStorageInRow(Boolean storageInRow) {
        this.setProperty("storageInRow", storageInRow);
    }

    public Boolean getStorageInRow() {
        return (Boolean)this.getProperty("storageInRow");
    }

    @Deprecated
    @Transient
    public void setCache(String cache) {
        this.setLOBCache((LOBCache)((Object)DBUtil.findEnumFromString(cache, LOBCache.class)));
    }

    @Deprecated
    public String getCache() {
        LOBCache lobCache = this.getLOBCache();
        return lobCache == null ? null : lobCache.toString();
    }

    public void setLOBCache(LOBCache cache) {
        this.setProperty("LOBCache", (Object)cache);
    }

    public LOBCache getLOBCache() {
        return (LOBCache)((Object)this.getProperty("LOBCache"));
    }

    @Deprecated
    public static boolean isLOBColumn(DBObjectID colID) {
        return false;
    }

    public static boolean isLOBColumn(DBObjectID colID, DBObject context) {
        Column col;
        boolean retval = false;
        Relation rel = DBUtil.findParentOfType(context, Relation.class);
        if (rel != null && LOBDescriptor.isLOBColumn(col = (Column)rel.findOwnedObject(colID))) {
            retval = true;
        }
        return retval;
    }

    public static boolean isLOBColumn(Column column) {
        DataTypeUsage dtu = column == null ? null : column.getDataTypeUsage();
        DBObjectID dtID = dtu == null ? null : dtu.getDataTypeID();
        return dtID instanceof DataTypeID && LOBDescriptor.isLOBType(((DataTypeID)dtID).getTypeName());
    }

    public static boolean isLOBType(DataType type) {
        boolean retval = false;
        if (type != null) {
            String name = type.getName();
            retval = LOBDescriptor.isLOBType(name);
        }
        return retval;
    }

    private static boolean isLOBType(String typeName) {
        return "BLOB".equalsIgnoreCase(typeName) || "CLOB".equalsIgnoreCase(typeName) || "NCLOB".equalsIgnoreCase(typeName);
    }

    @Deprecated
    public static boolean isVARRAYColumn(DBObjectID colID) {
        return false;
    }

    public static boolean isVARRAYColumn(DBObjectID colID, DBObject context) {
        Column col;
        boolean retval = false;
        Relation rel = DBUtil.findParentOfType(context, Relation.class);
        if (rel != null && LOBDescriptor.isVARRAYColumn(col = (Column)rel.findOwnedObject(colID))) {
            retval = true;
        }
        return retval;
    }

    public static boolean isVARRAYColumn(Column column) {
        boolean retval = false;
        try {
            DataTypeUsage dtu = column.getDataTypeUsage();
            if (dtu != null) {
                DataType typ = DataTypeHelper.getDataType(dtu, false);
                retval = LOBDescriptor.isVARRAYType(typ);
            }
        }
        catch (DBException e) {
            DBLog.getLogger(LOBDescriptor.class).fine(e.getMessage());
        }
        return retval;
    }

    public static boolean isVARRAYType(DataType type) {
        boolean retval = false;
        if (type instanceof Type) {
            retval = "VARYING ARRAY".equals(((Type)type).getCollectionType());
        }
        return retval;
    }

    public static enum LOBCache {
        CACHE,
        NOCACHE,
        CACHE_READS;


        public String toString() {
            return super.toString().replace('_', ' ');
        }
    }
}

