/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.DBObjectIDDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.GenericArrayDiffer;
import oracle.javatools.db.diff.GenericBeanDiffer;
import oracle.javatools.db.diff.GenericComparator;
import oracle.javatools.db.diff.GenericMapDiffer;
import oracle.javatools.db.diff.GenericNameDiffer;
import oracle.javatools.db.diff.GenericToStringDiffer;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.PlSqlFragmentSourceDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.diff.SQLFragmentComparator;
import oracle.javatools.db.diff.SQLFragmentDiffer;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

public class GenericDiffEngine {
    public static DiffEngine getDiffEngine(boolean strictIDComparison) {
        return GenericDiffEngine.getDiffEngine(strictIDComparison, true);
    }

    public static DiffEngine getDiffEngine(boolean strictIDComparison, boolean sqlTextCompare) {
        return GenericDiffEngine.getDiffEngine(strictIDComparison, strictIDComparison, sqlTextCompare);
    }

    public static DiffEngine getDiffEngine(boolean strictIDComparison, boolean strictInternalRefComparison, boolean sqlTextCompare) {
        DiffEngine engine = new DiffEngine(true);
        DiffEngine internalRefDelegate = null;
        DiffEngine internalRefDerivedPropBuilder = null;
        if (strictIDComparison != strictInternalRefComparison) {
            internalRefDelegate = GenericDiffEngine.getDiffEngine(strictInternalRefComparison, strictInternalRefComparison, sqlTextCompare);
        }
        if (!strictInternalRefComparison) {
            internalRefDerivedPropBuilder = sqlTextCompare ? GenericDiffEngine.getDiffEngine(false, false, false) : (strictIDComparison ? internalRefDelegate : engine);
        }
        engine.registerListDiffer(new ListDiffer(true), Object.class);
        engine.registerListDiffer(new ListDiffer(false), Constraint.class);
        engine.registerListDiffer(new ListDiffer(false), Index.class);
        engine.registerListDiffer(new SingleMatchListDiffer(), SQLFragment.class);
        engine.registerComparator(new DBObjectComparator(engine), DBObject.class);
        engine.registerComparator(new SQLFragmentComparator(engine), SQLFragment.class);
        engine.registerComparator(new DBObjectIDComparator(strictIDComparison), DBObjectID.class);
        engine.registerComparator(new GenericComparator(), Object.class);
        engine.registerDiffer(new GenericToStringDiffer(), Object.class);
        engine.registerDiffer(new GenericBeanDiffer(), Object.class);
        engine.registerDiffer(new GenericArrayDiffer(), Object.class);
        engine.registerDiffer(new GenericMapDiffer(), Map.class);
        engine.registerDiffer(new GenericNameDiffer(), Schema.class);
        engine.registerDiffer(new DBObjectIDDiffer(strictIDComparison), DBObjectID.class);
        engine.registerDiffer(new DBObjectDiffer(internalRefDelegate), AbstractDBObject.class);
        BuildableDBObjectDiffer buildableObjDiffer = new BuildableDBObjectDiffer(internalRefDelegate, internalRefDerivedPropBuilder);
        engine.registerDiffer(buildableObjDiffer, AbstractBuildableObject.class);
        if (sqlTextCompare) {
            engine.registerDiffer(new SQLFragmentDiffer(), SQLFragment.class);
            engine.registerDiffer(buildableObjDiffer, IndexObject.class);
        }
        engine.registerDiffer(new PlSqlFragmentSourceDiffer(), DBObjectPlSqlFragment.class);
        return engine;
    }

    private static class SingleMatchListDiffer
    extends ListDiffer {
        SingleMatchListDiffer() {
            super(true);
        }

        @Override
        public boolean diff(Object a, Object b, ResultSet rlist, DiffContext dc) {
            boolean retval;
            if (a instanceof List && b instanceof List && ((List)a).size() == 1 && ((List)b).size() == 1) {
                Object ao = ((List)a).get(0);
                Object bo = ((List)b).get(0);
                ResultSet rm = new ResultSet(rlist, ao, bo, 0, 0, null, "MAP");
                dc.getEngine().diff(ao, bo, rm, dc);
                rlist.setSame(rm.isSame());
                retval = true;
            } else {
                retval = super.diff(a, b, rlist, dc);
            }
            return retval;
        }
    }
}

