/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.property.PropertyAction;

public class DefaultTokenGenerator
extends TokenGenerator {
    private String m_code;
    private Collection<String> m_props;
    private Map<PropertyAction.ChildAction, Collection<String>> m_alterProps;
    private DBObjectProvider m_lastPropsPro;

    public DefaultTokenGenerator(String code) {
        this.m_code = code;
    }

    @Override
    public Object evaluateToken(TokenContext context) {
        return null;
    }

    @Override
    public void generateToken(TokenContext context) {
        this.getProcessor().process(this.m_code, context);
    }

    private void checkProvider(DBObjectProvider pro) {
        if (this.m_lastPropsPro != pro) {
            this.m_props = null;
            this.m_alterProps = null;
        }
    }

    @Override
    public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
        this.checkProvider(pro);
        if (this.m_props == null) {
            this.m_props = this.getProcessor().getCreatePropertyPathsImpl(this.m_code, type, pro);
            this.m_lastPropsPro = pro;
        }
        return this.m_props;
    }

    @Override
    public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String type, DBObjectProvider pro) {
        this.checkProvider(pro);
        if (this.m_alterProps == null) {
            this.m_alterProps = this.getProcessor().getAlterPropertyPathsImpl(this.m_code, type, pro);
            this.m_lastPropsPro = pro;
        }
        return this.m_alterProps;
    }
}

