/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.util.ModelUtil;

public class DataTypeSynonym
extends AbstractDBObject
implements DataType {
    private DataType m_delegate;
    private String m_definition;
    private TokenPattern m_search;

    public DataTypeSynonym() {
    }

    public DataTypeSynonym(String name, DataType synonymFor) {
        assert (name != null);
        assert (synonymFor != null);
        this.m_delegate = synonymFor;
        this.setName(name);
    }

    public DataType getBaseType() {
        return this.m_delegate;
    }

    @Override
    public Integer getSQLType() {
        return this.m_delegate.getSQLType();
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return this.m_delegate.getDataTypeAttributes();
    }

    @Override
    public boolean hasDataTypeAttribute(String name) {
        return this.m_delegate.hasDataTypeAttribute(name);
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String name) {
        return this.m_delegate.getDataTypeAttribute(name);
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        String retval;
        if (this.m_delegate instanceof PredefinedDataType && ((PredefinedDataType)this.m_delegate).getDefinitionForSearch().contains(this.m_delegate.getName())) {
            retval = this.m_delegate.getDDL(dataTypeUsage).replaceFirst(Pattern.quote(this.m_delegate.getName()), this.getName());
        } else {
            PredefinedDataType.DDLGenImpl c = new PredefinedDataType.DDLGenImpl(this.getDefinition());
            retval = c.getDDL(dataTypeUsage.getAttributeValues());
        }
        return retval;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        DataTypeUsage usage = this.m_delegate.createDefaultUsage();
        usage.setDataTypeID(this.getID());
        return usage;
    }

    public DataTypeUsage createUsage(Map attributes) {
        String nameAttr;
        if (attributes != null && (nameAttr = (String)attributes.get("name")) != null) {
            nameAttr = nameAttr.replaceAll(this.getName(), this.m_delegate.getName());
            attributes.put("name", nameAttr);
        }
        DataTypeUsage usage = this.m_delegate.createUsage(attributes);
        usage.setDataTypeID(this.getID());
        return usage;
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
    }

    @Override
    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        DataTypeSynonym target = (DataTypeSynonym)other;
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_delegate = this.m_delegate;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject other) {
        DataTypeSynonym target = (DataTypeSynonym)other;
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)target.m_delegate, (Object)this.m_delegate);
    }

    @Override
    public String getType() {
        return this.m_delegate == null ? null : this.m_delegate.getType();
    }

    @Override
    public boolean matches(String usageString) {
        return DataTypeHelper.matches(this.getSearch(), usageString) != null;
    }

    @Override
    public DataTypeUsage createUsage(String usageString) {
        return DataTypeHelper.getUsageFromString(this, this.getSearch(), usageString);
    }

    private String getDefinition() {
        String retval = this.m_definition;
        if (retval == null) {
            String name = this.getName();
            if (this.m_delegate instanceof PredefinedDataType) {
                String pdtName;
                PredefinedDataType pdt = (PredefinedDataType)this.m_delegate;
                String definition = pdt.getDefinitionForSearch();
                if (definition.contains(pdtName = pdt.getName())) {
                    definition = definition.replace(pdtName, name);
                } else {
                    String[] pdtNameToks = pdtName.split("\\s", 2);
                    if (pdtNameToks.length == 2 && definition.contains(pdtNameToks[0]) && name.endsWith(pdtNameToks[1])) {
                        String newStart = name.substring(0, name.length() - pdtNameToks[1].length()).trim();
                        definition = definition.replaceFirst(Pattern.quote(pdtNameToks[0]), newStart);
                    } else {
                        definition = null;
                    }
                }
                this.m_definition = retval = definition;
            }
            if (retval == null) {
                retval = "";
                DBLog.getLogger(this).severe("Cannot create search definition for " + name);
            }
        }
        return retval;
    }

    private TokenPattern getSearch() {
        TokenPattern retval = this.m_search;
        if (retval == null) {
            String definition = this.getDefinition();
            this.m_search = retval = DataTypeHelper.buildSearch(definition, this.getDataTypeAttributes());
        }
        return retval;
    }
}

