/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public final class DataTypeRegistry {
    private final Object m_lock = new Object();
    private final Map<Class, Object> m_dataTypes = new HashMap<Class, Object>();
    private final Map<DataType, DataType> m_synonyms = new HashMap<DataType, DataType>();
    private final Map<Class, Object> m_registered = new HashMap<Class, Object>();
    private final Collection<String> m_attributeNames = new HashSet<String>();
    private final Collection<String> m_genericJdbcClasses = new HashSet<String>();

    private DataTypeRegistry() {
        this.m_genericJdbcClasses.add(JdbcDatabase.class.getName());
    }

    public boolean isRegistered(Class<? extends Database> dbClz) {
        boolean retval = false;
        for (Class<? extends Database> queryClass = dbClz; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            if (!this.m_dataTypes.containsKey(queryClass)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataTypesImpl(Class<? extends Database> provider, boolean incSuperClasses, Collection<DataType> types, String dataTypeName) {
        DatabaseDescriptor desc = DatabaseFactory.getDatabaseDescriptor(provider);
        boolean registrationFound = incSuperClasses ? false : this.isRegistered(provider);
        for (Class<? extends Database> queryClass = provider; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            Object object = this.m_lock;
            synchronized (object) {
                Object entry = this.m_dataTypes.get(queryClass);
                registrationFound |= entry != null;
                if (entry instanceof Thunk) {
                    entry = ((Thunk)entry).get();
                }
                if (entry instanceof Registerer) {
                    this.m_dataTypes.remove(queryClass);
                    this.m_registered.put(queryClass, entry);
                    ((Registerer)entry).registerDataTypes(this);
                    entry = this.m_dataTypes.get(queryClass);
                }
                if (entry instanceof Map) {
                    Map typeMap = (Map)entry;
                    if (dataTypeName == null) {
                        types.addAll(typeMap.values());
                    } else {
                        DataType dt = (DataType)typeMap.get(dataTypeName);
                        if (dt != null) {
                            types.add(dt);
                            incSuperClasses = false;
                        }
                    }
                }
            }
            if (incSuperClasses) {
                continue;
            }
            queryClass = null;
            break;
        }
        if (!registrationFound) {
            if (dataTypeName == null) {
                types.addAll(desc.listSupportedDataTypes());
            } else {
                types.add(desc.getDataType(dataTypeName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProvider(Registerer reg, Class<? extends Database> provider) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_registered.containsKey(provider)) {
                this.m_dataTypes.put(provider, reg);
            }
        }
    }

    public void registerDataType(DataType type, Class<? extends Database> provider) {
        this.registerDataType(type, provider, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataType(DataType type, Class<? extends Database> provider, DataType ansiType) {
        Object object = this.m_lock;
        synchronized (object) {
            String name;
            Object entry = this.m_dataTypes.get(provider);
            if (entry instanceof Registerer) {
                throw new IllegalArgumentException("Cannot register datatypes for this provider - it has a Registerer for that purpose.");
            }
            HashMap<String, DataType> types = (HashMap<String, DataType>)entry;
            if (types == null) {
                types = new HashMap<String, DataType>();
                this.m_dataTypes.put(provider, types);
            }
            if (types.containsKey(name = type.getName().toUpperCase())) {
                DBLog.getLogger(this).log(Level.WARNING, "Duplicate datatype for " + provider.getName() + " registered: " + name);
            }
            types.put(name, type);
            this.registerAttributes(type);
            type.setID(new DataTypeID(name, DatabaseFactory.getDatabaseDescriptor(provider)));
            if (ansiType != null) {
                this.mapToAnsiType(type, ansiType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAttributes(DataType type) {
        Object object = this.m_lock;
        synchronized (object) {
            for (DataTypeAttribute attr : type.getDataTypeAttributes()) {
                this.m_attributeNames.add(attr.getName());
            }
        }
    }

    @Deprecated
    public void registerComplexType(Type type, Class<? extends Database> provider) {
    }

    @Deprecated
    public DataType createUserDataType(String name, Class<? extends Database> proClz) {
        UserDataType type = new UserDataType(name);
        type.setID(TemporaryObjectID.createID(type));
        return type;
    }

    public DataType createUserDataType(String name, DBObjectProvider pro) {
        UserDataType type = new UserDataType(name);
        ReferenceID id = new ReferenceID("DATATYPE", (String)null, name);
        id.setProvider(pro);
        type.setID(id);
        return type;
    }

    public DataType findDataType(String name, Class provider) {
        DataType type = null;
        if (ModelUtil.hasLength((String)name) && (type = this.findDataType(name, provider, true)) == null && provider != null && JdbcDatabase.class.isAssignableFrom(provider)) {
            return this.findAnsiType(name);
        }
        return type;
    }

    private DataType findDataType(String name, Class provider, boolean incSuperClasses) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        this.getDataTypesImpl(provider, incSuperClasses, types, name.toUpperCase());
        return types.size() > 0 ? (DataType)types.get(0) : null;
    }

    @Deprecated
    public Type findComplexType(String name, String schemaName, Class provider) {
        return null;
    }

    public DataType[] listDataTypes(Class provider) {
        return this.listDataTypes(provider, true);
    }

    DataType[] listDataTypes(Class provider, boolean incSuperClasses) {
        ArrayList<DataType> types = new ArrayList<DataType>();
        this.getDataTypesImpl(provider, incSuperClasses, types, null);
        return types.toArray(new DataType[types.size()]);
    }

    @Deprecated
    public Type[] listComplexTypes(String schemaName, Class provider) {
        return new Type[0];
    }

    @Deprecated
    public String[] listComplexTypeSchemas(Class provider) {
        return new String[0];
    }

    public boolean isRegisteredType(DataType type) {
        return type.getID() instanceof DataTypeID;
    }

    public boolean isRegisteredAttribute(String attrName) {
        return this.m_attributeNames.contains(attrName);
    }

    public DataType registerSynonym(String synonym, DataType baseType, Class<? extends Database> provider) {
        DataTypeSynonym synType = new DataTypeSynonym(synonym, baseType);
        this.registerSynonym(synType, baseType, provider);
        return synType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynonym(DataType synonymType, DataType baseType, Class<? extends Database> provider) {
        Object object = this.m_lock;
        synchronized (object) {
            this.registerDataType(synonymType, provider);
            this.m_synonyms.put(synonymType, baseType);
        }
    }

    public boolean isSynonymType(DataType type) {
        return this.m_synonyms.containsKey(type);
    }

    public DataType getBaseType(DataType synonym) {
        return this.m_synonyms.get(synonym);
    }

    public DataType findAnsiType(String name) {
        return DatabaseFactory.getDatabaseDescriptor(JdbcDatabase.class).getDataType(name);
    }

    public DataType[] getAnsiTypes() {
        Collection<DataType> ansiTypes = DatabaseFactory.getDatabaseDescriptor(JdbcDatabase.class).listSupportedDataTypes();
        return ansiTypes.toArray(new DataType[ansiTypes.size()]);
    }

    @Deprecated
    public void mapToAnsiType(DataType type, String ansiTypeName) {
    }

    public void mapToAnsiType(DataType type, DataType ansiType) {
        if (type instanceof PredefinedDataType && type.getSQLType() == null) {
            if (ansiType.getSQLType() == null) {
                ansiType = this.findAnsiType(ansiType.getName());
            }
            if (ansiType != null) {
                ((PredefinedDataType)type).setSQLType(ansiType.getSQLType());
            }
        }
    }

    @Deprecated
    public DataType getMappedAnsiType(DataType type) {
        return null;
    }

    @Deprecated
    public DataType getMappedType(String ansiTypeName, Class<? extends Database> provider) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTypeRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        Class<DataTypeRegistry> clazz = DataTypeRegistry.class;
        synchronized (DataTypeRegistry.class) {
            DataTypeRegistry dtr = core.get(DataTypeRegistry.class);
            if (dtr == null) {
                dtr = new DataTypeRegistry();
                core.put(dtr);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dtr;
        }
    }

    public static final void registerGenericJdbcClass(String clzName) {
        DataTypeRegistry.getInstance().m_genericJdbcClasses.add(clzName);
    }

    @Deprecated
    public static final void registerGenericJdbcClass(Class<? extends JdbcDatabase> clz) {
        DataTypeRegistry.registerGenericJdbcClass(clz.getName());
    }

    public static final boolean isGenericJdbcClass(Class clz) {
        return DataTypeRegistry.getInstance().m_genericJdbcClasses.contains(clz.getName());
    }

    public static class Registerer {
        protected void registerDataTypes(DataTypeRegistry dtr) {
        }

        @Deprecated
        protected void registerComplexTypes(DataTypeRegistry dtr) {
        }

        @Deprecated
        protected boolean includeSuperclassTypes() {
            return true;
        }

        @Deprecated
        protected boolean includeComplexTypes(String schemaName) {
            return true;
        }
    }
}

