/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.marshal.AbstractResourceCache;
import oracle.javatools.util.ModelUtil;

public class DataTypeCache
extends AbstractResourceCache {
    private final Map<String, DataType> m_dataTypes = new TreeMap<String, DataType>();
    private final Map<String, Integer> m_sqlTypes = new HashMap<String, Integer>();
    private DatabaseDescriptor m_jdbcDescriptor;
    private ResourceBundle m_bundle;

    public DataTypeCache(DatabaseDescriptor desc, String resourceDir) {
        super(desc, resourceDir);
    }

    private void checkTypeName(String dataTypeName) {
        if (!ModelUtil.hasLength((String)dataTypeName)) {
            throw new IllegalArgumentException("All types must have a non-empty name.");
        }
        if (this.m_dataTypes.containsKey(dataTypeName)) {
            throw new IllegalArgumentException(dataTypeName + " already registered");
        }
    }

    private void registerDataType(String dataTypeName, DataType dt) {
        this.checkTypeName(dataTypeName);
        this.m_dataTypes.put(dataTypeName, dt);
        dt.setID(new DataTypeID(dataTypeName, this.getDatabaseDescriptor()));
        if (dt instanceof PredefinedDataType) {
            DataTypeRegistry.getInstance().registerAttributes(dt);
        }
    }

    public final void registerDataType(DataType dt) {
        this.registerDataType(dt.getName(), dt);
    }

    public final void registerDataTypeResource(PredefinedDataType dt) {
        String dataTypeName = dt.getName();
        this.registerDataTypeResource(dataTypeName, dt);
    }

    public final void registerDataType(String dataTypeName) {
        PredefinedDataType dt = new PredefinedDataType(dataTypeName);
        this.registerDataTypeResource(dataTypeName, dt);
    }

    private void registerDataTypeResource(String dataTypeName, PredefinedDataType dt) {
        this.markForLazyInit(dt, this.getResourcePath(dataTypeName + ".xml"));
        this.registerDataType(dataTypeName, dt);
    }

    public final void registerDataTypeSynonym(String dataTypeName, String baseTypeName) {
        DataType baseType = this.m_dataTypes.get(baseTypeName);
        if (baseType == null) {
            throw new IllegalArgumentException(baseTypeName + " is not registered.");
        }
        if (baseType instanceof DataTypeSynonym) {
            throw new IllegalArgumentException(baseTypeName + " is already a synonym.");
        }
        DataTypeSynonym dts = new DataTypeSynonym(dataTypeName, baseType);
        this.registerDataType(dataTypeName, dts);
    }

    public Collection<DataType> listSupportedDataTypes() {
        Collection<DataType> dts = this.m_dataTypes.values();
        return new ArrayList<DataType>(dts);
    }

    public DataType getDataType(String dataTypeName) {
        return this.m_dataTypes.get(dataTypeName);
    }

    public int getDataTypeCount() {
        return this.m_dataTypes.size();
    }

    public final void setResourceBundle(ResourceBundle bundle) {
        this.m_bundle = bundle;
    }

    @Override
    protected void lazyObjectBuilt(DBObject obj) {
        if (obj instanceof PredefinedDataType) {
            PredefinedDataType dt = (PredefinedDataType)obj;
            if (dt.getSQLType() == null) {
                DataType jdbcType;
                Integer sqlType;
                String name = dt.getName();
                DatabaseDescriptor jdbcDesc = this.getJdbcDescriptor();
                if (jdbcDesc != null && (sqlType = (jdbcType = jdbcDesc.getDataType(name)) != null ? jdbcType.getSQLType() : this.getSQLType(name)) != null) {
                    dt.setSQLType(sqlType);
                }
            }
            if (this.m_bundle != null) {
                for (DataTypeAttribute dta : dt.getDataTypeAttributes()) {
                    dta.setResourceBundle(this.m_bundle);
                }
            }
        }
    }

    private DatabaseDescriptor getJdbcDescriptor() {
        if (this.m_jdbcDescriptor == null) {
            this.m_jdbcDescriptor = DatabaseRegistry.getInstance().getDatabaseDescriptor("Generic JDBC", 0);
        }
        return this.m_jdbcDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getSQLType(String name) {
        Map<String, Integer> map = this.m_sqlTypes;
        synchronized (map) {
            if (this.m_sqlTypes.size() == 0) {
                for (Field f : Types.class.getDeclaredFields()) {
                    try {
                        this.m_sqlTypes.put(f.getName(), (Integer)f.get(null));
                    }
                    catch (Exception e) {
                        this.getLogger().finest(e.getMessage());
                    }
                }
            }
        }
        return this.m_sqlTypes.get(name);
    }
}

