/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;

public abstract class Relation
extends AbstractSchemaObject {
    protected Relation() {
    }

    protected Relation(String name, Schema schema) {
        super(name, schema);
    }

    public void setColumns(Column[] newCols) {
        this.getChildSupport("columns").setChildArray(newCols);
    }

    public Column[] getColumns() {
        return this.getChildSupport("columns").getChildArray(Column.class);
    }

    public void addColumn(Column col) {
        this.getChildSupport("columns").addChild(col);
    }

    public void addColumn(int index, Column col) {
        this.getChildSupport("columns").addChild(index, col);
    }

    public Column getColumn(String name) {
        return (Column)this.getChildSupport("columns").findChild(name);
    }

    public void removeColumn(Column col) {
        this.getChildSupport("columns").removeChild(col);
    }

    public Constraint[] getConstraints() {
        return this.getChildSupport("constraints").getChildArray(Constraint.class);
    }

    public void setConstraints(Constraint[] constraints) {
        this.getChildSupport("constraints").setChildArray(constraints);
    }

    public Constraint getConstraint(String name) {
        return (Constraint)this.getChildSupport("constraints").findChild(name);
    }

    public void addConstraint(Constraint constraint) {
        this.getChildSupport("constraints").addChild(constraint);
    }

    public void removeConstraint(Constraint constraint) {
        this.getChildSupport("constraints").removeChild(constraint);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String ... types) {
        super.getOwnedObjectsImpl(c, types);
        if (types != null) {
            boolean checkCons = false;
            Collection<String> cTypes = Constraint.getConstraintTypes();
            for (String type : types) {
                if (!cTypes.contains(type)) continue;
                checkCons = true;
                break;
            }
            if (checkCons) {
                for (Constraint con : this.getConstraints()) {
                    if (!this.includesType(con.getConstraintType(), types)) continue;
                    c.add(con);
                }
            }
        }
    }
}

