/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.BuiltInObjectCache;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.extension.ConnectionMatcher;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public final class DatabaseRegistry {
    private final MultiMap<String, DatabaseIdentifier> m_databases = new MultiMap();
    private final Map<String, ClassLoader> m_classloaders = new HashMap<String, ClassLoader>();

    private DatabaseRegistry() {
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    void checkInit() {
        DBCore.checkExtensionInitialization();
    }

    @Deprecated
    public void registerDatabase(String type, int version, String nlsName, String databaseImplName, String databaseCreatorClassName, ClassLoader classLoader) {
        this.registerDatabases(type, databaseCreatorClassName, classLoader, null, new DatabaseVersion(version, nlsName, databaseImplName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatabases(String type, String databaseCreatorClassName, ClassLoader classLoader, ConnectionMatcher matcher, DatabaseVersion ... infos) {
        DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
        boolean genericJDBC = "Generic JDBC".equals(type);
        if (type != null && infos != null) {
            MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
            synchronized (multiMap) {
                for (DatabaseVersion info : infos) {
                    if (genericJDBC && info.m_version != 0) {
                        throw new IllegalArgumentException("Cannot register new versions for Generic JDBC");
                    }
                    this.m_databases.add((Object)type, (Object)new DatabaseIdentifier(type, info));
                    if (classLoader != null) {
                        this.m_classloaders.put(info.m_dbImplClassName, classLoader);
                    }
                    databaseFactory.registerDatabaseImplementation(info.m_dbImplClassName, databaseCreatorClassName);
                }
            }
        }
        if (genericJDBC) {
            databaseFactory.setJdbcDatabaseCreator(databaseCreatorClassName);
        } else {
            databaseFactory.registerDatabaseCreator(databaseCreatorClassName, classLoader, matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listDatabaseTypes() {
        this.checkInit();
        MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
        synchronized (multiMap) {
            return new ArrayList<String>(this.m_databases.keySet());
        }
    }

    public List<Integer> listDatabaseVersions(String type) {
        return this.listDatabaseVersions(type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> listDatabaseVersions(String type, boolean incLegacy) {
        this.checkInit();
        ArrayList<Integer> retval = new ArrayList<Integer>();
        MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
        synchronized (multiMap) {
            Collection idents = this.m_databases.get((Object)type);
            if (idents != null) {
                for (DatabaseIdentifier ident : idents) {
                    if (!incLegacy && ident.m_legacy) continue;
                    retval.add(ident.m_version);
                }
                Collections.sort(retval);
            }
        }
        return retval;
    }

    public DatabaseDescriptor getDatabaseDescriptor(String type, int version) {
        DatabaseDescriptor retval = null;
        DatabaseIdentifier ident = this.getDatabaseIdentifier(type, version);
        if (ident != null) {
            retval = ident.getDescriptor();
        }
        return retval;
    }

    public boolean isLegacyVersion(String type, int version) {
        boolean retval = true;
        DatabaseIdentifier ident = this.getDatabaseIdentifier(type, version);
        if (ident != null) {
            retval = ident.m_legacy;
        }
        return retval;
    }

    DataTypeCache getDataTypeCache(String type, int version) {
        DataTypeCache retval = null;
        DatabaseIdentifier ident = this.getDatabaseIdentifier(type, version);
        if (ident != null) {
            retval = ident.getDataTypeCache();
        }
        return retval;
    }

    BuiltInObjectCache getBuiltInObjectCache(String type, int version) {
        BuiltInObjectCache retval = null;
        DatabaseIdentifier ident = this.getDatabaseIdentifier(type, version);
        if (ident != null) {
            retval = ident.getBuiltInObjectCache();
        }
        return retval;
    }

    public Class<? extends Database> loadDatabaseClass(String clzName) {
        this.checkInit();
        ClassLoader cl = this.m_classloaders.get(clzName);
        if (cl == null) {
            cl = DBCore.getImplClassLoader();
        }
        Class<?> retval = null;
        try {
            Class<?> loaded = cl.loadClass(clzName);
            if (Database.class.isAssignableFrom(loaded)) {
                retval = loaded;
            } else {
                this.getLogger().severe(clzName + " is not a Database implementation");
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe("Couldn't find database class " + clzName);
        }
        return retval;
    }

    public String getDatabaseName(String type, int ver) {
        DatabaseIdentifier ident = this.getDatabaseIdentifier(type, ver);
        return ident == null ? null : ident.m_nlsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseIdentifier getDatabaseIdentifier(String type, int ver) {
        this.checkInit();
        DatabaseIdentifier retval = null;
        MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
        synchronized (multiMap) {
            Collection idents = this.m_databases.get((Object)type);
            if (idents != null) {
                for (DatabaseIdentifier ident : idents) {
                    if (ident.m_version != ver) continue;
                    retval = ident;
                    break;
                }
            }
        }
        return retval;
    }

    boolean isRegisteredDatabase(String className) {
        return this.getIdentifier(className) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseIdentifier getIdentifier(String className) {
        DatabaseIdentifier retval = null;
        if (className != null) {
            MultiMap<String, DatabaseIdentifier> multiMap = this.m_databases;
            synchronized (multiMap) {
                block3: for (Map.Entry entry : this.m_databases.entrySet()) {
                    for (DatabaseIdentifier ident : (Collection)entry.getValue()) {
                        if (!ModelUtil.areEqual((Object)className, (Object)ident.m_dbClassName)) continue;
                        retval = ident;
                        break block3;
                    }
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        DatabaseRegistry retval = core.get(DatabaseRegistry.class);
        if (retval != null) return retval;
        Class<DatabaseRegistry> clazz = DatabaseRegistry.class;
        synchronized (DatabaseRegistry.class) {
            retval = core.get(DatabaseRegistry.class);
            if (retval != null) return retval;
            retval = new DatabaseRegistry();
            core.put(retval);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retval;
        }
    }

    public static class DatabaseVersion {
        private final int m_version;
        private final String m_nlsName;
        private final String m_dbImplClassName;
        private final boolean m_legacy;

        public DatabaseVersion(int version, String nlsName, String dbImplClassName) {
            this(version, nlsName, dbImplClassName, nlsName == null);
        }

        public DatabaseVersion(int version, String nlsName, String dbImplClassName, boolean legacy) {
            this.m_version = version;
            this.m_nlsName = nlsName;
            this.m_dbImplClassName = dbImplClassName;
            this.m_legacy = legacy;
            if (this.m_nlsName == null && !legacy) {
                DBLog.getLogger(DatabaseVersion.class).log(Level.SEVERE, "Supported versions must have an nls name", new IllegalArgumentException());
            }
        }

        public final int getVersion() {
            return this.m_version;
        }

        public final String getName() {
            return this.m_nlsName;
        }

        public final String getDatabaseClassName() {
            return this.m_dbImplClassName;
        }
    }

    private class DatabaseIdentifier {
        private final String m_type;
        private final int m_version;
        private final String m_dbClassName;
        private final String m_nlsName;
        private final boolean m_legacy;
        private Reference<DatabaseDescriptor> m_desc;
        private Reference<DataTypeCache> m_dataTypes;
        private boolean m_dataTypesIsNull;
        private Reference<BuiltInObjectCache> m_builtInObjs;
        private boolean m_builtInObjsIsNull;

        DatabaseIdentifier(String type, DatabaseVersion version) {
            this.m_type = type;
            this.m_version = version.m_version;
            this.m_dbClassName = version.m_dbImplClassName;
            this.m_nlsName = version.m_nlsName;
            this.m_legacy = version.m_legacy;
        }

        public synchronized DatabaseDescriptor getDescriptor() {
            DatabaseDescriptor retval;
            DatabaseDescriptor databaseDescriptor = retval = this.m_desc == null ? null : this.m_desc.get();
            if (retval == null) {
                Class<? extends Database> dbClz;
                DatabaseFactory.DatabaseCreator creator = DatabaseFactory.getInstance().findDatabaseCreator(this.m_dbClassName);
                if (creator != null) {
                    retval = creator.getDatabaseDescriptorImpl(this.m_type, this.m_version);
                }
                if (retval == null && (dbClz = DatabaseRegistry.this.loadDatabaseClass(this.m_dbClassName)) != null) {
                    retval = DatabaseFactory.getDatabaseDescriptor(dbClz);
                }
                if (retval != null) {
                    this.m_desc = new WeakReference<DatabaseDescriptor>(retval);
                }
            }
            return retval;
        }

        public synchronized DataTypeCache getDataTypeCache() {
            DataTypeCache retval;
            DataTypeCache dataTypeCache = retval = this.m_dataTypes == null ? null : this.m_dataTypes.get();
            if (retval == null && !this.m_dataTypesIsNull) {
                DatabaseDescriptor desc = this.getDescriptor();
                String resource = this.createResourceRoot(desc, "datatypes");
                retval = new DataTypeCache(desc, resource);
                desc.registerDataTypes(retval);
                if (retval.getDataTypeCount() == 0) {
                    this.m_dataTypesIsNull = true;
                    retval = null;
                } else {
                    this.m_dataTypes = new WeakReference<DataTypeCache>(retval);
                }
            }
            return retval;
        }

        private String createResourceRoot(DatabaseDescriptor desc, String subdir) {
            String pkg = desc.getClass().getPackage().getName();
            String retval = pkg.replace('.', '/') + "/resource/" + subdir;
            int version = desc.getDatabaseVersion();
            List<Integer> allVers = DatabaseRegistry.this.listDatabaseVersions(desc.getDatabaseType());
            if (allVers.size() > 0 && version != allVers.get(0)) {
                retval = retval + "/" + version;
            }
            return retval;
        }

        public synchronized BuiltInObjectCache getBuiltInObjectCache() {
            BuiltInObjectCache retval;
            BuiltInObjectCache builtInObjectCache = retval = this.m_builtInObjs == null ? null : this.m_builtInObjs.get();
            if (retval == null && !this.m_builtInObjsIsNull) {
                DatabaseDescriptor desc = this.getDescriptor();
                String resource = this.createResourceRoot(desc, "objects");
                retval = new BuiltInObjectCache(desc, resource);
                desc.registerBuiltInObjects(retval);
                if (retval.isEmpty()) {
                    this.m_builtInObjsIsNull = true;
                } else {
                    this.m_builtInObjs = new WeakReference<BuiltInObjectCache>(retval);
                }
            }
            return retval;
        }

        public boolean equals(Object other) {
            boolean retval = false;
            if (other instanceof DatabaseIdentifier) {
                retval = this.m_version == ((DatabaseIdentifier)other).m_version && ModelUtil.areEqual((Object)this.m_type, (Object)((DatabaseIdentifier)other).m_type);
            }
            return retval;
        }
    }
}

