/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.util.ModelUtil;

public class DBLog {
    private static final String BASE_LOG_NAME = "oracle.javatools.db";
    private static final String SQL_LOG_NAME = "oracle.javatools.db.statement";
    private static final String LOG_PROPERTY = "db.log";
    private static Map<String, Logger> s_loggers = new HashMap<String, Logger>();
    private static boolean s_override;

    public static final Logger getLogger() {
        return DBLog.getAndInitialiseLogger(BASE_LOG_NAME);
    }

    public static final Logger getLogger(Object obj) {
        String clzName;
        String loggerName;
        Class<?> clz;
        if (obj == null) {
            return DBLog.getLogger();
        }
        Class<?> clazz = clz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (clz.isArray()) {
            clz = clz.getComponentType();
        }
        if (!((loggerName = (clzName = clz.getName())).startsWith("oracle.") || loggerName.contains("db") && loggerName.contains("report"))) {
            Logger logger = DBLog.getLogger();
            logger.log(Level.WARNING, "Invalid log requested: " + loggerName, new IllegalArgumentException(loggerName));
            return logger;
        }
        return DBLog.getAndInitialiseLogger(loggerName);
    }

    public static final synchronized Logger getAndInitialiseLogger(String name) {
        Logger logger = Logger.getLogger(name);
        if (!s_loggers.containsKey(name)) {
            DBLog.initLogger(logger);
            s_loggers.put(name, logger);
        }
        return logger;
    }

    public static final Level getTimingLogLevel() {
        return Level.FINER;
    }

    public static final Level getTraceLogLevel() {
        return Level.FINER;
    }

    public static final Level getEventLogLevel() {
        return Level.FINE;
    }

    public static final void logStackTrace(Throwable t) {
        DBLog.getLogger().log(DBLog.getTraceLogLevel(), t.getMessage(), t);
    }

    public static final void log(String msg, Object ... params) {
        DBLog.getLogger().log(DBLog.getTraceLogLevel(), msg, params);
    }

    public static final void logDifferences(DBObject obj1, DBObject obj2, DBObjectProvider pro) {
        if (DBLog.getLogger().isLoggable(DBLog.getTraceLogLevel()) && pro != null) {
            DiffEngine de = pro.getDiffEngine();
            de.difference(obj1, obj2).print();
        }
    }

    public static final Logger getSQLLog() {
        return DBLog.getAndInitialiseLogger(SQL_LOG_NAME);
    }

    private static String getSysLogProperty() {
        String prop = System.getProperty(LOG_PROPERTY);
        return prop;
    }

    public static void initLogger(Logger logger) {
        block7: {
            try {
                String prop = DBLog.getSysLogProperty();
                if (!ModelUtil.hasLength((String)prop)) break block7;
                Level level = null;
                if (Boolean.valueOf(prop).booleanValue()) {
                    level = Level.ALL;
                } else {
                    try {
                        level = Level.parse(prop.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (level != null && !s_override) {
                    logger.setLevel(level);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

