/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.text.Collator;
import java.util.Locale;
import oracle.bali.inspector.PropertyGroup;
import oracle.ide.inspector.layout.CategoryLayout;

final class PropertyGroupNode
implements Comparable {
    private final PropertyGroup group;
    private final CategoryLayout categoryLayout;

    public PropertyGroupNode(PropertyGroup group) {
        this(group, null);
    }

    public PropertyGroupNode(PropertyGroup group, CategoryLayout categoryLayout) {
        this.group = group;
        this.categoryLayout = categoryLayout;
    }

    public PropertyGroup getPropertyGroup() {
        return this.group;
    }

    public CategoryLayout getCategoryLayout() {
        return this.categoryLayout;
    }

    public String getName() {
        return this.group != null ? this.group.getName(this.getLocale()) : "";
    }

    public int compareTo(Object o) {
        PropertyGroupNode other = (PropertyGroupNode)o;
        return Collator.getInstance(this.getLocale()).compare(this.toString(), other.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyGroupNode)) {
            return false;
        }
        PropertyGroupNode other = (PropertyGroupNode)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }
}

