/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editors.ApplyValueActionListener;
import oracle.bali.inspector.editors.ApplyValueFocusListener;
import oracle.bali.inspector.editors.CancelEditionKeyListener;
import oracle.bali.inspector.editors.ComboBoxInlineEditor;
import oracle.bali.inspector.editors.EditableTextFieldInlineEditor;

final class PropertyEditorListeners {
    static void addPropertyInspectorListeners(Component editor, PropertyEditorFactory2 editorFactory) {
        if (editor instanceof EditableTextFieldInlineEditor) {
            return;
        }
        if (editor instanceof ComboBoxInlineEditor) {
            return;
        }
        if (PropertyEditorListeners.inspectorListenersAdded(editor, editorFactory)) {
            return;
        }
        PropertyEditorListeners.addApplyValueFocusListener(editor, editorFactory);
    }

    private static boolean inspectorListenersAdded(Component editor, PropertyEditorFactory2 editorFactory) {
        if (editor instanceof JTextComponent) {
            PropertyEditorListeners.addListeners((JTextComponent)editor, editorFactory);
            if (editor instanceof JTextField) {
                PropertyEditorListeners.addListeners((JTextField)editor, editorFactory);
            }
            return true;
        }
        return editor instanceof JComboBox;
    }

    private static void addListeners(JTextComponent editor, PropertyEditorFactory2 editorFactory) {
        ApplyValueFocusListener.instance().addListenerToEditor(editor, editorFactory);
        CancelEditionKeyListener.instance().addListenerToEditor(editor, editorFactory);
    }

    private static void addListeners(JTextField editor, PropertyEditorFactory2 editorFactory) {
        ApplyValueActionListener.instance().addListenerToEditor(editor, editorFactory);
    }

    private static void addApplyValueFocusListener(final Component editor, final PropertyEditorFactory2 editorFactory) {
        FocusAdapter l = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                editorFactory.applyValueFrom(editor);
            }
        };
        PropertyEditorListeners.addFocusListenerToEditor(editor, l);
    }

    static void addFocusListenerToEditor(Component editor, FocusListener l) {
        if (editor instanceof Container) {
            Container p = (Container)editor;
            for (Component c : p.getComponents()) {
                if (!c.isFocusable()) continue;
                c.addFocusListener(l);
            }
        }
        if (editor.isFocusable()) {
            editor.addFocusListener(l);
        }
    }

    private PropertyEditorListeners() {
    }
}

