/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerThreadsWindowOptions;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.ThreadsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;
import oracle.jdevimpl.runner.debug.Utils;

final class ThreadsWindow
extends DebuggerWindow {
    private String title;
    private AllThreadsPanel threadsPanel;
    private Component gui;
    private ThreadsWindowSettings threadsWindowSettings = ThreadsWindowSettings.getInstance();
    private static IdeAction actionMakeCurrent;
    private static IdeAction actionSuspend;
    private static IdeAction actionResume;
    private static IdeAction actionInterrupt;
    private static IdeAction actionDebuggerStop;
    private static IdeAction actionWatchThread;
    private static IdeAction actionInspectThread;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoTo;
    private static IdeAction actionDump;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemMakeCurrent;
    private static JMenuItem menuitemSuspend;
    private static JMenuItem menuitemResume;
    private static JMenuItem menuitemInterrupt;
    private static JMenuItem menuitemDebuggerStop;
    private static JMenuItem menuitemWatchThread;
    private static JMenuItem menuitemInspectThread;
    private static JMenuItem menuitemWatchClassLoader;
    private static JMenuItem menuitemInspectClassLoader;
    private static JMenuItem menuitemDump;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSettings;
    private static final int MAKE_CURRENT_CMD_ID;
    private static final int SUSPEND_CMD_ID;
    private static final int RESUME_CMD_ID;
    private static final int INTERRUPT_CMD_ID;
    private static final int DEBUGGER_STOP_CMD_ID;
    private static final int WATCH_THREAD_CMD_ID;
    private static final int INSPECT_THREAD_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int DUMP_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String THREADS_WINDOW_ID = "Debugger.ThreadsWindow";
    private static Icon threadsTabIcon;
    private DebuggerWindowOptions windowOptions;
    private DebugVirtualMachine vm;

    ThreadsWindow() {
        super(THREADS_WINDOW_ID);
        this.title = DbgArb.getString(189);
        ThreadsWindow.makeActions();
        this.threadsPanel = new AllThreadsPanel();
        this.setControllerForActions();
    }

    void updateStackWindow() {
        this.threadsPanel.updateStackWindow();
    }

    void clearStackWindow() {
        this.threadsPanel.clearStackWindow();
    }

    void threadsWindowSettingsChanged(boolean changed) {
        if (this.threadsPanel.treeTable == null) {
            return;
        }
        this.threadsPanel.treeTable.getTree().setShowsRootHandles(this.threadsWindowSettings.isShowThreadGroupStructure());
    }

    @Override
    @Deprecated
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.WEST;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    @Deprecated
    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.setNewVm(null);
    }

    private void setNewVm(DebugVirtualMachine newVM) {
        this.vm = newVM;
        this.windowOptions = null;
        if (newVM != null) {
            this.windowOptions = newVM.getDebuggerWindowOptions(DebuggerWindowOptions.WindowId.ThreadsWindow);
            if (this.windowOptions == DebuggerWindowOptions.DEFAULT) {
                this.windowOptions = new DebuggerThreadsWindowOptions();
            }
        }
        this.threadsWindowSettingsChanged(false);
        this.threadsPanel.setNewVm(newVM, this.windowOptions);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.findOrCreate((int)GOTO_CMD_ID, null, (String)DbgArb.getString(207), null, (Integer)DbgArb.getInteger(208), null, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionMakeCurrent = IdeAction.findOrCreate((int)MAKE_CURRENT_CMD_ID, null, (String)DbgArb.getString(209), null, (Integer)DbgArb.getInteger(210), null, null, (boolean)false);
            actionMakeCurrent.setEnabled(false);
            actionSuspend = IdeAction.findOrCreate((int)SUSPEND_CMD_ID, null, (String)DbgArb.getString(211), null, (Integer)DbgArb.getInteger(212), null, null, (boolean)false);
            actionSuspend.setEnabled(false);
            actionResume = IdeAction.findOrCreate((int)RESUME_CMD_ID, null, (String)DbgArb.getString(213), null, (Integer)DbgArb.getInteger(214), null, null, (boolean)false);
            actionResume.setEnabled(false);
            actionInterrupt = IdeAction.findOrCreate((int)INTERRUPT_CMD_ID, null, (String)DbgArb.getString(816), null, (Integer)DbgArb.getInteger(817), null, null, (boolean)false);
            actionInterrupt.setEnabled(false);
            actionDebuggerStop = IdeAction.findOrCreate((int)DEBUGGER_STOP_CMD_ID, null, (String)DbgArb.getString(819), null, (Integer)DbgArb.getInteger(820), null, null, (boolean)false);
            actionDebuggerStop.setEnabled(false);
            actionWatchThread = IdeAction.findOrCreate((int)WATCH_THREAD_CMD_ID, null, (String)DbgArb.getString(215), null, (Integer)DbgArb.getInteger(216), null, null, (boolean)false);
            actionWatchThread.setEnabled(false);
            actionInspectThread = IdeAction.findOrCreate((int)INSPECT_THREAD_CMD_ID, null, (String)DbgArb.getString(217), null, (Integer)DbgArb.getInteger(218), null, null, (boolean)false);
            actionInspectThread.setEnabled(false);
            actionWatchClassLoader = IdeAction.findOrCreate((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(219), null, (Integer)DbgArb.getInteger(220), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.findOrCreate((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(221), null, (Integer)DbgArb.getInteger(222), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionSettings = IdeAction.findOrCreate((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.findOrCreate((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(92), null, (Integer)RunMgrArb.getInteger(93), null, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.findOrCreate((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(94), null, (Integer)RunMgrArb.getInteger(95), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.findOrCreate((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), null, null, (boolean)false);
            actionSave.setEnabled(false);
            actionDump = IdeAction.findOrCreate((int)DUMP_CMD_ID, null, (String)DbgArb.getString(223), null, (Integer)DbgArb.getInteger(224), null, null, (boolean)false);
            actionDump.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionMakeCurrent, actionSuspend, actionResume, actionInterrupt, actionDebuggerStop, actionWatchThread, actionInspectThread, actionWatchClassLoader, actionInspectClassLoader, actionSettings, actionExpandAll, actionCollapseAll, actionSave, actionDump};
        JDebugger.setControllerForActions(actions, this.threadsPanel);
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = this.threadsPanel.getGUI();
            DebuggingProcess currentDP = JDebugger.getInstance().getActiveDebuggingProcess();
            this.setNewVm(currentDP == null ? null : currentDP.getVM());
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.threadsWindowSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        ThreadsWindow.this.threadsWindowSettingsChanged(true);
                    }
                }
            });
        }
        return this.gui;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_threadswindow_html");
    }

    public Controller getController() {
        return this.threadsPanel;
    }

    public Context getContext(EventObject event) {
        return this.threadsPanel.getContext(event);
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public String getTabName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTabName();
        }
        return this.title;
    }

    public Icon getTabIcon() {
        if (threadsTabIcon == null) {
            threadsTabIcon = this.windowOptions != null ? this.windowOptions.getTabIcon() : OracleIcons.getIcon((String)"debugger/threads.png");
        }
        return threadsTabIcon;
    }

    public String getTitleName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTitleName();
        }
        return this.title;
    }

    void everythingChanged() {
        this.threadsPanel.everythingChanged();
    }

    void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo currentThread) {
        this.setNewVm(vm);
        this.threadsPanel.updateThreads(debuggingProcess, vm, currentThread);
    }

    void clearThreads() {
        this.threadsPanel.clearThreads();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.threadsPanel.processFinished(debuggingProcess);
    }

    static {
        MAKE_CURRENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsMakeCurrent");
        SUSPEND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSuspend");
        RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsResume");
        INTERRUPT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInterrupt");
        DEBUGGER_STOP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsDebuggerStop");
        WATCH_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsWatchThread");
        INSPECT_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInspectThread");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsGoTo");
        DUMP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsDump");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSettings");
        threadsTabIcon = null;
    }

    final class AllThreadsPanel
    extends ThreadsPanel {
        private DebugThreadInfo highlightThread;
        private DebuggerWindowOptions windowOptions;

        AllThreadsPanel() {
            super(ThreadsWindow.this, ThreadsWindow.this.threadsWindowSettings.getThreadsPanelSettings());
            this._actionGoTo = actionGoTo;
            this._actionSave = actionSave;
            this._GOTO_CMD_ID = GOTO_CMD_ID;
            this._SAVE_CMD_ID = SAVE_CMD_ID;
        }

        @Override
        protected void setNewVm(DebugVirtualMachine newVM, DebuggerWindowOptions windowOptions) {
            this.windowOptions = windowOptions;
            this.vm = newVM;
            super.setNewVm(newVM, windowOptions);
        }

        @Override
        protected void addPopupMenuItemsForThreadItem(ContextMenu popup, Context context) {
            this.update(actionMakeCurrent, context);
            if (actionMakeCurrent.isEnabled()) {
                if (menuitemMakeCurrent == null) {
                    menuitemMakeCurrent = popup.createMenuItem((ToggleAction)actionMakeCurrent);
                }
                popup.add((Component)menuitemMakeCurrent, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionSuspend, context);
            if (actionSuspend.isEnabled()) {
                if (menuitemSuspend == null) {
                    menuitemSuspend = popup.createMenuItem((ToggleAction)actionSuspend);
                }
                popup.add((Component)menuitemSuspend, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionResume, context);
            if (actionResume.isEnabled()) {
                if (menuitemResume == null) {
                    menuitemResume = popup.createMenuItem((ToggleAction)actionResume);
                }
                popup.add((Component)menuitemResume, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionInterrupt, context);
            if (actionInterrupt.isEnabled()) {
                if (menuitemInterrupt == null) {
                    menuitemInterrupt = popup.createMenuItem((ToggleAction)actionInterrupt);
                }
                popup.add((Component)menuitemInterrupt, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionDebuggerStop, context);
            if (actionDebuggerStop.isEnabled()) {
                if (menuitemDebuggerStop == null) {
                    menuitemDebuggerStop = popup.createMenuItem((ToggleAction)actionDebuggerStop);
                }
                popup.add((Component)menuitemDebuggerStop, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionWatchThread, context);
            if (actionWatchThread.isEnabled()) {
                if (menuitemWatchThread == null) {
                    menuitemWatchThread = popup.createMenuItem((ToggleAction)actionWatchThread);
                }
                popup.add((Component)menuitemWatchThread, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionInspectThread, context);
            if (actionInspectThread.isEnabled()) {
                if (menuitemInspectThread == null) {
                    menuitemInspectThread = popup.createMenuItem((ToggleAction)actionInspectThread);
                }
                popup.add((Component)menuitemInspectThread, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionWatchClassLoader, context);
            if (actionWatchClassLoader.isEnabled()) {
                if (menuitemWatchClassLoader == null) {
                    menuitemWatchClassLoader = popup.createMenuItem((ToggleAction)actionWatchClassLoader);
                }
                popup.add((Component)menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionInspectClassLoader, context);
            if (actionInspectClassLoader.isEnabled()) {
                if (menuitemInspectClassLoader == null) {
                    menuitemInspectClassLoader = popup.createMenuItem((ToggleAction)actionInspectClassLoader);
                }
                popup.add((Component)menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForThreadItem(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForThreads(ContextMenu popup, Context context) {
            this.update(actionDump, context);
            if (actionDump.isEnabled()) {
                if (menuitemDump == null) {
                    menuitemDump = popup.createMenuItem((ToggleAction)actionDump);
                }
                popup.add((Component)menuitemDump, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForThreads(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
            this.update(actionExpandAll, context);
            if (actionExpandAll.isEnabled()) {
                if (menuitemExpandAll == null) {
                    menuitemExpandAll = popup.createMenuItem((ToggleAction)actionExpandAll);
                }
                popup.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
            }
            this.update(actionCollapseAll, context);
            if (actionCollapseAll.isEnabled()) {
                if (menuitemCollapseAll == null) {
                    menuitemCollapseAll = popup.createMenuItem((ToggleAction)actionCollapseAll);
                }
                popup.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
            }
            super.addPopupMenuItemsForTreeTable(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(actionSettings, context);
            if (actionSettings.isEnabled()) {
                if (menuitemSettings == null) {
                    menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
                }
                popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == MAKE_CURRENT_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.makeCurrentThread();
                }
                return true;
            }
            if (cmdId == SUSPEND_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.suspendThread();
                }
                return true;
            }
            if (cmdId == RESUME_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.resumeThread();
                }
                return true;
            }
            if (cmdId == WATCH_THREAD_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.watchThread();
                }
                return true;
            }
            if (cmdId == INSPECT_THREAD_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.inspectThread();
                }
                return true;
            }
            if (cmdId == WATCH_CLASSLOADER_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.watchClassLoader();
                }
                return true;
            }
            if (cmdId == INSPECT_CLASSLOADER_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.inspectClassLoader();
                }
                return true;
            }
            if (cmdId == SETTINGS_CMD_ID) {
                String[] path = new String[]{DbgArb.getString(620), DbgArb.getString(658)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            if (cmdId == EXPAND_ALL_CMD_ID) {
                this.model.expandAll();
                return true;
            }
            if (cmdId == COLLAPSE_ALL_CMD_ID) {
                this.model.collapseAll();
                return true;
            }
            if (cmdId == DUMP_CMD_ID) {
                DebugThreadInfo[] threads = this.vm != null ? this.vm.listThreads() : new DebugThreadInfo[]{};
                Arrays.sort(threads, this);
                AllThreadsPanel.threadDump(threads, this.debuggingProcess, this.getContext(), DbgArb.getString(225), DbgArb.getString(772));
                return true;
            }
            if (cmdId == INTERRUPT_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.interruptThread();
                }
                return true;
            }
            if (cmdId == DEBUGGER_STOP_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.stopThread();
                }
                return true;
            }
            return super.handleEvent(action, context);
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == MAKE_CURRENT_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canMakeCurrentThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == SUSPEND_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canSuspendThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == RESUME_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canResumeThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == WATCH_THREAD_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canWatchInspectThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == INSPECT_THREAD_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canWatchInspectThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == WATCH_CLASSLOADER_CMD_ID || cmdId == INSPECT_CLASSLOADER_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canWatchInspectClassLoader());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == SETTINGS_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == EXPAND_ALL_CMD_ID || cmdId == COLLAPSE_ALL_CMD_ID) {
                action.setEnabled(ThreadsWindow.this.threadsWindowSettings.isShowThreadGroupStructure());
                return true;
            }
            if (cmdId == DUMP_CMD_ID) {
                action.setEnabled(this.vm != null);
                return true;
            }
            if (cmdId == INTERRUPT_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canInterruptThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == DEBUGGER_STOP_CMD_ID) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canDebuggerStopThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            return super.update(action, context);
        }

        @Override
        protected void addThreadItems() {
            List root = this.getRoot();
            if (ThreadsWindow.this.threadsWindowSettings.isShowThreadGroupStructure()) {
                DebugThreadGroupInfo[] groups = this.vm.listTopThreadGroups();
                Arrays.sort(groups, this);
                for (int i = 0; i < groups.length; ++i) {
                    root.add(new ThreadsPanel.ThreadItem(groups[i]));
                }
            } else {
                DebugThreadInfo[] threads = this.vm.listThreads();
                Arrays.sort(threads, this);
                for (int i = 0; i < threads.length; ++i) {
                    root.add(new ThreadsPanel.ThreadItem(threads[i]));
                }
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            super.valueChanged(e);
            if (this.treeTable.isShowing()) {
                this.highlightThread = this.getSelectedThreadInfo();
                if (this.highlightThread != null) {
                    this.updateStackWindow();
                }
            }
        }

        @Override
        protected ThreadsPanel.ThreadInfoPath getCurrentHighlight() {
            if (this.debuggingProcess != null && this.highlightThread != null) {
                return new ThreadsPanel.ThreadInfoPath(this.debuggingProcess, this.highlightThread);
            }
            return super.getCurrentHighlight();
        }

        void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo highlightThread) {
            this.highlightThread = highlightThread;
            super.updateThreads(debuggingProcess, vm, highlightThread, this.windowOptions);
            if (this.treeTable == null || !this.treeTable.isShowing() || highlightThread == null) {
                this.updateStackWindow();
            }
        }

        void clearThreads() {
            super.clearThreads(this.windowOptions);
            this.clearStackWindow();
        }

        @Override
        void processFinished(DebuggingProcess debuggingProcess) {
            if (this.debuggingProcess == debuggingProcess) {
                this.highlightThread = null;
            }
            super.processFinished(debuggingProcess);
            StackWindow stackWindow = JDebugger.getInstance().getStackWindow(false);
            if (stackWindow != null) {
                stackWindow.processFinished(debuggingProcess);
            }
        }

        void clearStackWindow() {
            StackWindow stackWindow = JDebugger.getInstance().getStackWindow(false);
            if (stackWindow != null) {
                stackWindow.clearStack();
            }
        }

        void updateStackWindow() {
            StackWindow stackWindow = JDebugger.getInstance().getStackWindow(false);
            if (stackWindow != null) {
                if (this.treeTable != null && this.treeTable.isEnabled()) {
                    if (this.debuggingProcess != null && this.vm != null) {
                        stackWindow.updateStack(this.debuggingProcess, this.vm, this.highlightThread);
                    } else {
                        stackWindow.updateStack(null, null, null);
                    }
                } else {
                    stackWindow.clearStack();
                }
            }
        }
    }
}

