/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.config.Preferences;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class StackWindowSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "StackWindowOptions";
    public static final String ELEMENT_THREAD_COMBOBOX = "ThreadComboBox";
    private static final String SHOW_PACKAGES = "showPackages";
    private static final String SHOW_FULLY_QUALIFIED_NAMES = "showFullyQualifiedNames";
    private static final String COLUMN_VISIBLE = "columnVisible";
    private static final String COLUMN_WIDTH = "columnWidth";
    private static final String COLUMN_ORDER = "columnOrder";
    private static final String COLUMN_NAMES = "columnNames";
    private static final String VM_NAMES = "vmNames";

    static StackWindowSettings getInstance() {
        return StackWindowSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    @Deprecated
    public StackWindowSettings() {
        super(HashStructure.newInstance());
    }

    private StackWindowSettings(HashStructure hs) {
        super(hs);
    }

    public static StackWindowSettings getInstance(PropertyStorage ps) {
        return new StackWindowSettings(StackWindowSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    public static String getWindowId() {
        return "Debugger.StackWindow";
    }

    HashStructure getHash() {
        return super.getHashStructure();
    }

    @Deprecated
    public boolean isShowPackages() {
        return this._hash.getBoolean(SHOW_PACKAGES, false);
    }

    @Deprecated
    public void setShowPackages(boolean showPackages) {
        this._hash.putBoolean(SHOW_PACKAGES, showPackages);
    }

    boolean isShowFullyQualifiedNames(String VMName) {
        if (this._hash.containsKey(SHOW_PACKAGES)) {
            this.setShowFullyQualifiedNames(VMName, this.isShowPackages());
        }
        return this._hash.getBoolean(SHOW_FULLY_QUALIFIED_NAMES + VMName, false);
    }

    void setShowFullyQualifiedNames(String VMName, boolean showFullyQualified) {
        this._hash.remove(SHOW_PACKAGES);
        this._hash.putBoolean(SHOW_FULLY_QUALIFIED_NAMES + VMName, showFullyQualified);
    }

    @Deprecated
    public boolean[] getColumnVisible() {
        boolean[] columnVisible = new boolean[5];
        for (int x = 0; x < 5; ++x) {
            columnVisible[x] = this.getColumnVisible(x);
        }
        return columnVisible;
    }

    @Deprecated
    public void setColumnVisible(boolean[] columnVisible) {
        for (int x = 0; x < columnVisible.length; ++x) {
            this.setColumnVisible(x, columnVisible[x]);
        }
    }

    @Deprecated
    boolean getColumnVisible(int columnIndex) {
        boolean defaultValue = columnIndex == 1 || columnIndex == 0 && !Product.isRaptor();
        return this._hash.getBoolean(COLUMN_VISIBLE + columnIndex, defaultValue);
    }

    @Deprecated
    void setColumnVisible(int columnIndex, boolean columnVisible) {
        this._hash.putBoolean(COLUMN_VISIBLE + columnIndex, columnVisible);
    }

    boolean getColumnVisible(String VMName, int column) {
        if (this._hash.containsKey(COLUMN_VISIBLE)) {
            this.setColumnVisible(VMName, column, this.getColumnVisible(column));
        }
        return WindowSettingsColumnManager.getColumnVisible(this._hash, VMName, column);
    }

    void setColumnVisible(String VMName, int column, boolean visible) {
        WindowSettingsColumnManager.setColumnVisible(this._hash, VMName, column, visible);
    }

    @Deprecated
    public int[] getColumnWidth() {
        int[] columnWidth = new int[5];
        for (int x = 0; x < 5; ++x) {
            columnWidth[x] = this.getColumnWidth(x);
        }
        return columnWidth;
    }

    @Deprecated
    public void setColumnWidth(int[] columnWidth) {
        for (int x = 0; x < columnWidth.length; ++x) {
            this.setColumnWidth(x, columnWidth[x]);
        }
    }

    @Deprecated
    int getColumnWidth(int columnIndex) {
        return this._hash.getInt(COLUMN_WIDTH + columnIndex, 0);
    }

    @Deprecated
    void setColumnWidth(int columnIndex, int columnWidth) {
        this._hash.putInt(COLUMN_WIDTH + columnIndex, columnWidth);
    }

    int getColumnWidth(String VMName, int column) {
        if (this._hash.containsKey(COLUMN_WIDTH)) {
            this.setColumnWidth(VMName, column, this.getColumnWidth(column));
        }
        return WindowSettingsColumnManager.getColumnWidth(this._hash, VMName, column);
    }

    void setColumnWidth(String VMName, int column, int width) {
        WindowSettingsColumnManager.setColumnWidth(this._hash, VMName, column, width);
    }

    @Deprecated
    String getColumnOrder() {
        return this._hash.getString(COLUMN_ORDER);
    }

    @Deprecated
    public void setColumnOrder(String columnOrder) {
        this._hash.putString(COLUMN_ORDER, columnOrder);
    }

    String getColumnOrder(String VMName) {
        if (this._hash.containsKey(COLUMN_ORDER)) {
            this.setColumnOrder(VMName, this.getColumnOrder());
        }
        return WindowSettingsColumnManager.getColumnOrder(this._hash, VMName);
    }

    void setColumnOrder(String VMName, String columnOrder) {
        WindowSettingsColumnManager.setColumnOrder(this._hash, VMName, columnOrder);
    }

    List<String> getColumnNames(String VMName) {
        ListStructure names = this._hash.getListStructure(COLUMN_NAMES + VMName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i).toString());
        }
        return stringList;
    }

    void setColumnNames(String VMName, List<String> columnNames) {
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        this._hash.putListStructure(COLUMN_NAMES + VMName, names);
    }

    List<String> getVMNames() {
        ListStructure names = this._hash.getListStructure(VM_NAMES);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i).toString());
        }
        return stringList;
    }

    void addVMName(String VMName) {
        ListStructure names = this._hash.getListStructure(VM_NAMES);
        if (names == null) {
            names = ListStructure.newInstance();
        }
        if (!names.contains((Object)VMName)) {
            names.add((Object)VMName);
        }
        this._hash.putListStructure(VM_NAMES, names);
    }
}

