/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import javax.swing.tree.TreePath;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.EvaluatorController;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.Expression;

final class EvaluatorDataItem
extends DataItem {
    EvaluatorItem ei;
    private final EvaluatorController controller;

    EvaluatorDataItem(EvaluatorItem ei, String name, Object info, EvaluatorPanel evaluatorPanel, EvaluatorController controller) {
        super(evaluatorPanel, info, name, ei.isPinned(evaluatorPanel.getDebuggingProcess()) ? null : ei.getExpression());
        this.controller = controller;
        this.ei = ei;
    }

    private void reEvaluateExpression(TreePath treePath) {
        Object info = this.ei.evaluate(this.controller.getDebuggingProcess(), this.controller.evaluator);
        if (info == null) {
            info = this.ei;
        }
        String name = this.ei.getName(this.controller.getDebuggingProcess());
        String originalExpression = this.ei.isPinned(this.controller.getDebuggingProcess()) ? null : this.ei.getExpression();
        this.modifyInfo(info, name, originalExpression, treePath);
    }

    @Override
    protected boolean prepareExpression(Object[] path, int i, Expression expression) {
        if (super.prepareExpression(path, i, expression)) {
            String name = this.ei.getName();
            if (name != null) {
                expression.setName(name);
            }
            expression.setShowPinnedDiscarded(this.ei.isShowPinnedDiscarded());
            expression.setTemporary(this.ei.getTemporary());
            return true;
        }
        return false;
    }

    protected boolean canEditExpression() {
        return this.ei.getExpression() != null && !this.ei.isPinned(this.controller.getDebuggingProcess());
    }

    protected boolean editExpression(String expression, TreePath treePath) {
        if (expression != null && !expression.equals(this.ei.getExpression())) {
            DebugStackFrameInfo frame = this.controller.getFrame();
            if (this.controller.getThread() != null && frame != null) {
                this.controller.setFrame(this.controller.getThread().getStackFrame(frame.getFrameNumber()));
                this.controller.debugContextChanged();
            }
            this.ei.setExpression(expression);
            this.reEvaluateExpression(treePath);
            return true;
        }
        return false;
    }

    boolean canPin() {
        DebugVirtualMachine vm = this.controller.getVm();
        return vm != null && vm.getCapabilities().canPin() && this.data instanceof DebugDataCompositeInfo && !((DebugDataCompositeInfo)this.data).isNull() && !this.ei.isPinned(this.controller.getDebuggingProcess());
    }

    void pin(TreePath treePath) {
        DebugDataCompositeInfo datac;
        DebugVirtualMachine vm = this.controller.getVm();
        if (vm != null && vm.getCapabilities().canPin() && this.data instanceof DebugDataCompositeInfo && !(datac = (DebugDataCompositeInfo)this.data).isNull()) {
            this.ei.pin(this.controller.getDebuggingProcess(), datac);
            this.reEvaluateExpression(treePath);
        }
    }

    boolean canUnpin() {
        return this.ei.canUnpin(this.controller.getDebuggingProcess());
    }

    void unpin(TreePath treePath) {
        this.ei.unpin(this.controller.getDebuggingProcess());
        this.reEvaluateExpression(treePath);
    }
}

