/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class DebuggerHostDialog
extends JPanel
implements ActionListener,
DocumentListener,
ItemListener {
    private JEWTDialog dlg;
    private HistoryList hostHistoryList;
    private JComboBox hostComboBox;
    private JTextField hostEditor;
    private static String mostRecentHost;

    public static String showDebuggerHostDialog(String host) {
        DebuggerHostDialog panel = new DebuggerHostDialog(host);
        String title = DbgArb.getString(173);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.hostEditor, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setButtonMask(dlg.getButtonMask() & 0xFFFFFFFD);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_hostname_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel.getHost();
        }
        return host;
    }

    private DebuggerHostDialog(String host) {
        super(new GridBagLayout());
        JLabel hostLabel = new JLabel();
        this.hostHistoryList = Ide.loadHistoryList((String)"DebuggerHost");
        if (host != null) {
            this.hostHistoryList.update(host);
        }
        if (mostRecentHost != null) {
            this.hostHistoryList.update(mostRecentHost);
        }
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.hostHistoryList.getHistory());
        this.hostComboBox = new JComboBox<String>(choices);
        this.hostComboBox.setEditable(true);
        this.hostEditor = (JTextField)this.hostComboBox.getEditor().getEditorComponent();
        this.hostComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)hostLabel, (Component)this.hostEditor, (String)DbgArb.getString(174));
        String finalHost = null;
        if (mostRecentHost != null && mostRecentHost.trim().length() > 0) {
            finalHost = mostRecentHost;
        } else if (host != null && host.trim().length() > 0) {
            finalHost = host;
        }
        JDebugger.selectHistoryString(this.hostComboBox, finalHost);
        String prompt = DbgArb.format(175, Ide.getProgramShortName());
        int columns = 50;
        int rows = prompt.length() / columns + 1;
        JTextArea promptLabel = new JTextArea(prompt, rows, columns);
        promptLabel.setBackground(hostLabel.getBackground());
        promptLabel.setFont(hostLabel.getFont());
        promptLabel.setEditable(false);
        promptLabel.setLineWrap(true);
        promptLabel.setWrapStyleWord(true);
        int y = 0;
        this.add((Component)hostLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.hostComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)promptLabel, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.hostComboBox, (DocumentListener)this);
        this.hostComboBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        try {
            return this.hostEditor.getText().length() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.hostComboBox) {
            this.hostEditor.setText((String)this.hostComboBox.getSelectedItem());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.processChange();
    }

    private String getHost() {
        mostRecentHost = this.hostHistoryList.comboBoxGetSelectedItem(this.hostComboBox);
        return mostRecentHost;
    }
}

