/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class DebugContext {
    public DebugVirtualMachine vm;
    DebugThreadInfo thread;
    DebugStackFrameInfo frame;
    DebugDataObjectInfo dataObject;
    Map variables = new HashMap();

    DebugContext() {
    }

    boolean setDebugContext(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (this.vm != vm || this.thread != thread || this.frame != frame || this.dataObject != null) {
            this.vm = vm;
            this.thread = thread;
            this.frame = frame;
            this.dataObject = null;
            this.clearVariables();
            return true;
        }
        return false;
    }

    boolean setDebugContext(DebugDataObjectInfo dataObject) {
        DebugVirtualMachine vm = dataObject.getVM();
        if (this.vm != vm || this.thread != null || this.frame != null || this.dataObject != dataObject) {
            this.vm = vm;
            this.thread = null;
            this.frame = null;
            this.dataObject = dataObject;
            this.clearVariables();
            return true;
        }
        return false;
    }

    void clearVariables() {
        this.variables.clear();
    }

    void addVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    void removeVariable(String name) {
        this.variables.remove(name);
    }
}

