/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.jdevimpl.runner.debug.DataInfoPath;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataTableUtils {
    private static Font normalFont;
    private static Font boldFont;
    private static Font boldItalicFont;

    private DataTableUtils() {
    }

    static Font getNormalFont() {
        if (normalFont == null) {
            normalFont = UIManager.getFont("Table.font");
        }
        return normalFont;
    }

    static Font getBoldFont() {
        if (boldFont == null) {
            boldFont = DataTableUtils.getNormalFont().deriveFont(1);
        }
        return boldFont;
    }

    static Font getBoldItalicFont() {
        if (boldItalicFont == null) {
            boldItalicFont = DataTableUtils.getNormalFont().deriveFont(3);
        }
        return boldItalicFont;
    }

    static TreePath convertDataInfoPathToTreePath(TreeTableModel model, DataInfoPath dataInfoPath) {
        int dataInfoPathSize = dataInfoPath.size();
        if (dataInfoPathSize == 0) {
            return null;
        }
        Object node = model.getRoot();
        TreePath treePath = new TreePath(node);
        for (int i = 1; i < dataInfoPathSize; ++i) {
            Object dataInfo = dataInfoPath.getDataInfo(i);
            Object nextNode = null;
            for (int x = 0; x < model.getChildCount(node); ++x) {
                Object nextDataInfo;
                Object child = model.getChild(node, x);
                if (!(child instanceof DataItem) || !((nextDataInfo = ((DataItem)child).getInfo()) == null ? dataInfo == null : nextDataInfo.equals(dataInfo))) continue;
                nextNode = child;
                break;
            }
            if (nextNode == null) {
                return null;
            }
            node = nextNode;
            treePath = treePath.pathByAddingChild(node);
        }
        return treePath;
    }

    static void selectTreeTablePath(DataTable dataTable, TreePath treePath, boolean scrollToVisible) {
        DataTableUtils.selectTreeTablePath(dataTable, new TreePath[]{treePath}, scrollToVisible);
    }

    static void selectTreeTablePath(final DataTable dataTable, final TreePath[] treePaths, boolean scrollToVisible) {
        if (treePaths[0] == null) {
            return;
        }
        if (scrollToVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dataTable.makeVisible(treePaths[0]);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dataTable.setSelectionPath(treePaths[0]);
            }
        });
    }

    static void hookupDragAndDrop(DataPanel dataPanel, JTable table, JScrollPane scrollPane) {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(table, 1, dataPanel);
        DropTargetListener dropTargetL = dataPanel.getDropTargetListener();
        new DropTarget(scrollPane, 1, dropTargetL);
        new DropTarget(scrollPane.getViewport(), 1, dropTargetL);
        new DropTarget(scrollPane, 1, dropTargetL);
    }

    static void hookupTable(final DataPanel dataPanel, final JTable table) {
        table.getAccessibleContext().setAccessibleName(dataPanel.getTitle());
        table.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && (table.isShowing() || dataPanel.getDockableWindow() == null)) {
                    dataPanel.nowShown();
                }
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: {
                        int selectedColumn = table.getSelectedColumn();
                        if (selectedColumn == -1) break;
                        int column = table.convertColumnIndexToModel(selectedColumn);
                        if (!dataPanel.getController().handleDoubleClickOrEnter(e, column)) break;
                        e.consume();
                        break;
                    }
                    case 127: {
                        int selectedRow = table.getSelectedRow();
                        if (selectedRow == -1) break;
                        Context context = dataPanel.getController().getContext(e);
                        IdeAction removeWatch = IdeAction.find((String)"DebugWatchRemoveWatch");
                        dataPanel.getController().update(removeWatch, context);
                        if (!removeWatch.isEnabled()) break;
                        dataPanel.getController().handleEvent(removeWatch, context);
                        e.consume();
                    }
                }
            }
        });
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (dataPanel.getDebuggingProcess() == null || !dataPanel.getDebuggingProcess().isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(310, dataPanel.getTitle()));
                }
            }
        });
    }

    static void setHeaderRenderer(JTableHeader tableHeader) {
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                int modelIndex = table.convertColumnIndexToModel(column);
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    defaultTableCellRenderer.setHorizontalAlignment(2);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
    }

    static void setColumnOrder(JTable table, String order) {
        TableColumnModel tableColumnModel = table.getColumnModel();
        boolean orderedQuickInspect = false;
        if (order != null) {
            String[] orderedColumns = order.split(",");
            int currentColumn = 0;
            for (int i = 0; i < 8 && i < orderedColumns.length; ++i) {
                String identifier = orderedColumns[i];
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from != currentColumn) {
                        table.moveColumn(from, currentColumn);
                    }
                    ++currentColumn;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

