/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Arrays;
import java.util.List;
import javax.swing.tree.TreePath;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataInfoPath {
    private DebuggingProcess debuggingProcess;
    private List list;

    DataInfoPath(DebuggingProcess debuggingProcess, Object[] dataInfoArray) {
        this.debuggingProcess = debuggingProcess;
        this.list = Arrays.asList(dataInfoArray);
    }

    DebuggingProcess getDebuggingProcess() {
        return this.debuggingProcess;
    }

    int size() {
        return this.list.size();
    }

    Object getDataInfo(int index) {
        return this.list.get(index);
    }

    public int hashCode() {
        return this.debuggingProcess.hashCode() + this.list.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DataInfoPath) {
            DataInfoPath other = (DataInfoPath)o;
            return this.debuggingProcess == other.debuggingProcess && this.list.equals(other.list);
        }
        return false;
    }

    static DataInfoPath convertTreePathToDataInfoPath(TreePath treePath, DebuggingProcess debuggingProcess) {
        boolean foundOneDataInfo = false;
        Object[] path = treePath.getPath();
        int pathLength = path.length;
        Object[] dataInfoArray = new Object[pathLength];
        for (int i = 0; i < pathLength; ++i) {
            Object node = path[i];
            if (!(node instanceof DataItem)) continue;
            dataInfoArray[i] = ((DataItem)node).getInfo();
            if (dataInfoArray[i] == null) continue;
            foundOneDataInfo = true;
        }
        if (foundOneDataInfo) {
            return new DataInfoPath(debuggingProcess, dataInfoArray);
        }
        return null;
    }
}

