/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.debugger.Breakpoint;
import oracle.jdevimpl.debugger.BreakpointMarkerAPI;
import oracle.jdevimpl.debugger.BreakpointRuntimeCallback;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointProperties;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BreakpointMarker;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataValueHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugBreakpointConditionImpl;
import oracle.jdevimpl.runner.debug.DebuggerHelperHook;
import oracle.jdevimpl.runner.debug.DebuggerLanguageHelper;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;

class BreakpointRuntimeSupport
implements BreakpointRuntimeCallback {
    static final int STATUS_DISABLED = 0;
    static final int STATUS_ENABLED = 1;
    static final int STATUS_UNVERIFIED = 2;
    static final int STATUS_VERIFIED = 3;
    private static Map<Breakpoint, Map<DebuggingProcess, DebugBreakpoint>> processToBreakpoint = Collections.synchronizedMap(new HashMap());
    private static Map<Breakpoint, Map<DebugBreakpoint, DebuggingProcess>> breakpointToProcess = Collections.synchronizedMap(new HashMap());

    BreakpointRuntimeSupport() {
    }

    public int getRuntimeStatus(Breakpoint breakpoint) {
        return BreakpointRuntimeSupport.getRuntimeStatus(breakpoint, null);
    }

    public boolean isRuntimeEnabled(Breakpoint breakpoint) {
        DebugBreakpoint dbp;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess)) != null) {
            return dbp.getEnabled();
        }
        return breakpoint.isEnabled();
    }

    public void afterSetPackageFileLine(final Breakpoint breakpoint, String pkgArg, String fileArg, int lineArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setPackageFileLine - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                breakpoint.updateBreakpointIcon();
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetMethod(final Breakpoint breakpoint, String methodArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setMethod - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetMethodOffset(final Breakpoint breakpoint, String methodArg, int offsetArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setMethodOffset - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                breakpoint.updateBreakpointIcon();
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetException(final Breakpoint breakpoint, String exceptionArg, boolean caughtArg, boolean uncaughtArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setException - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetClassName(final Breakpoint breakpoint, String classNameArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setClassName - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetURLLine(final Breakpoint breakpoint, URL urlArg, int lineArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setPackageFileLine - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                breakpoint.updateBreakpointIcon();
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetWatchpoint(final Breakpoint breakpoint, String classNameArg, String fieldNameArg, boolean accessArg, boolean modifyArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setWatchpoint - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                breakpoint.updateBreakpointIcon();
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetEnabled(final Breakpoint breakpoint, final boolean enabledArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setEnabled(enabledArg);
                    } else {
                        Assert.println((String)"Breakpoint.setEnabled - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                breakpoint.updateBreakpointIcon();
                JDebugger.getInstance().updateBreakpointsWindowStatus(breakpoint);
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetGroupName(final Breakpoint breakpoint, final String groupName) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setName(groupName);
                    } else {
                        Assert.println((String)"Breakpoint.setGroupName - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetCondition(final Breakpoint breakpoint) {
        final DebugBreakpointConditionImpl condition = breakpoint.hasCondition() ? new DebugBreakpointConditionImpl(breakpoint) : null;
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setCondition(condition);
                    } else {
                        Assert.println((String)"Breakpoint.setCondition - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetThreadName(final Breakpoint breakpoint, final String threadName) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setThreadname(threadName);
                    } else {
                        Assert.println((String)"Breakpoint.setThreadName - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetThreadNameNot(final Breakpoint breakpoint, final String threadNameNot) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setThreadnameNot(threadNameNot);
                    } else {
                        Assert.println((String)"Breakpoint.setThreadNameNot - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetPassCount(final Breakpoint breakpoint, final int passCountArg) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setPassCount(passCountArg);
                    } else {
                        Assert.println((String)"Breakpoint.setPassCount - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetActionHalt(final Breakpoint breakpoint, final boolean actionHalt) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setStop(actionHalt);
                    } else {
                        Assert.println((String)"Breakpoint.setActionHalt - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetActionBeep(final Breakpoint breakpoint) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setLog(breakpoint.isActionBeep() || breakpoint.isActionLog());
                    } else {
                        Assert.println((String)"Breakpoint.setActionBeep - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetActionLog(final Breakpoint breakpoint) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setLog(breakpoint.isActionBeep() || breakpoint.isActionLog());
                    } else {
                        Assert.println((String)"Breakpoint.setActionLog - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetActionEnableOther(final Breakpoint breakpoint, final String actionEnableOther) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setEnableOtherBPs(actionEnableOther);
                    } else {
                        Assert.println((String)"Breakpoint.setActionEnableOther - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetActionDisableOther(final Breakpoint breakpoint, final String actionDisableOther) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        dbp.setDisableOtherBPs(actionDisableOther);
                    } else {
                        Assert.println((String)"Breakpoint.setActionDisableOther - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterSetProperties(final Breakpoint breakpoint, Map<String, String> properties) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                    } else {
                        Assert.println((String)"Breakpoint.setProperties - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                BreakpointRuntimeSupport.this.afterRefactorBreakpoint(breakpoint);
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterDeleteBreakpoint(final Breakpoint breakpoint) {
        JDebugger.getInstance().breakpointHasBeenDeleted(breakpoint);
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                    if (dbp != null) {
                        JDebugger.getInstance().breakpointHasBeenRemovedFromVm(dbp);
                        dbp.remove();
                    } else {
                        Assert.println((String)"Breakpoint.removeBreakpoint - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                processToBreakpoint.remove(breakpoint);
                breakpointToProcess.remove(breakpoint);
                JDebugger.getInstance().updateBreakpointsWindow();
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    public void afterMoveBreakpoint(Breakpoint breakpoint) {
        JDebugger.getInstance().breakpointHasBeenMoved(breakpoint);
    }

    public void updateBreakpointsWindow() {
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public void afterShowBreakpointIcon(Breakpoint breakpoint) {
        ExtenderManager.getInstance().showBreakpointIcon(breakpoint);
    }

    public void afterHideBreakpointIcon(Breakpoint breakpoint) {
        ExtenderManager.getInstance().hideBreakpointIcon(breakpoint);
    }

    public void afterUpdateBreakpointIcon(Breakpoint breakpoint) {
        ExtenderManager.getInstance().updateBreakpointIcon(breakpoint);
    }

    public void afterRefactorBreakpoint(Breakpoint breakpoint) {
        JDebugger.getInstance().breakpointHasBeenRefactored(breakpoint);
    }

    static DebugBreakpoint setBreakpointInVm(Breakpoint breakpoint, DebuggingProcess debuggingProcess, boolean isTemporary) {
        try {
            DebugBreakpoint dbp = null;
            String error = null;
            int bpType = breakpoint.getType();
            DebugVirtualMachine vm = debuggingProcess.getVM();
            DebugCapabilities capabilities = vm.getCapabilities();
            switch (bpType) {
                case 0: {
                    if (!capabilities.canPutBreakpointPackageFileLine()) {
                        return null;
                    }
                    String pkg = breakpoint.getPackage();
                    String file = breakpoint.getFile();
                    int line = breakpoint.getLine();
                    dbp = debuggingProcess.getVM().putBreakpointPackageFileLine(pkg, file, line);
                    break;
                }
                case 1: {
                    if (!capabilities.canPutBreakpointMethod()) {
                        return null;
                    }
                    String method = breakpoint.getMethod();
                    dbp = debuggingProcess.getVM().putBreakpointMethod(method);
                    break;
                }
                case 7: {
                    if (!capabilities.canPutBreakpointMethodBytecode()) {
                        return null;
                    }
                    String method = breakpoint.getMethod();
                    int offset = breakpoint.getOffset();
                    dbp = debuggingProcess.getVM().putBreakpointMethodBytecode(method, offset);
                    break;
                }
                case 2: {
                    if (!capabilities.canPutBreakpointException()) {
                        return null;
                    }
                    String exception = breakpoint.getException();
                    boolean caught = breakpoint.isCaught();
                    boolean uncaught = breakpoint.isUncaught();
                    dbp = debuggingProcess.getVM().putBreakpointException(exception, caught, uncaught);
                    break;
                }
                case 3: {
                    if (!capabilities.canPutBreakpointDeadlock()) {
                        return null;
                    }
                    dbp = debuggingProcess.getVM().putBreakpointDeadlock();
                    break;
                }
                case 4: {
                    if (!capabilities.canPutBreakpointClass()) {
                        return null;
                    }
                    String className = breakpoint.getClassName();
                    dbp = debuggingProcess.getVM().putBreakpointClass(className);
                    break;
                }
                case 5: {
                    if (!capabilities.canPutBreakpointPackageFileLine() && !capabilities.canPutBreakpointFileLine()) {
                        return null;
                    }
                    if (capabilities.canPutBreakpointPackageFileLine()) {
                        String[] packageAndFile = debuggingProcess.url_to_packageAndFile(breakpoint.getURL());
                        if (packageAndFile != null && packageAndFile.length == 2) {
                            int line = breakpoint.getLine();
                            dbp = debuggingProcess.getVM().putBreakpointPackageFileLine(packageAndFile[0], packageAndFile[1], line);
                        } else {
                            error = DbgArb.format(502, breakpoint.getDescription());
                        }
                    }
                    if (dbp != null || !capabilities.canPutBreakpointFileLine()) break;
                    error = null;
                    dbp = debuggingProcess.getVM().putBreakpointFileLine(breakpoint.getURL().toString(), breakpoint.getLine());
                    break;
                }
                case 6: {
                    if (!capabilities.canPutBreakpointWatchpoint()) {
                        return null;
                    }
                    String className = breakpoint.getClassName();
                    String fieldName = breakpoint.getFieldName();
                    boolean access = breakpoint.isAccess();
                    boolean modify = breakpoint.isModify();
                    dbp = debuggingProcess.getVM().putBreakpointWatchpoint(className, fieldName, access, modify);
                    break;
                }
                case 8: {
                    if (!capabilities.canPutBreakpointProperties()) {
                        return null;
                    }
                    Map properties = breakpoint.getProperties();
                    dbp = debuggingProcess.getVM().putBreakpointProperties(properties);
                    break;
                }
            }
            if (dbp != null) {
                String actionDisableOther;
                String groupName;
                if (!isTemporary) {
                    Map<DebuggingProcess, DebugBreakpoint> dp2dbMap = processToBreakpoint.get(breakpoint);
                    if (dp2dbMap == null) {
                        dp2dbMap = new HashMap<DebuggingProcess, DebugBreakpoint>(2);
                        processToBreakpoint.put(breakpoint, dp2dbMap);
                    }
                    dp2dbMap.put(debuggingProcess, dbp);
                    Map<DebugBreakpoint, DebuggingProcess> db2dpMap = breakpointToProcess.get(breakpoint);
                    if (db2dpMap == null) {
                        db2dpMap = new HashMap<DebugBreakpoint, DebuggingProcess>(2);
                        breakpointToProcess.put(breakpoint, db2dpMap);
                    }
                    db2dpMap.put(dbp, debuggingProcess);
                    JDebugger.getInstance().breakpointHasBeenSetInVm(breakpoint, dbp);
                }
                if (!breakpoint.isEnabled()) {
                    dbp.setEnabled(false);
                }
                if ((groupName = breakpoint.getGroupName()).length() > 0) {
                    dbp.setName(groupName);
                }
                dbp.setCondition(breakpoint.hasCondition() ? new DebugBreakpointConditionImpl(breakpoint) : null);
                String threadName = breakpoint.getThreadName();
                String threadNameNot = breakpoint.getThreadNameNot();
                if (threadName.length() > 0) {
                    dbp.setThreadname(threadName);
                } else if (threadNameNot.length() > 0) {
                    dbp.setThreadnameNot(threadNameNot);
                }
                dbp.setPassCount(breakpoint.getPassCount());
                dbp.setStop(breakpoint.isActionHalt());
                dbp.setLog(breakpoint.isActionBeep() || breakpoint.isActionLog());
                String actionEnableOther = breakpoint.getActionEnableOther();
                if (actionEnableOther.length() > 0) {
                    dbp.setEnableOtherBPs(actionEnableOther);
                }
                if ((actionDisableOther = breakpoint.getActionDisableOther()).length() > 0) {
                    dbp.setDisableOtherBPs(actionDisableOther);
                }
                if (!isTemporary) {
                    BreakpointRuntimeSupport.changed(breakpoint, debuggingProcess);
                }
                dbp.setBreakpoint();
                return dbp;
            }
            if (!isTemporary && breakpoint.isEnabled()) {
                String msg = null;
                msg = error != null ? error : (bpType == 3 ? DbgArb.getString(503) : (bpType == 6 ? DbgArb.format(504, breakpoint.getDescription()) : DbgArb.format(501, breakpoint.getDescription())));
                if (msg != null) {
                    debuggingProcess.log(msg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static void setBreakpointInVm(final Breakpoint breakpoint, Runnable runOnceLater) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    BreakpointRuntimeSupport.setBreakpointInVm(breakpoint, debuggingProcess, false);
                }
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLater);
    }

    static void setBreakpointsInVm(DebuggingProcess debuggingProcess, final boolean includePersistentBps) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    try {
                        List[] breakpoints = Breakpoint.getBreakpoints((Workspace)debuggingProcess.getWorkspace(), (Project)debuggingProcess.getProject());
                        int length = breakpoints.length;
                        for (int i = 0; i < length; ++i) {
                            for (Breakpoint bp : breakpoints[i]) {
                                if (!includePersistentBps && bp.isPersistent()) continue;
                                BreakpointRuntimeSupport.setBreakpointInVm(bp, debuggingProcess, false);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        JDebugger.getInstance();
        JDebugger.pauseAndInvoke(new DebuggingProcess[]{debuggingProcess}, runWhilePaused, null);
    }

    static void removeBreakpointsFromVm(DebuggingProcess debuggingProcess) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    List<Breakpoint> breakpoints = BreakpointRuntimeSupport.getBreakpoints(debuggingProcess);
                    for (Breakpoint bp : breakpoints) {
                        DebugBreakpoint dbp;
                        if (bp.isPersistent()) continue;
                        Map mp2b = (Map)processToBreakpoint.get(bp);
                        if (mp2b != null && (dbp = (DebugBreakpoint)mp2b.remove(debuggingProcess)) != null) {
                            Map mb2p = (Map)breakpointToProcess.get(dbp);
                            if (mb2p != null) {
                                mb2p.remove(dbp);
                            }
                            try {
                                dbp.remove();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            JDebugger.getInstance().breakpointHasBeenRemovedFromVm(dbp);
                        }
                        bp.updateBreakpointIcon();
                    }
                }
            }
        };
        JDebugger.getInstance();
        JDebugger.pauseAndInvoke(new DebuggingProcess[]{debuggingProcess}, runWhilePaused, null);
    }

    static DebugBreakpoint getDebugBreakpoint(Breakpoint breakpoint, DebuggingProcess debuggingProcess) {
        Map<DebuggingProcess, DebugBreakpoint> map = processToBreakpoint.get(breakpoint);
        if (map != null) {
            return map.get(debuggingProcess);
        }
        return null;
    }

    static DebuggingProcess getDebugginProcess(Breakpoint breakpoint, DebugBreakpoint dbp) {
        Map<DebugBreakpoint, DebuggingProcess> map = breakpointToProcess.get(breakpoint);
        if (map != null) {
            return map.get(dbp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Breakpoint> getBreakpoints(DebuggingProcess debuggingProcess) {
        Map<Breakpoint, Map<DebuggingProcess, DebugBreakpoint>> map = processToBreakpoint;
        synchronized (map) {
            ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
            for (Map.Entry<Breakpoint, Map<DebuggingProcess, DebugBreakpoint>> entry : processToBreakpoint.entrySet()) {
                if (!entry.getValue().containsKey(debuggingProcess)) continue;
                breakpoints.add(entry.getKey());
            }
            return breakpoints;
        }
    }

    static int getRuntimeStatus(Breakpoint breakpoint, DebuggingProcess debuggingProcess) {
        if (debuggingProcess == null) {
            debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        }
        if (debuggingProcess != null) {
            DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
            if (dbp != null) {
                if (!dbp.getEnabled()) {
                    return 0;
                }
                if (dbp instanceof DebugBreakpointClass || dbp instanceof DebugBreakpointMethod || dbp instanceof DebugBreakpointMethodBytecode || dbp instanceof DebugBreakpointPackageFileLine) {
                    DebugLocation[] locations = dbp.getLocations();
                    return locations.length > 0 ? 3 : 2;
                }
            } else {
                return breakpoint.isEnabled() ? 2 : 0;
            }
        }
        return breakpoint.isEnabled() ? 1 : 0;
    }

    static Icon getIcon(Breakpoint breakpoint) {
        return breakpoint.getIcon();
    }

    static String getPassCountInfo(Breakpoint breakpoint) {
        int activePassCount;
        DebugBreakpoint dbp;
        int passCount = breakpoint.getPassCount();
        String s = Integer.toString(passCount);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess)) != null && (activePassCount = dbp.getPassCount()) != passCount) {
            s = s + " " + DbgArb.format(336, Integer.toString(activePassCount));
        }
        return s;
    }

    private static long[] getInstanceFiltersArray(Breakpoint breakpoint, DebuggingProcess debuggingProcess) {
        DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
        if (dbp != null) {
            return dbp.getInstanceFilters();
        }
        return new long[0];
    }

    static String getInstanceFilters(Breakpoint breakpoint) {
        long[] instanceFilters;
        int instanceFiltersLength;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (instanceFiltersLength = (instanceFilters = BreakpointRuntimeSupport.getInstanceFiltersArray(breakpoint, debuggingProcess)).length) > 0) {
            FastStringBuffer fsb = new FastStringBuffer();
            for (int i = 0; i < instanceFiltersLength; ++i) {
                fsb.append(Long.toString(instanceFilters[i]));
                if (i >= instanceFiltersLength - 1) continue;
                fsb.append(", ");
            }
            return DbgArb.format(351, fsb.toString());
        }
        return "";
    }

    private static void changeBreakpointSpecificSettingsInVm(DebugBreakpoint dbp, Breakpoint breakpoint, DebuggingProcess debuggingProcess) {
        switch (breakpoint.getType()) {
            case 0: {
                String pkg = breakpoint.getPackage();
                String file = breakpoint.getFile();
                int line = breakpoint.getLine();
                ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(pkg, file, line);
                break;
            }
            case 1: {
                String method = breakpoint.getMethod();
                ((DebugBreakpointMethod)dbp).setMethod(method);
                break;
            }
            case 7: {
                String method = breakpoint.getMethod();
                int offset = breakpoint.getOffset();
                ((DebugBreakpointMethodBytecode)dbp).setMethodBytecodeOffset(method, offset);
                break;
            }
            case 2: {
                String exception = breakpoint.getException();
                boolean caught = breakpoint.isCaught();
                boolean uncaught = breakpoint.isUncaught();
                ((DebugBreakpointException)dbp).setExceptionClassname(exception, caught, uncaught);
                break;
            }
            case 4: {
                String className = breakpoint.getClassName();
                ((DebugBreakpointClass)dbp).setClassname(className);
                break;
            }
            case 5: {
                if (dbp instanceof DebugBreakpointPackageFileLine) {
                    String[] packageAndFile = debuggingProcess.url_to_packageAndFile(breakpoint.getURL());
                    if (packageAndFile == null || packageAndFile.length != 2) break;
                    int line = breakpoint.getLine();
                    ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(packageAndFile[0], packageAndFile[1], line);
                    break;
                }
                if (!(dbp instanceof DebugBreakpointFileLine)) break;
                ((DebugBreakpointFileLine)dbp).setFileLine(breakpoint.getURL().toString(), breakpoint.getLine());
                break;
            }
            case 6: {
                String className = breakpoint.getClassName();
                String fieldName = breakpoint.getFieldName();
                boolean access = breakpoint.isAccess();
                boolean modify = breakpoint.isModify();
                ((DebugBreakpointWatchpoint)dbp).setWatchpoint(className, fieldName, access, modify);
                break;
            }
            case 8: {
                Map properties = breakpoint.getProperties();
                ((DebugBreakpointProperties)dbp).setProperties(properties);
                break;
            }
        }
    }

    static void pauseAndApplyChanges(final Breakpoint breakpoint, final Runnable runOnceLater) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    try {
                        DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
                        if (dbp != null) {
                            BreakpointRuntimeSupport.changeBreakpointSpecificSettingsInVm(dbp, breakpoint, debuggingProcess);
                            dbp.setEnabled(breakpoint.isEnabled());
                            dbp.setName(breakpoint.getGroupName());
                            dbp.setCondition(breakpoint.hasCondition() ? new DebugBreakpointConditionImpl(breakpoint) : null);
                            dbp.setThreadname(breakpoint.getThreadName());
                            dbp.setThreadnameNot(breakpoint.getThreadNameNot());
                            dbp.setPassCount(breakpoint.getPassCount());
                            dbp.setStop(breakpoint.isActionHalt());
                            dbp.setLog(breakpoint.isActionBeep() || breakpoint.isActionLog());
                            dbp.setEnableOtherBPs(breakpoint.getActionEnableOther());
                            dbp.setDisableOtherBPs(breakpoint.getActionDisableOther());
                            dbp.changeBreakpoint();
                        } else {
                            Assert.println((String)"Breakpoint.pauseAndApplyChanges - could not get DebugBreakpoint for DebuggingProcess");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        Runnable runOnceLaterWrapper = new Runnable(){

            @Override
            public void run() {
                breakpoint.updateBreakpointIcon();
                if (runOnceLater != null) {
                    runOnceLater.run();
                }
            }
        };
        BreakpointRuntimeSupport.pauseAndInvoke(breakpoint, runWhilePaused, runOnceLaterWrapper);
    }

    static void processFinished(Breakpoint breakpoint, DebuggingProcess debuggingProcess) {
        Map<DebuggingProcess, DebugBreakpoint> dp2db;
        DebugBreakpoint dbp = BreakpointRuntimeSupport.getDebugBreakpoint(breakpoint, debuggingProcess);
        if (dbp != null) {
            JDebugger.getInstance().breakpointHasBeenRemovedFromVm(dbp);
            Map<DebugBreakpoint, DebuggingProcess> db2dp = breakpointToProcess.get(breakpoint);
            if (db2dp != null) {
                db2dp.remove(dbp);
            }
        }
        if ((dp2db = processToBreakpoint.get(breakpoint)) != null) {
            dp2db.remove(debuggingProcess);
        }
    }

    static String logBreakpoint(Breakpoint breakpoint, String logMessage, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return BreakpointRuntimeSupport.prepareLog(breakpoint, logMessage, vm, thread, stack, null, null);
    }

    static String logException(Breakpoint breakpoint, String logMessage, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String classname, String detail) {
        return BreakpointRuntimeSupport.prepareLog(breakpoint, logMessage, vm, thread, stack, classname, detail);
    }

    static String logDeadlock(Breakpoint breakpoint, String logMessage, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return BreakpointRuntimeSupport.prepareLog(breakpoint, logMessage, vm, thread, stack, null, null);
    }

    static String logWatchpoint(Breakpoint breakpoint, String logMessage, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, DebugFieldInfo field, DebugDataInfo futureValue) {
        String sFutureValue;
        String msg1 = futureValue == null ? DbgArb.format(469, breakpoint.getFieldName()) : DbgArb.format(470, breakpoint.getFieldName());
        DebugDataInfo currentValue = field.getDataInfo();
        String sCurrentValue = DataValueHelper.makeDataValue(field, currentValue);
        if ((sCurrentValue == null || sCurrentValue.length() == 0) && currentValue instanceof DebugDataCompositeInfo) {
            sCurrentValue = BreakpointRuntimeSupport.makeStupidValue((DebugDataCompositeInfo)currentValue);
        }
        if (sCurrentValue != null && sCurrentValue.length() > 0) {
            msg1 = msg1 + ", " + DbgArb.format(471, sCurrentValue);
        }
        if (((sFutureValue = DataValueHelper.makeDataValue(field, futureValue)) == null || sFutureValue.length() == 0) && futureValue instanceof DebugDataCompositeInfo) {
            sFutureValue = BreakpointRuntimeSupport.makeStupidValue((DebugDataCompositeInfo)futureValue);
        }
        if (sFutureValue != null && sFutureValue.length() > 0) {
            msg1 = msg1 + ", " + DbgArb.format(472, sFutureValue);
        }
        return BreakpointRuntimeSupport.prepareLog(breakpoint, logMessage, vm, thread, stack, msg1, null);
    }

    private static String prepareLog(Breakpoint breakpoint, String logMessage, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String extra1, String extra2) {
        if (breakpoint.isActionBeep()) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (breakpoint.isActionLog()) {
            String stackMsg;
            String exprMsg;
            StringBuilder buf = new StringBuilder();
            String tag = breakpoint.getActionLogTag();
            if (tag != null && tag.length() > 0) {
                buf.append('(');
                buf.append(tag);
                buf.append(") ");
            }
            buf.append(logMessage == null ? BreakpointRuntimeSupport.getMessage(breakpoint, stack, extra1, extra2) : logMessage);
            String expr = breakpoint.getActionLogExpression();
            if (expr != null && expr.length() > 0 && (exprMsg = BreakpointRuntimeSupport.evaluateLogExpression(vm, thread, stack, expr)) != null && exprMsg.length() > 0) {
                if (extra1 != null || extra2 != null) {
                    buf.append('\n');
                } else {
                    buf.append(", ");
                }
                buf.append(exprMsg);
            }
            if (breakpoint.isActionLogStack() && (stackMsg = BreakpointRuntimeSupport.getLogStack(stack)) != null && stackMsg.length() > 0) {
                buf.append('\n');
                buf.append(stackMsg);
            }
            buf.append('\n');
            return buf.toString();
        }
        return null;
    }

    private static String getLogStack(DebugStackFrameInfo[] stack) {
        int stackLength = stack.length;
        if (stackLength > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < stackLength; ++i) {
                DebugMethodInfo method;
                DebugStackFrameInfo frame = stack[i];
                DebugLocation location = frame.getLocation();
                if (location == null || (method = location.getMethod()) == null) continue;
                String methodName = DebugShared.makeCourtesyMethodName(method, true, false, frame);
                String filename = location.getFilename();
                int line = location.getLine();
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append('\t');
                sb.append("at ");
                sb.append(methodName);
                if ((method.getAccess() & 0x100) != 0) {
                    sb.append("(Native Method)");
                    continue;
                }
                if (filename == null) continue;
                sb.append('(');
                sb.append(filename);
                if (line > 0) {
                    sb.append(':');
                    sb.append(Integer.toString(line));
                }
                sb.append(')');
            }
            return sb.toString();
        }
        return null;
    }

    private static String evaluateLogExpression(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String actionLogExpr) {
        String evaluation;
        block5: {
            evaluation = "?";
            try {
                if (stack.length > 0) {
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    Object info = evaluator.evaluate(actionLogExpr);
                    if (info != null) {
                        DebugDataInfo data = Evaluator.getDataInfo(info);
                        evaluation = DataValueHelper.makeDataValue(info, data);
                        String type = DataItem.makeType(data, true);
                        if (type != null && type.length() > 0) {
                            evaluation = evaluation + " (" + type + ")";
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)e;
            }
        }
        String msg = DbgArb.format(475, actionLogExpr, evaluation);
        return msg;
    }

    private static String getMessage(Breakpoint breakpoint, DebugStackFrameInfo[] stack, String extra1, String extra2) {
        int msgId;
        String fileName = "?";
        String line = "?";
        String methodName = "?";
        DebugClassInfo clazz = null;
        DebugLocation location = DebuggingProcess.getNonNativeLocation(stack);
        if (location != null) {
            fileName = location.getFilename();
            line = Integer.toString(location.getLine());
            DebugMethodInfo method = location.getMethod();
            if (method != null) {
                methodName = DebugShared.makeCourtesyMethodName(method, true, true, null);
                clazz = method.getClassInfo();
            }
        }
        String locationInfo = null;
        if (location != null && location.getDescription() != null) {
            locationInfo = location.getDescription();
        }
        StringBuilder buf = new StringBuilder();
        switch (breakpoint.getType()) {
            default: {
                msgId = 463;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 1: {
                msgId = 464;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(", ");
                buf.append(methodName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 7: {
                msgId = 465;
                if (locationInfo != null) break;
                buf.append(methodName);
                buf.append(':');
                buf.append(Integer.toString(location.getBytecodeOffset()));
                buf.append("(0X");
                buf.append(Integer.toHexString(location.getBytecodeOffset()).toUpperCase());
                buf.append(')');
                locationInfo = buf.toString();
                break;
            }
            case 2: {
                msgId = 466;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 3: {
                msgId = 467;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 4: {
                msgId = 473;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(", ");
                buf.append(methodName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 5: {
                msgId = 474;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(", ");
                buf.append(methodName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 6: {
                msgId = 468;
                if (locationInfo != null) break;
                buf.append(fileName);
                buf.append(", ");
                buf.append(methodName);
                buf.append(':');
                buf.append(line);
                locationInfo = buf.toString();
                break;
            }
            case 8: {
                msgId = 850;
            }
        }
        buf.setLength(0);
        buf.append(DbgArb.getString(msgId));
        if (locationInfo != null) {
            buf.append(": ");
            buf.append(locationInfo);
        }
        if (extra1 != null) {
            buf.append(", ");
            buf.append(extra1);
        }
        if (extra2 != null) {
            buf.append(", ");
            buf.append(extra2);
        }
        return buf.toString();
    }

    private static String makeStupidValue(DebugDataCompositeInfo data) {
        long number = JDebugger.getObjectNumber(data);
        return "@" + Long.toHexString(number).toUpperCase();
    }

    private static void pauseAndInvoke(Breakpoint breakpoint, RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        DebuggingProcess[] processes = JDebugger.getInstance().getDebuggingProcessesForBreakpoint(breakpoint);
        JDebugger.pauseAndInvoke(processes, runWhilePaused, runOnceLater);
    }

    static void changed(Breakpoint breakpoint, DebuggingProcess debuggingProcess) {
        if (JDebugger.getInstance().isActiveDebuggingProcess(debuggingProcess)) {
            breakpoint.updateBreakpointIcon();
        }
    }

    public BreakpointMarkerAPI getMarker(Breakpoint breakpoint) {
        if (breakpoint.getType() == 0 || breakpoint.getType() == 5) {
            BreakpointMarker marker = JDebugger.createAndAttachMarker(breakpoint.getURL(), breakpoint.getOffset(), breakpoint.getLine());
            return marker;
        }
        if (breakpoint.getType() == 7) {
            BreakpointMarker marker = JDebugger.createAndAttachMarker(breakpoint.getURL(), breakpoint.getOffset(), -1);
            breakpoint.setMarker((BreakpointMarkerAPI)marker);
            return marker;
        }
        return null;
    }

    public String getMethodName(Breakpoint breakpoint) {
        Project project;
        try {
            project = (Project)NodeFactory.findOrCreate((URL)breakpoint.getProjectURL());
        }
        catch (IllegalAccessException | InstantiationException ex) {
            return null;
        }
        URL sourceURL = breakpoint.getURL();
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(project);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canGetMethodNameFromFilenameAndLine(project, sourceURL)) continue;
            int line = breakpoint.getLine();
            String methodName = helper.getMethodNameFromFilenameAndLine(project, sourceURL, line);
            return methodName;
        }
        return null;
    }
}

