/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.net.ServerSocket;
import java.util.EventObject;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.resource.ControlsArb;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;

public final class Helpers {
    public static boolean contextMatchesSource(Context context, Object source) {
        EventObject e = context.getEvent();
        Object eSource = e != null ? e.getSource() : null;
        return eSource == source;
    }

    public static int getLocalPort() {
        try {
            ServerSocket available = new ServerSocket(0);
            int port = available.getLocalPort();
            available.close();
            return port;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getLocalPort(int min, int max) {
        for (int port = min; port <= max; ++port) {
            try {
                ServerSocket available = new ServerSocket(port);
                available.close();
                return port;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return 0;
    }

    public static JDK getActiveJdkDefinition(Project project) {
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        if (projectLibs != null) {
            return projectLibs.getJDK();
        }
        return null;
    }

    public static Icon getUpArrowIcon() {
        return ControlsArb.getIcon((int)2);
    }

    public static Icon getDownArrowIcon() {
        return ControlsArb.getIcon((int)1);
    }

    public static boolean findMnemonics(String[] names, char[] mnemonics, int index) {
        if (index >= names.length) {
            return true;
        }
        String name = names[index];
        if (name == null) {
            return false;
        }
        mnemonics[index] = '\u0000';
        block0: for (int y = 0; y < name.length(); ++y) {
            mnemonics[index] = name.charAt(y);
            if (Character.isWhitespace(mnemonics[index])) continue;
            for (int z = 0; z < index; ++z) {
                if (mnemonics[z] != mnemonics[index]) continue;
                mnemonics[index] = '\u0000';
                continue block0;
            }
            if (!Helpers.findMnemonics(names, mnemonics, index + 1)) continue;
            return true;
        }
        return false;
    }
}

