/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.shuttle;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.datatransfer.TransferableContext;
import oracle.olap.app.templates.templatedialog.TemplateData;
import oracle.olap.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;

public abstract class DropHandler<E> {
    private static final Logger LOG = Logger.getLogger(DropHandler.class.getName());
    private static final DataFlavor NAVIGATOR_FLAVOR = TransferableContext.contextFlavor;
    private TemplateHandler handler;
    private InsertionHandlerEditorPlugin ihandler;

    private DropHandler() {
    }

    public DropHandler(TemplateHandler templateHandler, InsertionHandlerEditorPlugin insertionHandlerEditorPlugin) {
        this.handler = templateHandler;
        this.ihandler = insertionHandlerEditorPlugin;
    }

    public final boolean handleDrop(E e) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        if (this.isFlavorAvailable(TemplateData.templateFlavor, e)) {
            TemplateData templateData = (TemplateData)this.getData(TemplateData.templateFlavor, e);
            try {
                templateData = this.handler.callTemplate(templateData.getSyntax(), new TemplateData.Mode[]{templateData.getMode()});
                if (templateData != null) {
                    this.ihandler.insertSyntax(templateData, point, true);
                    return true;
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        } else {
            String string;
            if (this.isFlavorAvailable(NAVIGATOR_FLAVOR, e)) {
                TransferableContext transferableContext = (TransferableContext)this.getData(NAVIGATOR_FLAVOR, e);
                URL uRL = transferableContext.getContext().getNode().getURL();
                String string2 = DBURLFormatHelper.getName((URL)uRL);
                this.ihandler.insertSyntax(new TemplateData(string2, TemplateData.Mode.REPLACE), point, true);
                return true;
            }
            if (this.isFlavorAvailable(DataFlavor.stringFlavor, e) && (string = (String)this.getData(DataFlavor.stringFlavor, e)) != null) {
                this.ihandler.insertSyntax(new TemplateData(string, TemplateData.Mode.REPLACE), point, true);
                return true;
            }
        }
        return false;
    }

    public final boolean canHandleDrop(DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.equals(TemplateData.templateFlavor) && !dataFlavor.equals(NAVIGATOR_FLAVOR) && !dataFlavor.equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    protected abstract Object getData(DataFlavor var1, E var2);

    protected abstract boolean isFlavorAvailable(DataFlavor var1, E var2);
}

