/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.db.AWListRunnable;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.view.DBObjectInitializer;
import oracle.olap.db.view.DescriptionFields;
import oracle.olap.db.view.GeneralBaseEditorPanelContext;
import oracle.olap.db.view.OLAPHeaderPanel;
import oracle.olap.db.view.OLAPHeaderPanelReference;
import oracle.olap.db.view.PanelUtil;
import oracle.olap.util.UIStringUtils;

public abstract class GeneralBaseEditorPanel<T extends AbstractSchemaObjectWithDesc>
extends BaseEditorPanel<T>
implements DescriptionFields,
PropertyChangeListener {
    private boolean m_initialized;
    private JLabel shortDescLabel = new JLabel();
    private JLabel longDescLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private JTextField descriptionFld = new JTextField();
    private JTextField shortDescriptionFld = new JTextField();
    private JTextField longDescriptionFld = new JTextField();
    private JLabel awLabel = new JLabel();
    private JLabel awNameLabel = new JLabel();
    private DefaultComboBoxModel awModel = new DefaultComboBoxModel();
    private JComboBox awComboBox = new JComboBox(this.awModel);
    private DBObjectInitializer dbObjectInitializer;
    private boolean longDescTextFieldUpdated = false;
    private boolean shortDescTextFieldUpdated = false;
    private boolean descriptionTextFieldUpdated = false;
    private static final String ANALYTIC_WORKSPACE_LIST = "ANALYTIC_WORKSPACE_LIST";

    @Override
    public JLabel getDescriptionLabel() {
        return this.descLabel;
    }

    @Override
    public JLabel getShortDescriptionLabel() {
        return this.shortDescLabel;
    }

    @Override
    public JLabel getLongDescriptionLabel() {
        return this.longDescLabel;
    }

    @Override
    public JTextField getDescriptionFld() {
        return this.descriptionFld;
    }

    @Override
    public JTextField getShortDescriptionFld() {
        return this.shortDescriptionFld;
    }

    @Override
    public JTextField getLongDescriptionFld() {
        return this.longDescriptionFld;
    }

    public boolean isAnalyticWorkspaceRequired() {
        return false;
    }

    protected void updateDescriptions() {
        String string = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getLongDescription();
        this.longDescriptionFld.setText(string);
        String string2 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getShortDescription();
        this.shortDescriptionFld.setText(string2);
        String string3 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getDescription();
        this.descriptionFld.setText(string3);
    }

    protected void setDbObjectInitializer(DBObjectInitializer dBObjectInitializer) {
        this.dbObjectInitializer = dBObjectInitializer;
    }

    protected void initialisePanel() {
        Object object;
        if (!this.m_initialized) {
            Map map;
            Object v;
            object = GeneralBaseEditorPanelContext.getInstance();
            ((GeneralBaseEditorPanelContext)object).setDescriptionSynchOn(true);
            this.initializeDescriptionTextFieldModifiedState();
            this.initializeDescriptionFieldKeyListeners();
            if (this.isAnalyticWorkspaceRequired()) {
                this.initAnalyticWorkspaces();
            }
            if (!this.isEditing() && this.dbObjectInitializer != null && (v = (map = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getProperties()).get("TemplateObject")) == null) {
                this.dbObjectInitializer.init(this.getProvider(), (AbstractSchemaObjectWithDesc)this.getOriginalObject(), (AbstractSchemaObjectWithDesc)this.getUpdatedObject());
            }
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    List list = dBObjectChange.getOwnedObjectsAdded();
                    if (list != null && list.size() > 0) {
                        for (DBObject dBObject : list) {
                            if (!(dBObject instanceof AbstractChildObjectWithDesc)) continue;
                            AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)dBObject;
                            abstractChildObjectWithDesc.setNewObject();
                        }
                    }
                    if (GeneralBaseEditorPanel.this.isEditing()) {
                        return;
                    }
                    Map map = dBObjectChange.getPropertiesChanged();
                    GeneralBaseEditorPanel.this.synchronizeDescriptionsFromName(map);
                }
            });
        }
        this.updateDescriptions();
        if (this.isEditing()) {
            object = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getAnalyticWorkspace();
            this.awModel.setSelectedItem(object);
            this.awNameLabel.setText((String)object);
            this.awNameLabel.setVisible(true);
            this.awComboBox.setVisible(false);
        }
        this.m_initialized = true;
    }

    private void initializeDescriptionTextFieldModifiedState() {
        if (!this.isEditing()) {
            AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)this.getUpdatedObject();
            abstractSchemaObjectWithDesc.markDescriptionDirty(false);
            abstractSchemaObjectWithDesc.markLongDescriptionDirty(false);
            abstractSchemaObjectWithDesc.markShortDescriptionDirty(false);
        }
    }

    private void initializeDescriptionFieldKeyListeners() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)GeneralBaseEditorPanel.this.getUpdatedObject();
                if (keyEvent.getSource() == GeneralBaseEditorPanel.this.longDescriptionFld) {
                    abstractSchemaObjectWithDesc.setLongDescription(GeneralBaseEditorPanel.this.longDescriptionFld.getText());
                    GeneralBaseEditorPanel.this.longDescTextFieldUpdated = true;
                } else if (keyEvent.getSource() == GeneralBaseEditorPanel.this.shortDescriptionFld) {
                    abstractSchemaObjectWithDesc.setShortDescription(GeneralBaseEditorPanel.this.shortDescriptionFld.getText());
                    GeneralBaseEditorPanel.this.shortDescTextFieldUpdated = true;
                } else if (keyEvent.getSource() == GeneralBaseEditorPanel.this.descriptionFld) {
                    abstractSchemaObjectWithDesc.setDescription(GeneralBaseEditorPanel.this.descriptionFld.getText());
                    GeneralBaseEditorPanel.this.descriptionTextFieldUpdated = true;
                }
            }
        };
        this.longDescriptionFld.addKeyListener(keyAdapter);
        this.shortDescriptionFld.addKeyListener(keyAdapter);
        this.descriptionFld.addKeyListener(keyAdapter);
    }

    private void synchronizeDescriptionsFromName(Map<String, PropertyChangeEvent> map) {
        GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
        if (!generalBaseEditorPanelContext.isDescriptionSynchOn()) {
            return;
        }
        for (String string : map.keySet()) {
            String string2;
            Object object;
            Object object2;
            if (!string.equals("name")) continue;
            OLAPHeaderPanelReference oLAPHeaderPanelReference = OLAPHeaderPanelReference.getInstance();
            OLAPHeaderPanel oLAPHeaderPanel = oLAPHeaderPanelReference.getOLAPHeaderPanel();
            ComponentFactory componentFactory = oLAPHeaderPanel.getPanelHelper();
            ComponentWrapper componentWrapper = componentFactory.findComponentWrapper("name");
            String string3 = null;
            if (componentWrapper == null) {
                string3 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName();
            } else {
                object2 = componentWrapper.getActiveComponent();
                if (object2 instanceof JTextField) {
                    object = (JTextField)componentWrapper.getActiveComponent();
                    string2 = ((JTextComponent)object).getText();
                    if (string2.contains("\"")) {
                        string2 = string2.replaceAll("\"", "");
                        ((JTextComponent)object).setText(string2);
                    }
                    string3 = ((JTextComponent)object).getText();
                } else {
                    string3 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName();
                }
            }
            object2 = (AbstractSchemaObjectWithDesc)this.getUpdatedObject();
            object = this.descriptionFld.getText();
            string2 = this.longDescriptionFld.getText();
            String string4 = this.shortDescriptionFld.getText();
            boolean bl = object != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName(), (String)object);
            boolean bl2 = string2 != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName(), string2);
            boolean bl3 = string4 != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getName(), string4);
            this.descriptionTextFieldUpdated = this.descriptionTextFieldUpdated || ((AbstractSchemaObjectWithDesc)object2).getDescriptionDirty() != false;
            this.longDescTextFieldUpdated = this.longDescTextFieldUpdated || ((AbstractSchemaObjectWithDesc)object2).getLongDescriptionDirty() != false;
            boolean bl4 = this.shortDescTextFieldUpdated = this.shortDescTextFieldUpdated || ((AbstractSchemaObjectWithDesc)object2).getShortDescriptionDirty() != false;
            if (!(this.descriptionTextFieldUpdated || object != null && bl)) {
                ((AbstractSchemaObjectWithDesc)object2).setDescription(UIStringUtils.convertDescription(string3));
            }
            if (!(this.longDescTextFieldUpdated || string2 != null && bl2)) {
                ((AbstractSchemaObjectWithDesc)object2).setLongDescription(UIStringUtils.convertDescription(string3));
            }
            if (!(this.shortDescTextFieldUpdated || string4 != null && bl3)) {
                ((AbstractSchemaObjectWithDesc)object2).setShortDescription(UIStringUtils.convertDescription(string3));
            }
            this.updateDescriptions();
        }
    }

    protected void commitPanel() throws TraversalException {
        String string = this.descriptionFld.getText();
        ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setDescription(string);
        string = this.shortDescriptionFld.getText();
        ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setShortDescription(string);
        string = this.longDescriptionFld.getText();
        ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setLongDescription(string);
        if (this.awModel.getSize() > 0) {
            String string2 = (String)this.awModel.getSelectedItem();
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setAnalyticWorkspace(string2);
        }
    }

    protected void registerDescriptionFields() {
        ComponentFactory componentFactory = this.getComponentFactory();
        PanelUtil.registerDescriptionFields(componentFactory, this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void registerAnalyticWorkspaceField() {
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent(this.awLabel, (Component)this.awComboBox, OLAPArb.get("ANALYTIC_WORKSPACE_LABEL"), "analyticWorkspace");
    }

    protected int layoutDescriptionFields(JPanel jPanel) {
        this.awNameLabel.setVisible(false);
        if (this.awLabel.getText().length() == 0) {
            this.awLabel.setText(OLAPArb.get("ANALYTIC_WORKSPACE_LABEL"));
        }
        int n = PanelUtil.layoutDescriptionFields(jPanel, this, 0);
        ++n;
        if (this.isAnalyticWorkspaceRequired()) {
            jPanel.add((Component)this.awLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
            jPanel.add((Component)this.awComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.awNameLabel, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.awComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        String string = (String)itemEvent.getItem();
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "analyticWorkspace", null, string);
                        GeneralBaseEditorPanel.this.propertyChange(propertyChangeEvent);
                    }
                }
            });
        }
        return n;
    }

    protected void initAnalyticWorkspaces() {
        Object object;
        List<String> list = null;
        Object object2 = this.getDataContext().get(ANALYTIC_WORKSPACE_LIST);
        if (object2 == null) {
            object = (Database)this.getProvider();
            String string = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getSchema().getName();
            list = this.getAnalyticWorkspaces(object.getConnection(), string);
            this.getDataContext().put(ANALYTIC_WORKSPACE_LIST, list);
        } else {
            list = (List<String>)object2;
        }
        this.awModel.removeAllElements();
        for (String string : list) {
            this.awModel.addElement(string);
        }
        object = (String)this.awModel.getSelectedItem();
        if (!this.isEditing()) {
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setAnalyticWorkspace((String)object);
        }
    }

    private List<String> getAnalyticWorkspaces(Connection connection, String string) {
        List<String> list = null;
        try {
            AWListRunnable aWListRunnable = new AWListRunnable(connection, string);
            String string2 = OLAPArb.get("AW.FETCH.TITLE");
            string2 = MessageFormat.format(string2, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)aWListRunnable, true);
            progressBar.setCancelable(false);
            aWListRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("AW.FETCH.LIST"), null);
            if (aWListRunnable.getException() != null) {
                throw aWListRunnable.getException();
            }
            list = aWListRunnable.getAnalyticWorkspaces();
        }
        catch (Exception exception) {
            String string3 = null;
            String string4 = exception.getLocalizedMessage();
            if (string4 == null || string4.length() == 0) {
                string4 = exception.getClass().toString();
            }
            String string5 = OLAPArb.get("AW.FETCH.TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string3);
        }
        return list;
    }
}

