/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.view;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.olap.app.db.Database;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templateview.TemplateMetadata;

public class TemplateContext {
    private Schema schema;
    private Database database;
    private Cube cube;
    private Dimension baseDimension;
    private Dimension timeDimension;
    private List<Dimension> referenceDimensions;
    private TemplateMetadata templateMetadata;

    public TemplateContext() {
    }

    public TemplateContext(Database database, TemplateMetadata templateMetadata) throws SQLException, IOException {
        this.database = database;
        this.templateMetadata = templateMetadata;
        this.referenceDimensions = new ArrayList<Dimension>();
        if (templateMetadata.getBaseDimension() != null) {
            String string;
            if (templateMetadata.getTimeDimension() != null) {
                this.schema = templateMetadata.getTimeDimension().getSchema();
                string = templateMetadata.getTimeDimension().getName();
                this.timeDimension = this.schema.findDimension(string);
            } else {
                this.schema = templateMetadata.getBaseDimension().getSchema();
            }
            string = templateMetadata.getBaseDimension().getName();
            this.baseDimension = this.schema.findDimension(string);
            if (this.baseDimension == null) {
                this.loadSchema();
                this.baseDimension = this.schema.findDimension(string);
            }
            List<Object> list = new ArrayList();
            list = templateMetadata.getReferenceDimensions();
            Dimension dimension = null;
            if (list != null) {
                for (Dimension dimension2 : list) {
                    string = dimension2.getName();
                    dimension = this.schema.findDimension(string);
                    this.referenceDimensions.add(dimension);
                }
            }
        } else {
            this.schema = templateMetadata.getCube().getSchema();
            String string = templateMetadata.getCube().getName();
            this.cube = this.schema.findCube(string);
            if (this.cube == null) {
                this.loadSchema();
                this.cube = this.schema.findCube(string);
            }
            if (templateMetadata.getTimeDimension() != null) {
                this.timeDimension = this.schema.findDimension(templateMetadata.getTimeDimension().getName());
            }
        }
    }

    public void reinitialize(TemplateMetadata templateMetadata) {
        this.templateMetadata = templateMetadata;
        if (this.templateMetadata.getBaseDimension() != null) {
            List<Dimension> list;
            this.schema = this.templateMetadata.getBaseDimension().getSchema();
            String string = this.templateMetadata.getBaseDimension().getName();
            this.baseDimension = this.schema.findDimension(string);
            if (this.templateMetadata.getTimeDimension() != null) {
                list = this.templateMetadata.getTimeDimension().getName();
                this.timeDimension = this.schema.findDimension((String)((Object)list));
            }
            list = new ArrayList();
            list = this.templateMetadata.getReferenceDimensions();
            Dimension dimension = null;
            if (list != null) {
                for (Dimension dimension2 : list) {
                    string = dimension2.getName();
                    dimension = this.schema.findDimension(string);
                    this.referenceDimensions.add(dimension);
                }
            }
        } else if (this.templateMetadata.isCube()) {
            this.schema = this.templateMetadata.getCube().getSchema();
            String string = this.templateMetadata.getCube().getName();
            this.cube = this.schema.findCube(string);
            if (this.templateMetadata.getTimeDimension() != null) {
                String string2 = this.templateMetadata.getTimeDimension().getName();
                this.timeDimension = this.schema.findDimension(string2);
            }
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public Dimension getTimeDimension() {
        return this.timeDimension;
    }

    public Dimension getBaseDimension() {
        return this.baseDimension;
    }

    public List<Dimension> getReferenceDimensions() {
        return this.referenceDimensions;
    }

    public List<Dimension> getCubeDimensions() {
        return this.cube.getDimensions();
    }

    public List<Dimension> getDimensions() {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        Cube cube = this.templateMetadata.getCube();
        if (cube != null) {
            return cube.getDimensions();
        }
        arrayList.add(this.templateMetadata.getBaseDimension());
        return arrayList;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public TemplateMetadata getTemplateMetadata() {
        return this.templateMetadata;
    }

    public void setTemplateMetadata(TemplateMetadata templateMetadata) {
        this.templateMetadata = templateMetadata;
    }

    private void loadSchema() throws SQLException, IOException {
        Connection connection = this.database.getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        try {
            this.schema = OLAPMetadataCache.getUpdatedSchema(string, this.schema.getName());
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public boolean isCube() {
        return this.templateMetadata.isCube();
    }
}

