/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.LinkedList;
import java.util.List;
import oracle.olap.app.syntaxparser.FlatNode;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class LoopNode
extends FlatNode {
    private FlatNode loop;
    private FlatNode cursor;
    private LinkedList<ParseNode> valueList = new LinkedList();
    private List<TemplateHyperParam> params;

    LoopNode(ParseNode parseNode, String string) {
        super(parseNode, string);
    }

    public void setLoop(FlatNode flatNode) {
        this.loop = flatNode;
        this.cursor = flatNode;
    }

    @Override
    public FlatNode getSpecial() {
        return super.getNext();
    }

    @Override
    int matches(ParseNode parseNode) {
        int n = this.cursor.matches(parseNode);
        if (n > 0) {
            this.cursor = this.cursor.nextMatch();
            if (this.cursor == null) {
                this.cursor = this.loop;
            }
            return n;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Loop[");
        for (FlatNode flatNode = this.loop; flatNode != null; flatNode = flatNode.getNext()) {
            stringBuilder.append(flatNode == null ? "_" : flatNode);
            stringBuilder.append(',');
        }
        stringBuilder.append("]:");
        stringBuilder.append(this.paramName);
        return stringBuilder.toString();
    }

    @Override
    public Element marshall(Document document, Element element) {
        Element element2 = super.marshall(document, element);
        for (FlatNode flatNode = this.loop; flatNode != null; flatNode = flatNode.getNext()) {
            flatNode.marshall(document, element2);
        }
        return element2;
    }

    @Override
    public FlatNode nextMatch() {
        return this;
    }

    @Override
    public void restartMatch() {
        this.cursor = this.loop;
        this.params = null;
        this.valueList = new LinkedList();
    }

    @Override
    public boolean tryLoad(List<TemplateHyperParam> list, ParseNode parseNode) {
        boolean bl = false;
        if (parseNode == null) {
            if (list != null) {
                for (TemplateHyperParam templateHyperParam : list) {
                    if (!templateHyperParam.getName().equals(this.getParamName())) continue;
                    templateHyperParam.setValue(this.valueList);
                    list.remove(templateHyperParam);
                    bl = true;
                    break;
                }
                list = null;
            }
        } else {
            this.valueList.add(parseNode);
            this.params = list;
        }
        return bl;
    }
}

