/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.db.ora.Oracle12c;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.actions.RenameDialog;
import oracle.olap.db.model.Descriptions;
import oracle.olap.util.OLAPNameValidator;

public abstract class AbstractRenameAction
extends AbstractOLAPDDLAction {
    private String newObjectName;
    private Map<String, String> descriptions;
    private RenameDialog renameDialog;

    protected Descriptions getRenameObject() {
        return this.getSchemaObjectWithDescription();
    }

    @Override
    public void launch() {
        final DBObject dBObject = this.getDBObject();
        final String string = dBObject.getSchemaName();
        final String string2 = this.getObjectCurrentName();
        final String string3 = this.getHelpID();
        final String string4 = this.getConfirmTitle(string2);
        String string5 = this.getProgressMsg();
        RaptorTask raptorTask = new RaptorTask(string5, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    AbstractRenameAction.this.init();
                    AbstractRenameAction.this.renameDialog = new RenameDialog((Frame)Ide.getMainWindow(), string4, string3, string, string2, AbstractRenameAction.this.getObjectDescriptions(), dBObject.getDatabase(), AbstractRenameAction.this);
                    AbstractRenameAction.this.renameDialog.setMinimumSize(new Dimension(450, 300));
                    AbstractRenameAction.this.renameDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string5);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        Logger.getLogger(this.getClass().getName()).severe(throwable.toString());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractRenameAction.this.renameDialog.setVisible(true);
                        if (AbstractRenameAction.this.renameDialog.isOKSelected()) {
                            AbstractRenameAction.this.updateOLAPObject();
                            AbstractRenameAction.super.launch();
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    @Override
    protected String getOLAPDDLStatements() throws Exception {
        this.updateOLAPObject();
        return super.getOLAPDDLStatements();
    }

    @Override
    protected String getHelpID() {
        String string = "olap_rename_object";
        return string;
    }

    private void updateOLAPObject() {
        Map<String, String> map = this.getObjectDescriptions();
        map.put("Description", this.renameDialog.getNewDescription());
        map.put("ShortDescription", this.renameDialog.getNewShortDescription());
        map.put("LongDescription", this.renameDialog.getNewLongDescription());
        this.setNewObjectName(this.renameDialog.getNewName());
        this.setNewObjectDescriptions(map);
    }

    protected abstract void init();

    protected abstract Map<String, String> getObjectDescriptions();

    protected void setNewObjectName(String string) {
        this.newObjectName = string;
    }

    protected String getNewObjectName() {
        return this.newObjectName.toUpperCase();
    }

    protected void setNewObjectDescriptions(Map<String, String> map) {
        this.descriptions = map;
    }

    protected Map<String, String> getNewObjectDescriptions() {
        return this.descriptions;
    }

    protected abstract String getObjectType();

    protected String getObjectCurrentName() {
        return this.getObjectName();
    }

    protected boolean isObjectNameUnique(String string) {
        return this.isObjectNameUnique(this.getDBObject(), string);
    }

    protected String getDictionaryObjectType() {
        return this.getObjectType();
    }

    protected final String getSchemaObjectName() {
        return this.getSchemaObjectWithDescription().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, String> getObjectDescriptionsFromQuery(DBObject dBObject, String string, String string2) {
        block6: {
            ResultSet resultSet;
            Connection connection;
            HashMap<String, String> hashMap;
            block5: {
                if (!(dBObject.getDatabase() instanceof Oracle12c)) break block6;
                hashMap = new HashMap<String, String>();
                connection = dBObject.getConnection();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("owner", dBObject.getSchemaName());
                hashMap2.put("object_name", string2);
                hashMap2.put("object_type", string);
                String string3 = "select description_type, description_value  from all_cube_descriptions where owner = :owner and object_name = :object_name and object_type  = :object_type";
                resultSet = null;
                try {
                    Connections.getInstance().lock(connection);
                    resultSet = dBUtil.executeQuery(string3, hashMap2);
                    if (resultSet == null) break block5;
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        String string5 = resultSet.getString(2);
                        hashMap.put(string4, string5);
                    }
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
            return hashMap;
        }
        return null;
    }

    private boolean isObjectNameUnique(DBObject dBObject, String string) {
        if (dBObject.getDatabase() instanceof Oracle12c) {
            Connection connection = dBObject.getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            return OLAPNameValidator.isObjectNameUnique(string, dBObject.getSchemaName(), dBUtil);
        }
        return false;
    }

    private String getProgressMsg() {
        return OLAPArb.getString("GENERAL_RENAME_DLG_INIT_MSG");
    }

    @Override
    protected boolean isRemoveNodeRequired() {
        return false;
    }
}

