/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.beans.PropertyChangeEvent;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;

public class IndexPropertiesPanel
extends BaseEditorPanel<Index> {
    public IndexPropertiesPanel() {
        super("IndexPropertiesPanel");
    }

    @Override
    protected void initialisePanel() {
    }

    @Override
    protected void initialiseComponents() {
        ComponentWrapper cwKeyCompression = this.getOrCreateWrapper("keyCompression");
        ComponentWrapper cwParallelDegree = this.getOrCreateWrapper("parallelDegree");
        ComponentWrapper cwReverse = this.getOrCreateWrapper("reverse");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add(cwKeyCompression);
        layout.nextRow();
        layout.add(cwParallelDegree);
        layout.nextRow();
        layout.add(cwReverse);
        layout.nextRow();
        layout.pushUp();
        layout.layout();
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"indexType", "keyCompression"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent indexTypeChangeEvent) {
                String prop = indexTypeChangeEvent.getPropertyName();
                if (prop.equals("indexType")) {
                    IndexPropertiesPanel.this.getComponentFactory().processComponents();
                } else if (prop.equals("keyCompression") && indexTypeChangeEvent.getOldValue() != null && indexTypeChangeEvent.getNewValue() == null) {
                    IndexPartition[] ips;
                    OracleIndexPartitions oip = (OracleIndexPartitions)((Index)IndexPropertiesPanel.this.getUpdatedObject()).getProperty("OracleIndexPartitions");
                    IndexPartition[] indexPartitionArray = ips = oip != null ? oip.getPartitions() : null;
                    if (ips != null) {
                        for (IndexPartition ip : ips) {
                            if (ip == null) continue;
                            ip.setUseKeyCompression(null);
                        }
                    }
                }
            }
        };
    }
}

