/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectTabbedEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.table.ConstraintEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ButtonMenu;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.ModelUtil;

public class ConstraintsPanel
extends ChildTableEditorPanel<Constraint, Relation> {
    private static final String CONSTRAINT_TYPE = "constraintType";
    private final Comparator<Constraint> m_comparator = new CC();
    private final Map<ConstraintType, JMenuItem> m_menuItems = new EnumMap<ConstraintType, JMenuItem>(ConstraintType.class);

    public ConstraintsPanel() {
        super("ConstraintsPanel");
    }

    @Override
    protected DBObjectListener createObjectListener() {
        return new SwingDBObjectPropertyListener(new String[]{"constraints"}){

            @Override
            protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                ConstraintsPanel.this.modelChanged();
            }
        };
    }

    @Override
    protected Class getChildClass() {
        return Constraint.class;
    }

    @Override
    protected String getChildProperty() {
        return "constraints";
    }

    @Override
    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic<Constraint> logic = new ChildTableEditorPanel.NonPropertyColumnLogic<Constraint>(){

            @Override
            public Object getCellValue(Constraint rowObject) {
                return ConstraintType.valueOf(rowObject.getConstraintType());
            }
        };
        this.addColumn(0, DisplayNames.getPropertyDisplayName((String)CONSTRAINT_TYPE), ConstraintType.class, logic, (TableCellRenderer)((Object)new ConstraintTypeCellRenderer()));
    }

    private void modelChanged() {
        Relation rel = (Relation)this.getUpdatedObject();
        if (rel != null) {
            this.checkAddMenuItems();
            if (!this.isInFlatEditor()) {
                Table table = (Table)this.getEditorConfig().getUpdatedObject();
                ConstraintIndexHelper helper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
                helper.clearNewUnusedIndexes(table);
            }
        }
    }

    private void checkAddMenuItems() {
        for (Map.Entry<ConstraintType, JMenuItem> entry : this.m_menuItems.entrySet()) {
            entry.getValue().setEnabled(this.isConstraintTypeEnabled(entry.getKey()));
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.checkAddMenuItems();
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"name", "enabled", "deferrableState"};
    }

    @Override
    protected ChildObjectEditorPanel<Constraint, Relation> createChildPanel() {
        Navigable[] defNavs;
        ArrayList<Navigable> navs = null;
        PanelLibrary lib = (PanelLibrary)this.getDataContext().find(PanelLibrary.class);
        if (lib != null && (defNavs = lib.getDefaultPanels(this.isEditing())) != null && defNavs.length > 0) {
            navs = new ArrayList<Navigable>();
            navs.add(new DBNavigable(UIBundle.get("PROPERTIES"), ConstraintEditorPanel.class));
            for (int i = 0; i < defNavs.length; ++i) {
                navs.add(defNavs[i]);
            }
        }
        ChildObjectEditorPanel retval = navs != null ? new ChildObjectTabbedEditorPanel(this.getName(), navs) : new ConstraintEditorPanel();
        return retval;
    }

    @Override
    protected boolean preserveListOrder() {
        return false;
    }

    @Override
    protected Comparator<Constraint> getChildComparator() {
        return this.m_comparator;
    }

    @Override
    protected AbstractButton createAddButton() {
        Collection allowedTypes = this.getProvider().getPropertyManager().getAllowedPropertyValues(null, (DBObject)new Table(), Property.createPath((String[])new String[]{"constraints", CONSTRAINT_TYPE}));
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (ConstraintType type : ConstraintType.values()) {
            if (!allowedTypes.contains(type.toString())) continue;
            items.add(this.createMenuItem(type));
        }
        JToggleButton button = ButtonMenu.createButtonMenu(null, (Icon)OracleIcons.getIcon((String)"add.png"), items);
        String txt = UIBundle.get("CONSTRAINT_BUTTON_ADD");
        button.setToolTipText(txt);
        button.getAccessibleContext().setAccessibleDescription(txt);
        return button;
    }

    private void createConstraint(ConstraintType type) {
        Constraint newCon;
        Relation rel = (Relation)this.getUpdatedObject();
        if (rel != null && this.exitChildPanel() && (newCon = ConstraintsPanel.newConstraint(rel, type, this.getChildNames(), null, this.getProvider())) != null) {
            this.addChildRow((ChildDBObject[])new Constraint[]{newCon});
            this.selectChild(newCon);
        }
    }

    private JMenuItem createMenuItem(final ConstraintType type) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintsPanel.this.createConstraint(type);
            }

            @Override
            public boolean isEnabled() {
                return ConstraintsPanel.this.isConstraintTypeEnabled(type);
            }
        };
        action.putValue("SmallIcon", type.getIcon());
        action.putValue("Name", UIBundle.format("CONSTRAINT_NEW_LABEL", type.getName()));
        JMenuItem retval = new JMenuItem(action);
        this.m_menuItems.put(type, retval);
        return retval;
    }

    private boolean isConstraintTypeEnabled(ConstraintType type) {
        boolean retval = true;
        Relation rel = (Relation)this.getUpdatedObject();
        if (rel == null) {
            retval = false;
        } else {
            Collection allowedTypes = this.getProvider().getPropertyManager().getAllowedPropertyValues(this.getOriginalObject(), this.getUpdatedObject(), Property.createPath((String[])new String[]{"constraints", CONSTRAINT_TYPE}));
            retval = allowedTypes.contains(type.toString());
        }
        if (retval && type == ConstraintType.PKConstraint) {
            retval = PKConstraint.getPrimaryKey((Relation)rel) == null;
        }
        return retval;
    }

    @Override
    protected boolean isHorizontalSplit() {
        return false;
    }

    public static FKConstraint newFKConstraint(Relation parent, DBObjectID referenceID, DBObjectProvider pro) {
        String joinTableName = null;
        if (referenceID instanceof TemporaryObjectID) {
            DBObject obj = null;
            try {
                obj = referenceID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            DBObject joinParent = obj.getParent();
            if (joinParent != null) {
                joinTableName = joinParent.getName();
            }
        } else if (referenceID != null) {
            DBObjectID relationID = referenceID.getParent();
            joinTableName = DBUtil.getDBObjectName((DBObjectID)relationID);
        }
        FKConstraint fk = (FKConstraint)ConstraintsPanel.newConstraint(parent, ConstraintType.FKConstraint, null, joinTableName, pro);
        fk.setReferenceID(referenceID);
        return fk;
    }

    public static Constraint newConstraint(Relation parent, String constraintType, DBObjectProvider pro) {
        return ConstraintsPanel.newConstraint(parent, ConstraintType.valueOf(constraintType), null, null, pro);
    }

    private static Constraint newConstraint(Relation parent, ConstraintType type, Collection<String> existingNames, String foreignTableName, DBObjectProvider pro) {
        if (existingNames == null) {
            existingNames = new ArrayList<String>();
            for (Constraint c : parent.getConstraints()) {
                existingNames.add(c.getName());
            }
        }
        Constraint retval = (Constraint)pro.getObjectFactory().newObject(type.getConstraintClass(), (DBObject)parent);
        int maxLen = pro.getDescriptor().getMaxNameLength("CONSTRAINT");
        int postFixLen = type.getPostfix().length();
        if (retval.getName() == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(parent.getName());
            if (ModelUtil.hasLength((String)foreignTableName) && builder.length() + foreignTableName.length() + postFixLen + 1 < maxLen) {
                builder.append("_");
                builder.append(foreignTableName);
            }
            if (builder.length() + postFixLen >= maxLen) {
                builder.delete(maxLen - postFixLen - 1, builder.length());
            }
            builder.append(type.getPostfix());
            String name = DBUtil.getUniqueName(existingNames, (String)builder.toString(), (boolean)true);
            retval.setName(name);
        }
        TemporaryObjectID.setID((DBObject)retval, (boolean)true);
        return retval;
    }

    static enum ConstraintType {
        PKConstraint,
        UniqueConstraint,
        FKConstraint,
        CheckConstraint;


        public Class<? extends Constraint> getConstraintClass() {
            switch (this) {
                case UniqueConstraint: {
                    return UniqueConstraint.class;
                }
                case FKConstraint: {
                    return FKConstraint.class;
                }
                case CheckConstraint: {
                    return CheckConstraint.class;
                }
            }
            return PKConstraint.class;
        }

        public Icon getIcon() {
            switch (this) {
                case FKConstraint: {
                    return OracleIcons.getIcon((String)"foreignkey.png");
                }
                case CheckConstraint: {
                    return OracleIcons.getIcon((String)"constraint.png");
                }
                case PKConstraint: {
                    return OracleIcons.getIcon((String)"primarykey.png");
                }
            }
            return OracleIcons.getIcon((String)"key.png");
        }

        public String getName() {
            return PropertyDisplayRegistry.getPropValueDisplay(ConstraintsPanel.CONSTRAINT_TYPE, this.toString());
        }

        public String getPostfix() {
            switch (this) {
                case UniqueConstraint: {
                    return "_UK1";
                }
                case FKConstraint: {
                    return "_FK1";
                }
                case CheckConstraint: {
                    return "_CHK1";
                }
            }
            return "_PK";
        }
    }

    private static class CC
    implements Comparator<Constraint> {
        private CC() {
        }

        @Override
        public int compare(Constraint con1, Constraint con2) {
            int retval;
            if (con1 == con2) {
                retval = 0;
            } else if (con1 == null) {
                retval = 100;
            } else if (con2 == null) {
                retval = -100;
            } else {
                String type1 = con1.getConstraintType();
                String type2 = con2.getConstraintType();
                int typeCompare = ConstraintType.valueOf(type1).compareTo(ConstraintType.valueOf(type2));
                retval = typeCompare == 0 ? DBUtil.getNameComparator().compare(con1, con2) : typeCompare * 10;
            }
            return retval;
        }
    }

    static class ConstraintTypeCellRenderer
    extends GenericTableCellRenderer {
        ConstraintTypeCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component retval = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (retval instanceof JLabel && value instanceof ConstraintType) {
                ((JLabel)retval).setText(((ConstraintType)((Object)value)).getName());
                ((JLabel)retval).setIcon(((ConstraintType)((Object)value)).getIcon());
            }
            return retval;
        }
    }
}

