/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.SQLQueryEditDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.panels.sql.FunctionComboBox;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class WhereEditor
extends JPanel
implements MouseListener,
TreeSelectionListener,
ActionListener,
FocusListener {
    public static final String AND = WhereObject.WhereOperator.AND.getSQLText();
    public static final String OR = WhereObject.WhereOperator.OR.getSQLText();
    public static final String PRIOR = "PRIOR";
    public static final String LEVEL = "LEVEL";
    private DBUIResourceHelper reshelp;
    private final BaseSQLQueryBuilderPanel m_basePanel;
    private CompletionSupport m_completionSupport;
    private JTextArea m_where = new JTextArea();
    private JScrollPane m_scrollPane = new JScrollPane(this.m_where, 20, 31);
    private DefaultMutableTreeNode m_top = new DefaultMutableTreeNode("WHERE_TEMPS");
    private DefaultTreeModel m_templatesModel = new DefaultTreeModel(this.m_top);
    private JTree m_templates = new JTree(this.m_templatesModel);
    private JLabel m_tempDesc = new JLabel();
    private JButton m_insertTempl = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
    private JButton m_insertFunc = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
    private FunctionComboBox m_functions = new FunctionComboBox();
    private TreeNodeMaker m_nodeMaker = new TreeNodeMaker(false);
    private DBObjectRenderer m_rend = new DBObjectRenderer();
    private String m_cachedWhere;
    private boolean m_includePrior;
    private Collection<String> m_bindVariables;
    private JButton m_and = new JButton();
    private JButton m_or = new JButton();
    private JButton m_pars = new JButton();
    private JButton m_prior = new JButton();
    private JButton m_subQuery = new JButton();
    private transient DBObjectProvider m_pro;

    public WhereEditor(String compPrefix) {
        this(compPrefix, null);
    }

    WhereEditor(String compPrefix, BaseSQLQueryBuilderPanel basePanel) {
        this.m_rend.setIncludeIcon(true);
        this.m_basePanel = basePanel;
        try {
            this.layoutComponents(compPrefix);
        }
        catch (Exception e) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, "layout failed", e);
        }
    }

    private void layoutComponents(String compPrefix) {
        this.reshelp = new DBUIResourceHelper(compPrefix);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.setLayout(new GridBagLayout());
        this.m_where.setEditable(true);
        this.m_where.setLineWrap(true);
        this.m_where.setWrapStyleWord(true);
        this.m_scrollPane.setSize(60, 40);
        this.m_where.setSize(60, 40);
        this.add((Component)this.m_scrollPane, new GridBagConstraints(1, 0, 1, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 15), 0, 0));
        this.reshelp.setName(this.m_scrollPane, "Where");
        this.setTemplatesLabel(UIBundle.get("EXP_PALETTE"));
        this.add((Component)this.m_tempDesc, new GridBagConstraints(2, 0, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ExpressionPanel.setupButton(this.m_insertTempl, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_insertTempl.setMnemonic('c');
        this.m_insertTempl.setEnabled(false);
        ttm.registerComponent(this.m_insertTempl);
        this.reshelp.setName(this.m_insertTempl, "InsertTemplate");
        DBObjectRenderer.setToolTipText(this.m_insertTempl, UIBundle.get("WHERE_TEMPL_TT"));
        this.add((Component)this.m_insertTempl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(Box.createHorizontalStrut(220), new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalStrut(50), new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(this.m_rend);
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        ToolTipManager.sharedInstance().registerComponent(this.m_templates);
        JScrollPane templateSP = new JScrollPane(this.m_templates);
        this.add((Component)templateSP, new GridBagConstraints(3, 1, 5, 2, 0.5, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.reshelp.setName(templateSP, "Templates");
        ExpressionPanel.setupButton(this.m_insertFunc, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_templates.addFocusListener(this);
        this.m_insertFunc.setMnemonic('f');
        ttm.registerComponent(this.m_insertFunc);
        this.reshelp.setName(this.m_insertFunc, "InsertFunction");
        DBObjectRenderer.setToolTipText(this.m_insertFunc, UIBundle.get("WHERE_FUNC_TT"));
        this.add((Component)this.m_insertFunc, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.reshelp.setName(this.m_functions, "Functions");
        this.add((Component)this.m_functions, new GridBagConstraints(3, 3, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.reshelp.resButton(this.m_and, "&" + AND, "And");
        this.m_and.addActionListener(this);
        ttm.registerComponent(this.m_and);
        DBObjectRenderer.setToolTipText(this.m_and, UIBundle.get("WHERE_AND_TT"));
        this.add((Component)this.m_and, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.reshelp.resButton(this.m_or, "&" + OR, "Or");
        this.m_or.addActionListener(this);
        ttm.registerComponent(this.m_or);
        DBObjectRenderer.setToolTipText(this.m_or, UIBundle.get("WHERE_OR_TT"));
        this.add((Component)this.m_or, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pars.setText("(...)");
        this.m_pars.addActionListener(this);
        this.m_pars.setMnemonic('9');
        ttm.registerComponent(this.m_pars);
        this.reshelp.setName(this.m_pars, "Brackets");
        DBObjectRenderer.setToolTipText(this.m_pars, UIBundle.get("WHERE_PARENTH_TT"));
        this.add((Component)this.m_pars, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        ttm.registerComponent(this.m_subQuery);
        DBObjectRenderer.setToolTipText(this.m_subQuery, UIBundle.get("WHERE_ADD_SUBQUERY_TT"));
        this.reshelp.resButton(this.m_subQuery, UIBundle.get("SUBQUERY_BUTTON"), "SubQuery");
        this.m_subQuery.addActionListener(this);
        this.add((Component)this.m_subQuery, new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.reshelp.resButton(this.m_prior, "&PRIOR", "Prior");
        this.m_prior.addActionListener(this);
        ttm.registerComponent(this.m_prior);
        DBObjectRenderer.setToolTipText(this.m_prior, UIBundle.get("WHERE_PRIOR_TT"));
        this.add((Component)this.m_prior, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void setDBObjectProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void setTemplatesLabel(String desc) {
        this.reshelp.resLabel(this.m_tempDesc, this.m_templates, desc, "Templates");
    }

    public void setTemplates(FromObject[] froms, FKUsage[] fks) {
        List fkList;
        int i;
        this.m_top.removeAllChildren();
        HashMap<FromObject, ArrayList<FKUsage>> fkMap = new HashMap<FromObject, ArrayList<FKUsage>>();
        for (i = 0; fks != null && i < fks.length; ++i) {
            FromObject left = fks[i].resolveLeftFromObject();
            fkList = (ArrayList<FKUsage>)fkMap.get(left);
            if (fkList == null) {
                fkList = new ArrayList<FKUsage>();
                fkMap.put(left, (ArrayList<FKUsage>)fkList);
            }
            fkList.add(fks[i]);
        }
        for (i = 0; froms != null && i < froms.length; ++i) {
            if (froms[i] == null || !(froms[i].getExpression() instanceof RelationUsage) && !(froms[i].getExpression() instanceof SynonymUsage) && !(froms[i].getExpression() instanceof SQLQuery)) continue;
            DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode((SQLFragment)froms[i], true);
            this.m_top.add(node);
            if (!fkMap.containsKey(froms[i])) continue;
            fkList = (List)fkMap.get(froms[i]);
            Iterator iter = fkList.iterator();
            while (iter.hasNext()) {
                node.add(this.m_nodeMaker.createTreeNode((SQLFragment)((FKUsage)iter.next())));
            }
        }
        if (this.m_bindVariables != null && this.m_bindVariables.size() > 0) {
            DefaultMutableTreeNode bindVarsNode = new DefaultMutableTreeNode("Bind Variables", true);
            this.m_top.add(bindVarsNode);
            Iterator<String> iter = this.m_bindVariables.iterator();
            while (iter.hasNext()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(iter.next(), false);
                bindVarsNode.add(node);
            }
        }
        this.m_templatesModel.reload();
    }

    public void setFunctions(Collection funcs) {
        this.m_functions.removeAllItems();
        HashSet<String> set = new HashSet<String>();
        for (Object o : funcs) {
            if (!(o instanceof BuiltInFunction)) continue;
            set.add(((BuiltInFunction)o).getSignature(false));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(set);
        Collections.sort(list);
        for (String sig : list) {
            this.m_functions.addItem(sig);
        }
    }

    public void setBindVariables(Collection<String> bindVariables) {
        this.m_bindVariables = bindVariables;
    }

    private void insertCurrentFunction() {
        Object func = this.m_functions.getSelectedItem();
        if (func instanceof SQLFragment) {
            this.addToWhere(((SQLFragment)func).getSQLText());
        } else {
            this.addToWhere(func.toString());
        }
        this.m_where.requestFocus();
    }

    private void insertCurrentTemplate() {
        Object last;
        TreePath p;
        if (this.m_templates != null && (p = this.m_templates.getSelectionPath()) != null && (last = p.getLastPathComponent()) != null && ((DefaultMutableTreeNode)last).isLeaf()) {
            Object obj = ((DefaultMutableTreeNode)last).getUserObject();
            String addText = null;
            if (obj instanceof Column) {
                Object parentObj;
                FastStringBuffer text = new FastStringBuffer();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)last).getParent();
                Object object = parentObj = parent == null ? null : parent.getUserObject();
                if (parentObj != null && parentObj instanceof FromObject) {
                    text.append(((FromObject)parentObj).getName());
                    text.append(".");
                } else {
                    Relation rel = ((Column)obj).getRelation();
                    if (rel != null) {
                        String name = ((Relation)obj).getName();
                        if (this.m_pro != null) {
                            name = this.m_pro.getExternalName(name);
                        }
                        text.append(name).append(".");
                    }
                }
                String name = ((Column)obj).getName();
                if (this.m_pro != null) {
                    name = this.m_pro.getExternalName(name);
                }
                text.append(name);
                addText = text.toString();
            } else if (obj instanceof SQLFragment) {
                addText = ((SQLFragment)obj).getSQLText();
            } else if (obj instanceof DBObject) {
                addText = DBUtil.getFullyQualifiedName((DBObject)((DBObject)obj));
            } else if (obj instanceof String) {
                addText = (String)obj;
            }
            this.addToWhere(addText);
            this.m_where.requestFocus();
        }
    }

    private void addToWhere(String text) {
        BaseSQLQueryBuilderPanel.addText(this.m_where, text);
    }

    public boolean hasTextChanged() {
        String sql = this.m_where.getText();
        if (ModelUtil.hasLength((String)sql)) {
            return ModelUtil.areDifferent((Object)this.m_cachedWhere, (Object)sql);
        }
        return ModelUtil.hasLength((String)this.m_cachedWhere);
    }

    public void init(SQLFragment where, SQLQueryBuilder builder, boolean includePrior) {
        this.m_includePrior = includePrior;
        if (this.m_includePrior) {
            this.m_cachedWhere = null;
            if (where != null) {
                this.m_cachedWhere = (this.hasPrior(where) ? "" : "PRIOR ") + where.getSQLText();
            }
        } else {
            this.m_cachedWhere = where == null ? null : where.getSQLText();
        }
        this.init(builder);
    }

    private boolean hasPrior(SQLFragment f) {
        boolean retval = false;
        if (f instanceof WhereObject) {
            SQLFragment[] arguments;
            for (SQLFragment arg : arguments = ((WhereObject)f).getArguments()) {
                if (!this.hasPrior(arg)) continue;
                retval = true;
                break;
            }
        } else if (f instanceof Comparison) {
            retval = ((Comparison)f).getPriorOnLeft() || ((Comparison)f).getPriorOnRight();
        }
        return retval;
    }

    public void init(WhereObject where, SQLQueryBuilder builder) {
        this.m_cachedWhere = where == null ? null : where.getSQLText();
        this.init(builder);
    }

    private void init(SQLQueryBuilder builder) {
        this.m_where.setText(this.m_cachedWhere);
        if (this.m_includePrior) {
            this.m_prior.setVisible(true);
        } else {
            this.m_prior.setVisible(false);
        }
        if (builder != null) {
            HashSet<Object> objs = new HashSet<Object>();
            FromObject[] froms = builder.listAllFromObjects();
            for (int i = 0; i < froms.length; ++i) {
                objs.add(froms[i]);
            }
            if (this.m_functions.getModel().getSize() == 0) {
                List functions = this.m_pro.getDescriptor().listBuiltInFunctions();
                this.setFunctions(functions);
                objs.addAll(functions);
            }
            objs.add(AND);
            objs.add(OR);
            if (this.m_includePrior) {
                objs.add(PRIOR);
                objs.add(LEVEL);
            }
            objs.add(Comparison.Comparator.LIKE.getSQLText());
            objs.add(Comparison.Comparator.NOT_LIKE.getSQLText());
            objs.add(Comparison.Comparator.NULL.getSQLText());
            objs.add(Comparison.Comparator.NOT_NULL.getSQLText());
            objs.add(SetOperation.Operator.BETWEEN.getSQLText());
            objs.add(SetOperation.Operator.NOT_BETWEEN.getSQLText());
            objs.add(SetOperation.Operator.IN.getSQLText());
            objs.add(SetOperation.Operator.NOT_IN.getSQLText());
            if (this.m_bindVariables != null) {
                objs.addAll(this.m_bindVariables);
            }
            if (this.m_basePanel != null && this.m_completionSupport == null) {
                this.m_completionSupport = this.m_basePanel.getCompletionSupport(this.m_where);
            }
        }
    }

    public Component getDefaultComponent() {
        return this.m_where;
    }

    public String getWhereText() {
        return this.m_where.getText();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path;
        Object source = e.getSource();
        if (e.getClickCount() % 2 == 0 && source == this.m_templates && (path = this.m_templates.getPathForLocation(e.getX(), e.getY())) != null) {
            this.insertCurrentTemplate();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        this.m_templates.scrollPathToVisible(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.m_insertTempl.setEnabled(node.isLeaf());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_and) {
            this.addToWhere(AND);
        } else if (source == this.m_or) {
            this.addToWhere(OR);
        } else if (source == this.m_pars) {
            this.addToWhere("()");
        } else if (source == this.m_prior) {
            this.addToWhere(PRIOR);
        } else if (source == this.m_insertFunc) {
            this.insertCurrentFunction();
        } else if (source == this.m_insertTempl) {
            this.insertCurrentTemplate();
        } else if (source == this.m_subQuery) {
            this.addSubQueryToWhere();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_and.setEnabled(enabled);
        this.m_or.setEnabled(enabled);
        this.m_pars.setEnabled(enabled);
        this.m_prior.setEnabled(enabled);
        this.m_templates.setEnabled(enabled);
        this.m_scrollPane.setEnabled(enabled);
        this.m_where.setEnabled(enabled);
        this.m_subQuery.setEnabled(enabled);
    }

    @Override
    public void focusGained(FocusEvent e) {
        int[] rows;
        if (e.getComponent() == this.m_templates && (rows = this.m_templates.getSelectionRows()) == null) {
            this.m_templates.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void addSubQueryToWhere() {
        try {
            SQLQueryEditDialog editor = new SQLQueryEditDialog();
            editor.setBindVariables(this.m_bindVariables);
            SQLQuery newQuery = editor.editQuery(new SQLQuery(), this.m_pro, this.m_pro.getDefaultSchema());
            if (newQuery != null) {
                this.addToWhere("(" + newQuery.getSQLText() + ")");
            }
        }
        catch (SQLQueryException sqe) {
            DBExceptionDialog.showErrorDialog((Component)this.m_templates, UIBundle.get("FROM_EDIT_QUERY_ERR"), (DBException)((Object)sqe));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }
}

