/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.ide.Ide;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.util.ModelUtil;

public final class QueryTargetPicker
extends ReorderableListPicker {
    public static final String REMOVE_HELP_ID = null;
    private SQLQueryBuilder m_builder;
    private ComponentWithTitlebar m_compTitleBar = null;
    private final PathCache m_cache = new PathCache();
    private final Collection<DBObject> m_newToMe = new IdentitySet();
    private final Collection<FromObject> m_newFroms = new IdentitySet();
    private boolean m_changed;

    public QueryTargetPicker() {
        this(new JList());
    }

    public QueryTargetPicker(JList list) {
        super(list);
        ToolTipManager.sharedInstance().registerComponent(list);
    }

    public void setQueryBuilder(SQLQueryBuilder builder) {
        this.clear();
        this.m_builder = builder;
        this.m_changed = false;
    }

    public SQLQueryBuilder getQueryBuilder() {
        return this.m_builder;
    }

    public synchronized void loadQuery() {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeAllElements();
        this.m_newToMe.clear();
        this.m_newFroms.clear();
        SQLQuery query = this.m_builder.getSQLQuery();
        SelectObject[] s = query.getSelectObjects();
        this.m_cache.prunePaths();
        for (int i = 0; i < s.length; ++i) {
            model.addElement(s[i]);
        }
        this.m_changed = false;
    }

    private FromObject findOrCreateFromPath(List<DBObject> path) {
        FromObject retval = null;
        if (path != null && path.size() > 0 && (retval = this.m_cache.findFrom(path)) == null) {
            ArrayList<DBObject> searchPath = new ArrayList<DBObject>(path);
            try {
                FromObject lastFrom = null;
                for (int i = path.size() - 1; i >= 0; --i) {
                    boolean makeNoMore;
                    DBObject obj = path.get(i);
                    if (obj instanceof Relation || obj instanceof Synonym) {
                        lastFrom = retval = this.findOrCreateFromObject((SchemaObject)obj, searchPath);
                        searchPath.remove(i);
                        continue;
                    }
                    if (!(obj instanceof FKConstraint)) continue;
                    searchPath.remove(i);
                    Relation rel = (Relation)path.get(--i);
                    FromObject f2 = this.m_cache.findFrom(searchPath);
                    boolean bl = makeNoMore = f2 != null;
                    if (!makeNoMore) {
                        f2 = this.findOrCreateFromObject((SchemaObject)rel, searchPath);
                    }
                    searchPath.remove(i);
                    if (lastFrom.getExpression() instanceof JoinObject) {
                        lastFrom = ((JoinObject)lastFrom.getExpression()).getLeftExpression();
                    }
                    this.m_builder.constructFKJoin((FKConstraint)obj, f2, lastFrom);
                    lastFrom = (FromObject)f2.getParent().getParent();
                    if (!makeNoMore) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLQueryException sqe) {
                this.showExceptionDialog(sqe);
            }
        }
        return retval;
    }

    private FromObject findFromObject(DBObject usageOf, DBObjectUsage[] usages) {
        FromObject retval = null;
        for (DBObjectUsage relU : usages) {
            DBObject par;
            if (!ModelUtil.areEqual((Object)relU.getObjectID(), (Object)usageOf.getID()) || !((par = relU.getParent()) instanceof FromObject)) continue;
            if (retval == null) {
                retval = (FromObject)par;
                continue;
            }
            retval = null;
            break;
        }
        return retval;
    }

    private FromObject findOrCreateFromObject(SchemaObject rel, List<DBObject> path) throws SQLQueryException {
        List<DBObject> existingPath;
        FromObject retval = null;
        if (rel instanceof Synonym) {
            Collection us = DBUtil.findChildren((DBObject)this.m_builder.getSQLQuery(), SynonymUsage.class);
            if (us.size() > 0) {
                retval = this.findFromObject((DBObject)rel, (DBObjectUsage[])us.toArray(new SynonymUsage[us.size()]));
            }
        } else if (rel instanceof Relation) {
            retval = this.findFromObject((DBObject)rel, (DBObjectUsage[])this.m_builder.getRelationUsages());
        }
        if (retval != null && (existingPath = this.m_cache.findPath(retval)) != null && !this.m_cache.areEqual(existingPath, path)) {
            retval = null;
        }
        if (retval == null) {
            SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructFromObject(rel, false, false, null);
            retval = (FromObject)set.getObject();
        }
        this.m_cache.cachePath(path, retval);
        this.m_newFroms.add(retval);
        return retval;
    }

    public SelectObject[] getSelectList() {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        SelectObject[] s = new SelectObject[model.getSize()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (SelectObject)model.get(i);
        }
        return s;
    }

    private void showExceptionDialog(SQLQueryException sqe) {
        DBExceptionDialog.showErrorDialog(this.getComponent(), UIBundle.get("PICKER_ERROR_TITLE"), (DBException)((Object)sqe));
    }

    public boolean addSelectedItems(Transferable[] t) {
        for (int i = 0; i < t.length && this.m_builder != null; ++i) {
            if (!(t[i] instanceof DBObjectTransferable)) continue;
            this.m_changed = true;
            DBObject obj = ((DBObjectTransferable)t[i]).getDBObject();
            DBObject[] path = ((DBObjectTransferable)t[i]).getPath();
            if (obj instanceof Synonym) {
                obj = DBUtil.getSynonymReference((Synonym)((Synonym)obj));
            }
            if (!(obj instanceof Relation) && !(obj instanceof Column)) continue;
            ArrayList<DBObject> pathList = new ArrayList<DBObject>(Arrays.asList(path));
            try {
                FromObject from;
                if (obj instanceof Relation) {
                    from = this.findOrCreateFromPath(pathList);
                    if (this.m_builder.getFromObject(from.getName()) != from) {
                        this.m_builder.addFromObject(from);
                        this.m_newFroms.add(from);
                    }
                    Column[] cols = ((Relation)obj).getColumns();
                    SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructSelectObjects(cols, new FromObject[]{from});
                    SelectObject[] s = set.getSelectObjects();
                    for (int j = 0; j < s.length; ++j) {
                        this.addSelectObject(s[j]);
                    }
                    continue;
                }
                if (!(obj instanceof Column)) continue;
                pathList.remove(obj);
                from = this.findOrCreateFromPath(pathList);
                SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructSelectObject((Column)obj, from);
                SelectObject s = (SelectObject)set.getObject();
                this.addSelectObject(s);
                continue;
            }
            catch (SQLQueryException sqe) {
                this.showExceptionDialog(sqe);
            }
        }
        return true;
    }

    private void addSelectObject(SelectObject obj) throws SQLQueryException {
        obj.setID(TemporaryObjectID.createID((DBObject)obj));
        ((DefaultListModel)this.getList().getModel()).addElement(obj);
        this.m_newToMe.add((DBObject)obj);
    }

    protected Transferable createTransferable(Object obj) {
        SQLFragment exp;
        if (obj instanceof SelectObject && (exp = ((SelectObject)obj).getExpression()) instanceof ColumnUsage) {
            DBObjectID id = ((ColumnUsage)exp).getObjectID();
            try {
                return new DBObjectTransferable(id.resolveID());
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        }
        return new DBObjectTransferable(null);
    }

    public void removeAllSelectableItems() {
        this.getList().setSelectionInterval(0, this.getList().getModel().getSize() - 1);
        this.removeSelectedItems();
    }

    public void removeSelectedItems() {
        int i;
        this.m_changed = true;
        ListModel m = this.getList().getModel();
        if (!(m instanceof DefaultListModel)) {
            return;
        }
        boolean remove = true;
        DefaultListModel model = (DefaultListModel)m;
        Object[] objs = this.getList().getSelectedValues();
        for (i = 0; i < objs.length; ++i) {
            if (this.m_newToMe.contains(objs[i])) continue;
            remove = false;
        }
        if (!remove) {
            remove = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIBundle.get("PICKER_CONFIRM_REMOVE"), (String)UIBundle.get("PICKER_CONFIRM_REMOVE_TITLE"), (String)REMOVE_HELP_ID, (boolean)true);
        }
        if (remove) {
            for (i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof SelectObject)) continue;
                this.m_builder.removeSelectObject((SelectObject)objs[i]);
                model.removeElement(objs[i]);
            }
        }
    }

    void clear() {
        super.removeAllSelectableItems();
        this.m_changed = false;
    }

    boolean hasChanged() {
        return this.m_changed;
    }

    void removeNewEmptyFroms() {
        boolean changed = false;
        FromObject[] queryFroms = this.m_builder.getSQLQuery().getFromObjects();
        for (int i = 0; i < queryFroms.length; ++i) {
            if (!this.canRemove(queryFroms[i])) continue;
            this.m_builder.removeFromObject(queryFroms[i]);
            changed = true;
        }
        if (changed) {
            this.m_cache.prunePaths();
        }
    }

    private boolean canRemove(FromObject from) {
        SQLFragment exp = from.getExpression();
        if (exp instanceof JoinObject) {
            FromObject left = ((JoinObject)exp).getLeftExpression();
            if (!this.canRemove(left)) {
                return false;
            }
            FromObject right = ((JoinObject)exp).getRightExpression();
            return this.canRemove(right);
        }
        if (this.m_newFroms.contains(from)) {
            Object[] deps = this.m_builder.getDependentObjects(from);
            return !ModelUtil.hasNonNullElement((Object[])deps);
        }
        return false;
    }

    public Component getComponent() {
        if (this.m_compTitleBar == null) {
            this.m_compTitleBar = new ComponentWithTitlebar();
            this.m_compTitleBar.setComponent((JComponent)super.getComponent());
        }
        return this.m_compTitleBar;
    }

    public void moveSelectionBottom() {
        super.moveSelectionBottom();
        this.m_changed = true;
    }

    public void moveSelectionDown() {
        super.moveSelectionDown();
        this.m_changed = true;
    }

    public void moveSelectionTop() {
        super.moveSelectionTop();
        this.m_changed = true;
    }

    public void moveSelectionUp() {
        super.moveSelectionUp();
        this.m_changed = true;
    }

    public void processDnDReorder() {
        super.processDnDReorder();
        this.m_changed = true;
    }

    private class PathCache {
        private final List<List<DBObject>> m_pathKeys = new ArrayList<List<DBObject>>();
        private final List<FromObject> m_pathValues = new ArrayList<FromObject>();

        private PathCache() {
        }

        public void cachePath(List<DBObject> path, FromObject from) {
            this.m_pathKeys.add(new ArrayList<DBObject>(path));
            this.m_pathValues.add(from);
        }

        public void prunePaths() {
            if (this.m_pathKeys.size() > 0) {
                FromObject[] froms = QueryTargetPicker.this.m_builder.listAllFromObjects();
                IdentitySet fromObjs = new IdentitySet();
                for (FromObject from : froms) {
                    fromObjs.add(from);
                }
                for (int i = this.m_pathKeys.size() - 1; i >= 0; --i) {
                    FromObject from = this.m_pathValues.get(i);
                    if (fromObjs.contains(from)) continue;
                    this.m_pathKeys.remove(i);
                    this.m_pathValues.remove(i);
                }
            }
        }

        public FromObject findFrom(List<DBObject> path) {
            FromObject retval = null;
            for (int i = 0; i < this.m_pathKeys.size(); ++i) {
                if (!this.areEqual(path, this.m_pathKeys.get(i))) continue;
                retval = this.m_pathValues.get(i);
                break;
            }
            return retval;
        }

        public List<DBObject> findPath(FromObject from) {
            List<DBObject> retval = null;
            for (int i = 0; i < this.m_pathValues.size(); ++i) {
                if (from != this.m_pathValues.get(i)) continue;
                retval = this.m_pathKeys.get(i);
                break;
            }
            return retval;
        }

        public boolean areEqual(List<DBObject> path1, List<DBObject> path2) {
            boolean retval = false;
            if (path1.size() == path2.size()) {
                retval = true;
                for (int i = 0; i < path1.size(); ++i) {
                    DBObject obj2;
                    DBObject obj1 = path1.get(i);
                    if (obj1 == (obj2 = path2.get(i))) continue;
                    retval = false;
                    break;
                }
            }
            return retval;
        }
    }
}

