/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ideimpl.db.panels.sql.ExpressionPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class GroupByPanel
extends BaseSQLQueryBuilderPanel
implements ExpressionPanel.FragmentProvider,
DocumentListener,
ActionListener {
    private boolean m_init;
    private SQLQueryBuilder m_builder;
    private CompletionSupport m_completionSupport;
    private JWrappedLabel m_desc = new JWrappedLabel(UIBundle.get("GROUPBY_DESC"));
    private ExpressionPanel m_expPanel;
    private JPanel m_editor;
    private JTextField m_expression = new JTextField();
    private JLabel m_expLabel = new JLabel();
    private JButton m_validate = new JButton();
    private boolean m_commitPending;
    private SQLFragment m_current;
    private boolean m_new;

    @Override
    protected String getLayoutOnlyMessage(SQLQuery query, SQLQueryBuilder builder) {
        String retval = super.getLayoutOnlyMessage(query, builder);
        if (retval == null) {
            if (query.getSetOperator() != null) {
                retval = UIBundle.get("GROUPBY_AND_SET_CANT_SET");
            } else if (!builder.canSetGroupBy()) {
                retval = UIBundle.get("GROUPBY_CANT_SET");
            }
        }
        return retval;
    }

    @Override
    protected void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.m_desc, "North");
        this.m_expPanel = new ExpressionPanel(this);
        this.add(this.m_expPanel, "Center");
    }

    @Override
    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.m_builder = builder;
        List funcs = this.getProvider().getDescriptor().listBuiltInFunctions();
        if (this.m_expPanel != null) {
            GroupByObject groupBy;
            if (!this.m_init) {
                this.m_expPanel.setDBObjectProvider(this.getProvider());
                this.m_expPanel.addFunctions(funcs);
                this.m_init = true;
            }
            this.m_expPanel.clearTemplates();
            HashSet<Object> objs = new HashSet<Object>();
            FromObject[] froms = this.m_builder.listAllFromObjects();
            for (int i = 0; i < froms.length; ++i) {
                this.m_expPanel.addTemplate((SQLFragment)froms[i], true);
                objs.add(froms[i]);
            }
            objs.addAll(Arrays.asList(funcs));
            if (this.m_completionSupport == null) {
                this.m_completionSupport = this.getCompletionSupport(this.m_expression);
            }
            this.m_expPanel.entered((groupBy = this.m_builder.getSQLQuery().getGroupByObject()) == null ? null : groupBy.getExpressions(), null);
        }
    }

    @Override
    public void commitPanel() throws TraversalException {
        boolean commitPending = this.m_commitPending;
        if (this.m_expPanel != null) {
            this.m_expPanel.exited();
        }
        if (commitPending && this.m_builder != null && this.m_builder.canSetGroupBy()) {
            SQLFragment[] colus = this.m_expPanel.getExpressions();
            if (colus != null && colus.length > 0) {
                GroupByObject existing = this.m_builder.getSQLQuery().getGroupByObject();
                this.m_builder.setGroupByObject(new GroupByObject(colus, existing == null ? null : existing.getHaving()));
            } else {
                this.m_builder.setGroupByObject(null);
            }
        }
    }

    private SQLFragment newSQLFragment() {
        SimpleSQLFragment result = new SimpleSQLFragment();
        result.setID(TemporaryObjectID.createID((DBObject)result));
        return result;
    }

    private void updateCurrentFrag() throws SQLQueryException {
        SQLFragment existingExp = null;
        if (this.m_current != null) {
            existingExp = this.m_expPanel.getCurrentExpression();
        }
        try {
            String expression = this.m_expression.getText().trim();
            if (this.m_current != null) {
                SQLFragment exp = this.m_builder.parseSelectExpression(expression);
                if (this.m_new) {
                    this.m_current = exp;
                    this.m_builder.addGroupByColumn(this.m_current);
                    this.m_new = false;
                } else {
                    this.m_current = exp;
                    this.m_builder.removeGroupByColumn(existingExp);
                    this.m_builder.addGroupByColumn(exp);
                }
                this.m_expPanel.setCurrentExpression(this.m_current);
            }
        }
        catch (SQLQueryException sqe) {
            if (this.m_new) {
                this.m_current = existingExp;
            }
            throw sqe;
        }
    }

    private void enableComponents(boolean en) {
        this.m_expLabel.setEnabled(en);
        this.m_expression.setEnabled(en);
        this.m_validate.setEnabled(en);
        if (!en) {
            this.m_expression.setText(null);
            this.m_commitPending = false;
        }
    }

    @Override
    public String getComponentNamePrefix() {
        return "GroupByPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            this.m_editor.setName(this.getComponentNamePrefix());
            int y = 0;
            DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
            reshelp.resLabel(this.m_expLabel, this.m_expression, UIBundle.get("EXP_EXPRESSION"), "Expression");
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            ToolTipManager.sharedInstance().registerComponent(this.m_expression);
            this.m_expression.getDocument().addDocumentListener(this);
            this.m_editor.add((Component)this.m_expression, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            reshelp.resButton(this.m_validate, UIBundle.get("EXP_VALIDATE"), "Validate");
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_editor.add((Component)Box.createVerticalBox(), new GridBagConstraints(1, y++, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    @Override
    public String getEditorName() {
        return UIBundle.get("GROUPBY_EDITOR");
    }

    @Override
    public String getListTitle() {
        return UIBundle.get("GROUPBY_LIST_TITLE");
    }

    @Override
    public String getTemplateTitle() {
        return UIBundle.get("EXP_PALETTE");
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = this.newSQLFragment();
        this.edit(this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment frag) {
        boolean retval = false;
        if (this.m_new) {
            this.m_new = false;
            retval = true;
        } else {
            retval = this.m_builder.removeGroupByColumn(frag);
        }
        return retval;
    }

    @Override
    public void moveFragment(SQLFragment frag, int newIndex) {
        this.m_builder.getSQLQuery().getGroupByObject().moveExpression(frag, newIndex);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment exp = this.m_expPanel.getCurrentExpression();
            String existing = exp == null ? null : exp.getSQLText();
            String expression = this.m_expression.getText().trim();
            if (ModelUtil.areDifferent((Object)expression, (Object)existing)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException e) {
                    throw new TraversalException(e.getMessage());
                }
            }
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment frag) {
        this.m_current = frag;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            this.m_expression.setText(frag == null ? "" : frag.getSQLText());
            this.m_expression.requestFocusInWindow();
            this.m_expression.selectAll();
            this.m_commitPending = false;
        }
    }

    @Override
    public void addToExpression(String text) {
        GroupByPanel.addText(this.m_expression, text);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.updateCurrentFrag();
            DBObjectRenderer.setToolTipText(this.m_expression, null);
            this.m_expPanel.repaint();
        }
        catch (SQLQueryException sqe) {
            String message = sqe.getMessage();
            this.m_expPanel.showInvalidExpressionDialog(new TraversalException(message));
            DBObjectRenderer.setToolTipText(this.m_expression, message);
        }
    }
}

