/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.insight.completion.DBCompletionSupportFactory;
import oracle.ide.db.insight.model.DBInsightContext;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class BaseSQLQueryBuilderPanel
extends BaseEditorPanel<SQLQueryOwner> {
    private boolean m_declarativeLayoutDone;

    protected BaseSQLQueryBuilderPanel() {
    }

    protected abstract void layoutComponents();

    @Override
    public final void initialisePanel() {
        SQLQueryBuilder builder;
        Namespace namespace = this.getDataContext();
        DBEditorConfig config = (DBEditorConfig)namespace.get(DBEditorConfig.class);
        SQLQuery query = this.requiresDeclarativeQuery() ? BaseSQLQueryBuilderPanel.findAndBuildQuery(config) : BaseSQLQueryBuilderPanel.findQuery(config);
        String messageOnly = this.getLayoutOnlyMessage(query, builder = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query, (DBObjectProvider)this.getProvider(), (Schema)config.getSchema()));
        if (messageOnly != null) {
            BaseSQLQueryBuilderPanel.layoutMessageOnly((JPanel)((Object)this), messageOnly);
            this.m_declarativeLayoutDone = false;
        } else {
            if (!this.m_declarativeLayoutDone) {
                this.layoutComponents();
                this.m_declarativeLayoutDone = true;
            }
            SQLFragment child = this.getInitialSelection(SQLFragment.class);
            this.init(builder, (DBObject)child);
        }
        this.validate();
    }

    protected String getLayoutOnlyMessage(SQLQuery query, SQLQueryBuilder builder) {
        String retval = null;
        if (this.requiresDeclarativeQuery() && (builder == null || !query.isDeclarative())) {
            retval = UIBundle.get("QUERY_DECL_FAIL");
        }
        return retval;
    }

    protected boolean requiresDeclarativeQuery() {
        return true;
    }

    protected abstract void init(SQLQueryBuilder var1, DBObject var2);

    protected SQLQuery findQuery() {
        return BaseSQLQueryBuilderPanel.findQuery(this.getEditorConfig());
    }

    @Override
    protected void validateObject() throws TraversalException {
    }

    protected CompletionSupport getCompletionSupport(JTextComponent comp) {
        Namespace namespace = this.getDataContext();
        DBEditorConfig config = (DBEditorConfig)namespace.get(DBEditorConfig.class);
        SQLQuery query = this.requiresDeclarativeQuery() ? BaseSQLQueryBuilderPanel.findAndBuildQuery(config) : BaseSQLQueryBuilderPanel.findQuery(config);
        DBInsightContext ctx = new DBInsightContext();
        ctx.setProvider(this.getProvider());
        ctx.setContextObject((DBObject)query);
        Context ideContext = (Context)namespace.getRoot().get(Context.class);
        if (ideContext == null) {
            ideContext = Context.newIdeContext();
        }
        return DBCompletionSupportFactory.getCompletionSupport(ctx, ideContext, comp);
    }

    protected static void addText(JTextComponent comp, String text) {
        int insertPoint;
        if (comp.getSelectedText() == null) {
            insertPoint = comp.getCaretPosition();
            if (insertPoint > 0) {
                try {
                    String ch = comp.getText(insertPoint - 1, 1);
                    if (!(" ".equals(ch) || "(".equals(ch) || "\n".equals(ch))) {
                        text = " " + text;
                    }
                }
                catch (BadLocationException ch) {}
            }
        } else {
            insertPoint = comp.getSelectionStart();
        }
        comp.replaceSelection(text);
        int newCurs = text.contains("(") ? insertPoint + text.indexOf("(") + 1 : insertPoint + text.length();
        comp.setCaretPosition(newCurs);
    }

    protected static SQLQuery findAndBuildQuery(DBEditorConfig config) {
        SQLQuery query = BaseSQLQueryBuilderPanel.findQuery(config);
        SchemaObjectBuilder pbar = new SchemaObjectBuilder(true);
        pbar.buildDerivedProperties(config.getProvider());
        try {
            pbar.ensureDerivedPropertiesBuiltEx((DBObject)query);
        }
        catch (DBException dbe) {
            DBLog.getLogger(BaseSQLQueryBuilderPanel.class).fine(dbe.getMessage());
        }
        return query;
    }

    protected static SQLQuery findQuery(DBEditorConfig config) {
        SystemObject newObject = config.getUpdatedObject();
        if (newObject == null) {
            newObject = config.getChildObject();
        }
        SQLQuery query = null;
        if (newObject instanceof SQLQuery) {
            query = (SQLQuery)newObject;
        } else if (newObject instanceof SQLQueryOwner) {
            query = ((SQLQueryOwner)newObject).getSQLQuery();
        }
        return query;
    }

    static void layoutMessageOnly(JPanel panel, String text) {
        panel.removeAll();
        panel.setLayout(new BorderLayout());
        JTextPane message = new JTextPane();
        message.setText(text);
        message.getAccessibleContext().setAccessibleName(text);
        message.getAccessibleContext().setAccessibleDescription("");
        message.setEditable(false);
        message.setOpaque(false);
        message.setEnabled(true);
        message.setBorder(BorderFactory.createEmptyBorder());
        panel.add((Component)message, "Center");
    }
}

