/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBox;
import oracle.ideimpl.db.panels.partition.HashPartitionComboBoxListener;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.panels.partition.PartitionDetailsPanel;
import oracle.ideimpl.db.panels.partition.PartitionProperty;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.util.ModelUtil;

class PartitionTreeDetailsPanel
extends PartitionDetailsPanel {
    private final JCheckBox m_check = new JCheckBox();
    private final PropertyChangeListener m_pcl;
    private final HashPartitionComboBox m_combo;
    private final HashPartitionComboBoxListener m_listener;

    PartitionTreeDetailsPanel(ActionListener checkBoxListener, PropertyChangeListener propertyListener) {
        super(PartitionProperty.PARTITIONS);
        this.m_check.addActionListener(checkBoxListener);
        this.m_pcl = propertyListener;
        DBUIResourceHelper rh = new DBUIResourceHelper(this.getName());
        this.m_combo = new HashPartitionComboBox(rh, "HashPartitionType");
        this.m_listener = new HashPartitionComboBoxListenerImpl();
    }

    @Override
    protected void initialiseChildComponents() {
        this.getComponentFactory().getResourceHelper().resButton(this.m_check, UIBundle.get("PART_SUBPART_TEMPLATE"), "SubPartitionTemplateCheck");
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add(this.m_check, 2, 1, true, false);
        layout.nextRowWithGap();
        this.initialiseChildComponentsImpl(layout);
        this.initialiseSpecificChildComponents(layout);
        layout.pushUp();
        layout.layout();
        if (this.m_pcl != null) {
            ComponentWrapper nameWrapper = this.getComponentFactory().findComponentWrapper("name");
            nameWrapper.addListener(this.m_pcl);
            ComponentWrapper valuesWrapper = this.getComponentFactory().findComponentWrapper("values");
            valuesWrapper.addListener(this.m_pcl);
        }
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        TablePartition tp = (TablePartition)this.getChildObject();
        OracleTablePartitions.PartitionType tpPartType = tp == null ? null : tp.getPartitionType();
        OracleTablePartitions.ObjectType tpObjType = tp == null ? null : tp.getObjectType();
        PropertyHelper propHelper = this.getPropertyHelper();
        Object updObject = this.getUpdatedObject();
        this.enableWrappers();
        if (tp != null && tpPartType == OracleTablePartitions.PartitionType.REFERENCE) {
            this.showHashComponentsImpl(null);
            this.m_check.setVisible(false);
        } else {
            OracleTablePartitions main;
            OracleTablePartitions subpartsModel;
            Object[] subpartitions = (TablePartition[])propHelper.getPropertyValue(updObject, PartitionProperty.SUBPARTITIONS_FOR_TABLE);
            boolean hasSubPartitionTemplate = ModelUtil.hasNonNullElement((Object[])subpartitions);
            if (!hasSubPartitionTemplate) {
                Integer quantity = (Integer)propHelper.getPropertyValue(updObject, PartitionProperty.SUBPARTITION_TEMPLATE_HASH_QUANTITY);
                hasSubPartitionTemplate = quantity != null;
            }
            OracleTablePartitions subpartitioning = (OracleTablePartitions)propHelper.getPropertyValue(updObject, PartitionProperty.SUBPARTITIONING_FOR_TABLE);
            boolean isSubPartitionTemplateRelevant = tp != null && tpObjType == OracleTablePartitions.ObjectType.PARTITION && tpPartType != OracleTablePartitions.PartitionType.REFERENCE && subpartitioning != null;
            boolean usesSubPartitionTemplate = false;
            if (isSubPartitionTemplateRelevant && hasSubPartitionTemplate) {
                OracleTablePartitions subs = tp.getPartitionLevelSubpartitions();
                TablePartition[] subparts = subs == null ? null : subs.getPartitions();
                boolean bl = usesSubPartitionTemplate = subs == null || subparts == null || subparts.length == 0;
                if (usesSubPartitionTemplate && subs != null && subs.getPartitionType() == OracleTablePartitions.PartitionType.HASH && subs.getHashQuantity() != null) {
                    usesSubPartitionTemplate = false;
                }
            }
            this.m_check.setVisible(isSubPartitionTemplateRelevant);
            this.m_check.setEnabled(hasSubPartitionTemplate);
            this.m_check.setSelected(!usesSubPartitionTemplate);
            HashPartitionComboBox.Item item = null;
            if (tp != null && tpObjType == OracleTablePartitions.ObjectType.PARTITION && !usesSubPartitionTemplate && (subpartsModel = (main = (OracleTablePartitions)tp.getParent()).getSubpartitionModel()) != null && subpartsModel.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                item = HashPartitionComboBox.Item.Default;
                OracleTablePartitions subs = tp.getPartitionLevelSubpartitions();
                if (subs == null) {
                    subs = subpartsModel;
                }
                TablePartition[] subparts = subs.getPartitions();
                if (subs.getHashQuantity() != null) {
                    item = HashPartitionComboBox.Item.Quantity;
                } else if (subparts != null && subparts.length > 0) {
                    item = HashPartitionComboBox.Item.Individual;
                }
            }
            this.showHashComponentsImpl(item);
            JComboBox combo = this.m_combo.getComboBox();
            combo.removeActionListener(this.m_listener);
            combo.setSelectedItem((Object)item);
            combo.addActionListener(this.m_listener);
        }
    }

    private TablePartition enableWrappers() {
        TablePartition tp = (TablePartition)this.getChildObject();
        OracleTablePartitions otp = (OracleTablePartitions)((Table)this.getUpdatedObject()).getProperty("OracleTablePartitions");
        boolean enable = true;
        enable = otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE ? tp != null && tp.getParent() != null : tp == null || tp.getObjectType() != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE;
        this.enableWrapper("name", enable);
        this.enableValuesWrapper(enable);
        this.enableWrapper(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}), enable);
        this.enableWrapper("OracleInMemoryProperties", enable);
        this.enableWrapper("segmentAttributes", enable);
        this.enableLobWrapper(enable);
        return tp;
    }

    private void enableWrapper(String propName, boolean enable) {
        ComponentWrapper wrap = this.getComponentFactory().findComponentWrapper(propName);
        if (wrap != null) {
            wrap.setEnabled(enable);
        }
    }

    private void initialiseSpecificChildComponents(DBUILayoutHelper layout) {
        layout.add(this.m_combo.getLabel(), 1, 1, false, false);
        layout.add(this.m_combo.getComboBox(), 2, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwHashQuantity = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_HASH_QUANTITY);
        layout.add(cwHashQuantity.getLabel(), 1, 1, false, false);
        layout.add(cwHashQuantity.getComponent(), 2, 1, true, false);
        layout.nextRow();
        ComponentWrapper cwTablespaces = this.getOrCreateWrapper(PartitionProperty.SUBPARTITION_HASH_TABLESPACES);
        layout.add(cwTablespaces.getLabel(), 1, 1, false, false);
        layout.add(cwTablespaces.getComponent(), 2, 1, true, false);
        layout.nextRow();
    }

    @Override
    protected void refreshComponents() {
        TablePartition tp = (TablePartition)this.getChildObject();
        String childPropertyPath = PartitionProperty.PARTITIONS;
        if (tp != null && tp.getObjectType() == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
            childPropertyPath = PartitionProperty.SUBPARTITIONS_FOR_TABLE;
        }
        this.getComponentFactory().setBasePath(childPropertyPath);
        super.refreshComponents();
    }

    private void showHashComponentsImpl(HashPartitionComboBox.Item item) {
        ComponentWrapper cwTablespaces;
        this.m_combo.setVisible(item != null);
        boolean visible = item == HashPartitionComboBox.Item.Quantity;
        ComponentWrapper cwHashQuantity = this.getComponentFactory().findComponentWrapper(PartitionProperty.SUBPARTITION_HASH_QUANTITY);
        if (cwHashQuantity != null) {
            cwHashQuantity.setVisible(visible);
        }
        if ((cwTablespaces = this.getComponentFactory().findComponentWrapper(PartitionProperty.SUBPARTITION_HASH_TABLESPACES)) != null) {
            cwTablespaces.setVisible(visible);
        }
    }

    private final class HashPartitionComboBoxListenerImpl
    extends HashPartitionComboBoxListener {
        private HashPartitionComboBoxListenerImpl() {
        }

        @Override
        final OraclePartitionsHandler getPartitionsHandler() {
            TablePartition tp = (TablePartition)PartitionTreeDetailsPanel.this.getChildObject();
            OracleTablePartitions otp = tp.getPartitionLevelSubpartitions();
            return otp == null ? null : OraclePartitionsHandler.create((DBObject)otp);
        }

        @Override
        final void actionPerformedImpl(ActionEvent e) {
            HashPartitionComboBox.Item item = PartitionTreeDetailsPanel.this.m_combo.getSelectedItem();
            PartitionTreeDetailsPanel.this.showHashComponentsImpl(item);
            TablePartition tp = (TablePartition)PartitionTreeDetailsPanel.this.getChildObject();
            if (item == null || item == HashPartitionComboBox.Item.Default) {
                tp.setPartitionLevelSubpartitions(null);
            } else {
                OracleTablePartitions otp = tp.getPartitionLevelSubpartitions();
                if (otp == null) {
                    otp = new OracleTablePartitions();
                    tp.setPartitionLevelSubpartitions(otp);
                }
                otp.setPartitionType(OracleTablePartitions.PartitionType.HASH);
                otp.setObjectType(OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION);
            }
        }
    }
}

