/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import oracle.ide.controls.FlatEditorTransparentPanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.MutExChildObjectEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.Pair;

public abstract class MutExChildObjectEditorControlPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private final List<String> m_panelTitles = new ArrayList<String>();
    private final Map<String, MutExChildObjectEditorPanel<C, P>> m_panelMap = new HashMap<String, MutExChildObjectEditorPanel<C, P>>();
    private final JComboBox m_chooser = new JComboBox();
    private final ActionListener m_chooserListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MutExChildObjectEditorControlPanel.this.switchPanels(true);
        }
    };
    private JPanel m_container = new JPanel(new GridBagLayout());
    private final GridBagConstraints m_containerGBC = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
    private MutExChildObjectEditorPanel<C, P> m_currentPanel;

    protected MutExChildObjectEditorControlPanel(String propPath) {
        this(null, propPath);
    }

    protected MutExChildObjectEditorControlPanel(String name, String propPath) {
        super(name, propPath);
    }

    @Override
    protected final void initialiseChildComponents() {
        String none = this.getTitleForNullOption();
        if (none != null) {
            this.addPanel(new BlankPanel(), none);
        }
        for (Pair<MutExChildObjectEditorPanel<C, P>, String> pair : this.getPanelsAndTitles()) {
            this.addPanel((MutExChildObjectEditorPanel)((Object)pair.getFirst()), (String)pair.getSecond());
        }
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        JPanel identityPanel = new JPanel();
        this.creatIdentityPanel(identityPanel);
        if (!this.isInFlatEditor()) {
            JScrollPane scrollPane = new JScrollPane(identityPanel, 20, 31);
            scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            layout.add(scrollPane);
        } else {
            layout.add(identityPanel, 1, 1, true, true);
        }
        layout.layout();
    }

    protected abstract String getLabelForChooser();

    protected String getTitleForNullOption() {
        return UIBundle.get("MUTEX_CHILD_OPTION_NONE");
    }

    protected List<Pair<MutExChildObjectEditorPanel<C, P>, String>> getPanelsAndTitles() {
        return Collections.emptyList();
    }

    private void addPanel(MutExChildObjectEditorPanel<C, P> panel, String title) {
        if (this.m_panelTitles.contains(title)) {
            throw new IllegalStateException("Panel with title " + title + " already added");
        }
        this.m_panelTitles.add(title);
        this.m_panelMap.put(title, panel);
    }

    private void switchPanels(boolean uiAction) {
        MutExChildObjectEditorPanel<C, P> newPanel = this.m_panelMap.get(this.m_chooser.getSelectedItem());
        if (newPanel != this.m_currentPanel) {
            if (this.m_currentPanel != null) {
                try {
                    this.m_currentPanel.onExit((TraversableContext)this.getDataContext());
                }
                catch (TraversalException traversalException) {
                    // empty catch block
                }
                if (uiAction) {
                    this.m_currentPanel.clearProperty(this.getChildObject());
                }
                this.m_container.remove((Component)((Object)this.m_currentPanel));
            }
            this.m_currentPanel = newPanel;
            this.m_container.add((Component)((Object)this.m_currentPanel), this.m_containerGBC);
            if (uiAction) {
                this.m_currentPanel.initialiseProperty(this.getChildObject(), this.getEditorConfig());
            }
        }
        if (this.m_currentPanel != null) {
            this.m_currentPanel.onEntry((TraversableContext)this.getDataContext());
        }
        this.m_container.revalidate();
        this.m_container.repaint();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.m_chooser.removeActionListener(this.m_chooserListener);
        this.m_chooser.removeAllItems();
        Object child = this.getChildObject();
        boolean currentPanelFound = false;
        boolean anyPanels = false;
        if (child != null) {
            for (String title : this.m_panelTitles) {
                boolean currentPanel;
                MutExChildObjectEditorPanel panel = this.m_panelMap.get(title);
                boolean bl = currentPanel = !currentPanelFound && panel.accept(child);
                if (!currentPanel && !this.isValidPanel(panel, child, this.getEditorConfig())) continue;
                this.m_chooser.addItem(title);
                if (currentPanel) {
                    this.m_chooser.setSelectedItem(title);
                    currentPanelFound = true;
                }
                anyPanels = true;
            }
        }
        if (anyPanels) {
            if (!currentPanelFound) {
                this.m_chooser.setSelectedIndex(0);
            }
            this.switchPanels(false);
        }
        this.m_chooser.addActionListener(this.m_chooserListener);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.m_currentPanel != null) {
            this.m_currentPanel.commitPanel();
        }
    }

    private boolean isValidPanel(MutExChildObjectEditorPanel<C, P> panel, C child, DBEditorConfig config) {
        boolean retval = true;
        String validationPropName = panel.getChildValidationProperty();
        if (validationPropName != null) {
            ChildDBObject copy = (ChildDBObject)child.copyTo(null, true);
            for (String title : this.m_panelTitles) {
                this.m_panelMap.get(title).clearProperty(copy);
            }
            panel.initialiseProperty(copy, config);
            try {
                config.getProvider().validateObjectProperty((DBObject)copy, validationPropName);
            }
            catch (ValidationException e) {
                retval = false;
            }
        }
        return retval;
    }

    private void creatIdentityPanel(JPanel identityPanel) {
        DBUILayoutHelper layout = new DBUILayoutHelper(identityPanel, this.isInFlatEditor());
        JLabel label = new JLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)this.m_chooser, (String)this.getLabelForChooser());
        layout.add(label);
        layout.add(this.m_chooser);
        layout.nextRow();
        layout.add(this.m_container, 2, 1, true, true);
        layout.nextRow();
        layout.layout();
    }

    private class BlankPanel
    extends MutExChildObjectEditorPanel<C, P> {
        BlankPanel() {
            super(null, null);
        }

        @Override
        public String getChildValidationProperty() {
            return null;
        }

        @Override
        public void initialiseProperty(C child, DBEditorConfig config) {
        }

        @Override
        public void clearProperty(C child) {
        }

        @Override
        public boolean accept(C child) {
            return false;
        }

        @Override
        protected void initialiseChildComponents() {
            if (this.getEditorConfig().isInFlatEditor()) {
                FlatEditorTransparentPanel.makeTransparent((JComponent)((Object)this));
            }
        }
    }
}

