/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.ora.PlSqlPanelLibrary;
import oracle.ideimpl.db.panels.xmlschema.XMLSchemaInfoPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.util.ModelUtil;

public class XMLSchemaPanelLibrary
extends PlSqlPanelLibrary {
    public XMLSchemaPanelLibrary() {
        super("XML SCHEMA");
    }

    @Override
    protected List<String> getTitles(DBObject obj, DBObjectProvider pro, boolean editing) {
        return editing ? null : Collections.emptyList();
    }

    @Override
    protected String getHeaderHelpID() {
        return "f1_odbxmlschema_html";
    }

    @Override
    public Class<? extends Traversable> getHeader() {
        return XMLSchemaInfoPanel.class;
    }

    @Override
    protected String getBufferText(DBObjectProvider pro, SchemaObject obj) {
        String text = ((XMLSchema)obj).getSource();
        if (!ModelUtil.hasLength((String)text)) {
            text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           xmlns:xdb=\"http://xmlns.oracle.com/xdb\"\n           version=\"1.0\">\n</xs:schema>";
        }
        return text;
    }

    @Override
    public boolean showEditorAfterCommit() {
        return true;
    }

    @Override
    public Dimension getSize(boolean edit) {
        return OracleDBEditorFactory.NO_PANELS_DIALOG_SIZE;
    }

    @Override
    protected String initialiseSource(DBEditorConfig config) {
        SchemaObject obj = (SchemaObject)config.getUpdatedObject();
        String text = this.getBufferText(config.getProvider(), obj);
        if (obj instanceof XMLSchema) {
            ((XMLSchema)obj).setSource(text);
        }
        return text;
    }

    @Override
    protected String getSource(SystemObject obj) {
        if (obj instanceof XMLSchema) {
            return ((XMLSchema)obj).getSource();
        }
        return null;
    }
}

