/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.db.DBURLFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.plsql.PlSqlComparator;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

abstract class PlSqlPanelLibrary
extends PanelLibrary {
    protected PlSqlPanelLibrary(String type) {
        super(type);
    }

    @Override
    protected Class<? extends Traversable> getDDLPanel() {
        return null;
    }

    protected List<String> getTitles(DBObject obj, DBObjectProvider pro, boolean editing) {
        return Collections.emptyList();
    }

    protected void ensureNameIsInSource(PlSqlSourceObject newObject, DBObjectProvider pro) throws CancelledException {
        PlSqlUtil.TypeAndNameInfo info;
        String oldInternalName;
        String newInternalName = newObject.getName();
        if (!newInternalName.equals(oldInternalName = pro.getInternalName((info = PlSqlUtil.getTypeAndNameFromSource((PlSqlSourceObject)newObject, (DatabaseDescriptor)pro.getDescriptor())).getName()))) {
            StringBuilder sb = new StringBuilder(newObject.getSource());
            PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)newObject, (DBObjectProvider)pro);
            if (parser != null) {
                PlSqlToken endMinus1 = null;
                PlSqlToken endMinus2 = null;
                PlSqlToken endTk = parser.getTokenAtOffset(parser.getEndOffsetOfObject());
                if (endTk != null && endTk.matches(";") && (endMinus1 = (PlSqlToken)endTk.getPrevCodeToken()).matches(oldInternalName)) {
                    endMinus2 = (PlSqlToken)endMinus1.getPrevCodeToken();
                }
                if (endMinus2 != null && endMinus2.matches("END")) {
                    sb.replace(endMinus1.getStart(), endMinus1.getEnd() + 1, this.adjustCase(newInternalName));
                }
                sb.replace(info.getNameStart(), info.getNameEnd() + 1, this.adjustCase(newInternalName));
                newObject.setSource(sb.toString());
            }
        }
    }

    private String adjustCase(String str) {
        if (str != null && GlobalSettings.getInstance().isNewPlSqlLowerCase() && !str.startsWith("\"") && !str.startsWith("'")) {
            return str.toLowerCase();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitSource(DBEditorConfig config) throws DBException {
        final SchemaObject obj = (SchemaObject)config.getUpdatedObject();
        SchemaObject origObj = (SchemaObject)config.getOriginalObject();
        final DBObjectProvider pro = config.getProvider();
        URL url = this.getNodeURL(obj, pro);
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            throw new DBException(null, "Error finding pl/sql node.", (Throwable)e);
        }
        String text = this.initialiseSource(config);
        if (node instanceof TextNode) {
            final TextNode cbn = (TextNode)node;
            cbn.addNodeListener(new NodeListener(){
                final Schema schema;
                final String name;
                final String dbType;
                {
                    this.schema = obj.getSchema();
                    this.name = obj.getName();
                    this.dbType = obj.getType();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nodeSaved(NodeEvent e) {
                    try {
                        SchemaObject obj2 = pro.getObject(this.dbType, this.schema, this.name);
                        if (obj2 != null && pro instanceof AbstractDatabase) {
                            ((AbstractDatabase)pro).fireObjectsAdded(this.schema, new SchemaObject[]{obj2});
                        }
                    }
                    catch (DBException ex) {
                        String title = UIBundle.get("PLSQL_PANEL_ERR");
                        Throwable cause = ex.getCause();
                        if (cause instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog(null, title, (SQLException)cause);
                        } else {
                            DBExceptionDialog.showErrorDialog(null, title, ex);
                        }
                    }
                    finally {
                        cbn.removeNodeListener((NodeListener)this);
                    }
                }

                public void nodeClosed(NodeEvent e) {
                    cbn.removeNodeListener((NodeListener)this);
                }
            });
            if (pro instanceof Database) {
                SourceObject so;
                String updSource;
                String origSource = this.getSource((SystemObject)origObj);
                if (ModelUtil.areDifferent((Object)origSource, (Object)(updSource = this.getSource((SystemObject)obj)))) {
                    TextBuffer buf = null;
                    boolean makeReadOnly = false;
                    try {
                        buf = cbn.acquireTextBuffer();
                        if (buf.isReadOnly()) {
                            buf.setReadOnly(false);
                            makeReadOnly = true;
                        }
                        buf.beginEdit();
                        buf.removeToEnd(0);
                        if (text != null) {
                            buf.append(text.toCharArray());
                        }
                    }
                    finally {
                        if (buf != null) {
                            buf.endEdit();
                            if (makeReadOnly) {
                                buf.setReadOnly(true);
                            }
                            cbn.releaseTextBuffer();
                        }
                    }
                }
                if (node instanceof BaseDBObjectTextNode && (so = ((BaseDBObjectTextNode)node).getDBObjectFromBuffer()).getClass() == obj.getClass()) {
                    PropertyHelper ph = new PropertyHelper(pro);
                    for (Map.Entry e : obj.getProperties().entrySet()) {
                        String prop = (String)e.getKey();
                        PropertyInfo pi = PropertyHelper.findPropertyInfo(so.getClass(), (String)prop, (DBObjectProvider)pro);
                        if ("source".equals(prop) || pi == null || pi.isDerived()) continue;
                        so.setProperty(prop, e.getValue());
                    }
                }
            }
        }
    }

    protected String initialiseSource(DBEditorConfig config) throws CancelledException {
        SchemaObject obj = (SchemaObject)config.getUpdatedObject();
        SchemaObject origObj = (SchemaObject)config.getOriginalObject();
        boolean create = origObj == null;
        DBObjectProvider pro = config.getProvider();
        String text = this.getBufferText(pro, obj);
        if (obj instanceof PlSqlSourceObject) {
            PlSqlSourceObject sourceObj = (PlSqlSourceObject)obj;
            if (!create) {
                if (sourceObj instanceof Trigger) {
                    Trigger trig = (Trigger)sourceObj;
                    Trigger orig = (Trigger)origObj;
                    trig.setSource(text);
                } else {
                    PlSqlComparator comp = new PlSqlComparator(false, true);
                    PlSqlSourceObject orig = (PlSqlSourceObject)origObj;
                    if (comp.compare(orig.getSource(), sourceObj.getSource()) == 0) {
                        sourceObj.setSource(orig.getSource());
                    }
                    this.ensureNameIsInSource(sourceObj, pro);
                }
            } else {
                sourceObj.setSource(text);
                this.ensureNameIsInSource(sourceObj, pro);
            }
            if (TemplateExpander.isPendingObject((DBObject)sourceObj)) {
                text = sourceObj.getSource();
                PlSqlToken firstTk = PlSqlTokenizer.tokenize((String)text, (String[])new String[0]);
                if (!firstTk.isCode()) {
                    firstTk = (PlSqlToken)firstTk.getNextCodeToken();
                }
                if (firstTk != null && firstTk.isCode() && !firstTk.matches("CREATE")) {
                    text = "CREATE OR REPLACE\n" + text;
                }
            }
        }
        return text;
    }

    protected String getSource(SystemObject obj) {
        if (obj instanceof PlSqlSourceObject) {
            return ((PlSqlSourceObject)obj).getSource();
        }
        return null;
    }

    @Override
    public void commitToProvider(DBEditorConfig config) {
        SystemObject newObject;
        DBObjectProvider pro = config.getProvider();
        URL url = DBURLFactory.getURL(pro, newObject = config.getUpdatedObject());
        if (url != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                Context context = Context.newIdeContext((Node)node);
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                editorManager.openEditor(openEditorOptions);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error finding object node.", e);
            }
        }
        try {
            this.commitSource(config);
            config.setResult(DBEditorConfig.Result.SUCCESS);
            if (!(config.getProvider() instanceof Database)) {
                super.commitToProvider(config);
            }
        }
        catch (DBException dbe) {
            config.setException(dbe);
            config.setResult(DBEditorConfig.Result.ERROR);
        }
    }

    protected String getBufferText(DBObjectProvider pro, SchemaObject obj) throws CancelledException {
        boolean edit = false;
        if (obj.getID() instanceof TemporaryObjectID) {
            TemporaryObjectID tid = (TemporaryObjectID)obj.getID();
            try {
                if (tid != null && tid.resolveOriginalID() != null) {
                    edit = true;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (edit) {
            String ret = ((PlSqlSourceObject)obj).getSource();
            PlSqlUtil.rebuildSource((DBObjectProvider)pro, (PlSqlSourceObject)((PlSqlSourceObject)obj));
            ret = ((PlSqlSourceObject)obj).getSource();
            return ret;
        }
        return PlSqlUtil.getDefaultSource((DBObjectProvider)pro, (PlSqlSourceObject)((PlSqlSourceObject)obj));
    }

    protected URL getNodeURL(SchemaObject obj, DBObjectProvider pro) {
        return DBURLFactory.getURL(pro, (SystemObject)obj);
    }

    @Override
    public boolean showEditorAfterCommit() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> getNamesToExclude(DBObjectProvider pro, DBObject contextObject) {
        HashSet<String> excludes = new HashSet<String>();
        if (contextObject instanceof Schema) {
            String contextSchema = ((Schema)contextObject).getName();
            for (Editor ed : EditorManager.getEditorManager().getAllEditors()) {
                CodeEditor ce;
                Context ctx;
                Node node;
                if (!(ed instanceof CodeEditor) || !((node = (ctx = CodeEditor.getContext((BasicEditorPane)(ce = (CodeEditor)ed).getFocusedEditorPane())).getNode()) instanceof DBObjectPlSqlNode) || !node.isDirty()) continue;
                DBObjectPlSqlNode plsNode = (DBObjectPlSqlNode)node;
                String schema = plsNode.getSchemaName();
                if (!plsNode.getProvider().equals(pro) || !contextSchema.equals(schema)) continue;
                String source = null;
                TextBuffer textBuffer = plsNode.acquireTextBuffer();
                if (textBuffer != null) {
                    try {
                        source = new String(textBuffer.getChars(0, textBuffer.getLength()));
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to get pl/sql source.", e);
                    }
                    finally {
                        plsNode.releaseTextBuffer();
                    }
                }
                if (source != null) {
                    excludes.add(PlSqlUtil.getNameFromSource(source));
                }
                excludes.add(plsNode.getObjectName());
            }
        }
        return excludes;
    }

    public boolean canEditObject(DBObject obj, DBObjectProvider pro) {
        boolean ok = super.canEditObject(obj, pro);
        if (ok && pro instanceof Database) {
            URL origUrl = this.getNodeURL((SchemaObject)obj, pro);
            Node origNode = null;
            try {
                origNode = NodeFactory.findOrCreate((URL)origUrl);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error finding pl/sql node.", e);
            }
            if (origNode != null && origNode.isDirty()) {
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public boolean shouldValidateOnExit(BaseEditorPanel panel, Namespace dataContext) {
        DBObjectProvider pro;
        boolean ret = super.shouldValidateOnExit(panel, dataContext);
        DBEditorConfig config = (DBEditorConfig)dataContext.find(DBEditorConfig.class);
        DBObjectProvider dBObjectProvider = pro = config == null ? null : config.getProvider();
        if (ret && config != null && pro instanceof Database && config.isEdit()) {
            try {
                pro.validateObject((DBObject)config.getOriginalObject(), (DBObject)config.getUpdatedObject());
                ret = false;
            }
            catch (ValidationException ve) {
                ret = true;
            }
        }
        return ret;
    }
}

