/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.panels.mviewlog.MViewLogHeader;
import oracle.ideimpl.db.panels.mviewlog.MaterializedViewLogPanel;
import oracle.ideimpl.db.panels.table.StoragePanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.MaterializedViewLog;

public class MaterializedViewLogPanelLibrary
extends PanelLibrary {
    public MaterializedViewLogPanelLibrary() {
        super("MATERIALIZED VIEW LOG");
        this.addPanel(UIBundle.get("PROPERTIES"), MaterializedViewLogPanel.class, "f1_dbmvlog_html", "cache", "columnIDs", "newValues", "parallelDegree", "primaryKeyLogged", "rowidLogged", "sequenceLogged");
        this.addPanel(UIBundle.get("STORAGE_INFO_TITLE"), StoragePanel.class, "f1_odbtastoropts_html", "OracleStorageProperties");
    }

    protected List<String> getTitles(DBObject obj, DBObjectProvider pro, boolean editing) {
        ArrayList<String> t = new ArrayList<String>();
        t.add(UIBundle.get("PROPERTIES"));
        t.add(UIBundle.get("STORAGE_INFO_TITLE"));
        return t;
    }

    @Override
    protected String getGeneralHelpID() {
        return "f1_dbmvlog_html";
    }

    @Override
    protected String getHeaderHelpID() {
        return "f1_odbmvlog_html";
    }

    @Override
    public Class<? extends Traversable> getHeader() {
        return MViewLogHeader.class;
    }

    public boolean canEditObject(DBObject obj, DBObjectProvider pro) {
        return true;
    }

    @Override
    protected void prepareObjectForNavigable(DBEditorConfig config, Navigable nav) throws DBException {
        MaterializedViewLog mviewlog;
        DBObjectID tabID;
        super.prepareObjectForNavigable(config, nav);
        if (UIBundle.get("PROPERTIES").equals(nav.getShortLabel()) && (tabID = (mviewlog = (MaterializedViewLog)config.getUpdatedObject()).getMasterTableID()) != null) {
            try {
                DBObject tab = tabID.resolveID();
                if (tab instanceof Relation) {
                    DBUtil.ensureObjectBuilt((DBObject)tab, (String[])new String[]{"columns", "constraints"});
                }
            }
            catch (CancelledException ce) {
                throw ce;
            }
            catch (DBException dbe) {
                this.getLogger().warning(dbe.getMessage());
            }
        }
    }
}

