/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.editors;

import java.awt.Component;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.editor.Editor;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.editors.DBObjectOverviewEditorPanel;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.ui.Header;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public class DBObjectOverviewEditor
extends Editor {
    private static final String CURRENT_PAGE_KEY = "db-current-page";
    private final DBObjectListener m_proList = new ReenterListener();
    private final DBObjectListener m_newObjList = new CommitListener();
    private boolean m_updateInProgress;
    private Holder<Boolean> m_commitImmediately;
    private boolean m_reenterInProgress;
    private boolean m_entered;
    private boolean m_shown;
    private boolean m_listening;
    private PanelLibrary m_panelLib;
    private Traversable m_panel;
    private BaseEditorPanel m_lastTraversable;
    private Namespace m_ns = new Namespace();
    private DBObjectNode m_node;
    private IOException m_openError;
    private DBEditorConfig m_editorConfig;

    public final DBEditorConfig getEditorConfig() {
        return this.m_editorConfig;
    }

    protected final PanelLibrary getPanelLibrary() {
        return this.m_panelLib;
    }

    protected final Namespace getDataContext() {
        return this.m_ns;
    }

    public Object getEditorAttribute(String attribute) {
        if ("background_color".equals(attribute)) {
            return UIManager.getColor("window");
        }
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(attribute)) {
            return 31;
        }
        if ("vertical_scrollbar_policy".equals(attribute)) {
            return 21;
        }
        return super.getEditorAttribute(attribute);
    }

    public Component getGUI() {
        if (this.m_panelLib == null || ModelUtil.areDifferent((Object)this.m_panelLib.getType(), (Object)this.m_node.getObjectType())) {
            this.m_panelLib = DBEditorFactoryRegistry.getEditFactory(this.m_node).getPanelLibrary(this.m_node.getProvider(), this.m_node.getObjectType());
        }
        if (this.m_panelLib != null && this.m_editorConfig != null && this.m_panel == null) {
            this.m_panel = this.createPanel();
            if (this.m_shown) {
                this.enterPanel();
            }
        }
        return this.m_panel == null ? this.getErrorGUI() : this.m_panel.getComponent();
    }

    public HelpInfo getHelpInfo() {
        HelpInfo help = null;
        if (this.m_panel != null) {
            String helpId = this.m_panel.getHelpID();
            if (helpId != null) {
                help = new HelpInfo(helpId);
            }
        } else {
            help = super.getHelpInfo();
        }
        return help;
    }

    private Component getErrorGUI() {
        JPanel panel = new JPanel();
        if (this.m_node != null) {
            DBUILayoutHelper layout = new DBUILayoutHelper(panel);
            Header pageHeader = new Header();
            pageHeader.setText(UIBundle.format("CANNOT_OPEN_EDITOR", this.m_node.getObjectName()));
            layout.add((Component)pageHeader, 1, 1, false, false);
            layout.pushLeft();
            IOException openErr = this.m_openError;
            if (openErr != null) {
                layout.nextRow();
                layout.add(new JLabel(openErr.getMessage()));
            }
            layout.pushUp();
            layout.layout();
        }
        return panel;
    }

    protected Traversable createPanel() {
        return new DBObjectOverviewEditorPanel(this.m_panelLib, this.m_ns);
    }

    public void open() {
        Context context = this.getContext();
        Node node = context.getNode();
        this.m_editorConfig = null;
        this.m_ns = null;
        this.m_openError = null;
        if (node instanceof DBObjectNode) {
            this.m_node = (DBObjectNode)node;
            try {
                node.open();
            }
            catch (IOException ioe) {
                this.m_openError = ioe;
            }
            if (this.m_node.getDBObject() == null) {
                this.m_panel = null;
                String msg = UIBundle.format("CANNOT_OPEN_EDITOR", this.m_node.getObjectName());
                if (this.m_openError != null) {
                    msg = msg + ": " + this.m_openError.getMessage();
                }
                throw new OpenAbortedException(msg);
            }
            DBEditorConfig editorConfig = DBEditorConfig.getConfig(context);
            if (editorConfig == null) {
                editorConfig = DBEditorConfig.newEditConfig(this.m_node);
            }
            this.changeEditorConfig(editorConfig);
        }
    }

    public void changeEditorConfig(DBEditorConfig config) {
        if (this.m_panel != null) {
            this.exitPanel();
        }
        this.m_editorConfig = config;
        BaseDBEditorFactory.setEditorType(this.m_editorConfig, DBEditorFactory.EditorType.EDIT_FLAT);
        BaseDBEditorFactory factory = (BaseDBEditorFactory)DBEditorFactoryRegistry.getEditFactory(this.m_node);
        PanelLibrary lib = factory.getPanelLibrary(this.m_node.getProvider(), this.m_node.getObjectType());
        if (this.m_ns == null) {
            this.m_ns = factory.createNamespace(this.m_editorConfig);
        } else {
            this.m_ns.put(DBEditorConfig.class.getName(), (Object)this.m_editorConfig);
        }
        this.m_ns.put(Context.class.getName(), (Object)this.getContext());
        this.m_ns.put(PanelLibrary.class.getName(), (Object)lib);
        if (this.m_panel != null) {
            if (this.m_panel instanceof DBObjectOverviewEditorPanel) {
                ((DBObjectOverviewEditorPanel)this.m_panel).resetCurrentPage();
            }
            this.enterPanel();
        }
    }

    public void saveSettings(StructuredPropertyAccess element) {
        Navigable currentPage;
        super.saveSettings(element);
        if (this.m_panel instanceof DBObjectOverviewEditorPanel && (currentPage = ((DBObjectOverviewEditorPanel)this.m_panel).getCurrentNavigable()) != null) {
            element.setProperty(CURRENT_PAGE_KEY, currentPage.getShortLabel());
            if (this.m_lastTraversable != null) {
                this.m_lastTraversable.saveSettings((PropertyAccess)element);
            }
        }
    }

    public void loadSettings(StructuredPropertyAccess element) {
        super.loadSettings(element);
        String pageName = element.getProperty(CURRENT_PAGE_KEY, null);
        if (ModelUtil.hasLength((String)pageName)) {
            this.m_editorConfig.setStartPage(pageName);
            this.m_ns.put(PropertyAccess.class.getName(), (Object)element);
        }
    }

    public void close() {
        this.exitPanel();
        super.close();
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public void deactivate() {
        super.deactivate();
        this.commitCurrentWrapper();
    }

    public void activate() {
        super.activate();
    }

    public void editorShown() {
        super.editorShown();
        if (!this.m_shown) {
            this.m_shown = true;
            this.reenter();
        }
    }

    public void editorHidden() {
        super.editorHidden();
        if (this.m_shown) {
            this.exitPanel();
            this.m_shown = false;
        }
    }

    public void prepareForSaving(boolean isClosing) {
        super.prepareForSaving(isClosing);
        if (isClosing) {
            this.commitCurrentWrapper();
        }
    }

    public Controller getController() {
        return new Controller(){

            public boolean handleEvent(IdeAction action, Context context) {
                DBObjectOverviewEditor.this.commitCurrentWrapper();
                return DBObjectOverviewEditor.super.getController().handleEvent(action, context);
            }

            public boolean update(IdeAction action, Context context) {
                return DBObjectOverviewEditor.super.getController().update(action, context);
            }
        };
    }

    protected void attachListeners() {
        if (!this.m_listening) {
            this.m_listening = true;
            this.m_editorConfig.getUpdatedObject().addObjectListener(this.m_newObjList);
            this.m_editorConfig.getProvider().addObjectListener(this.m_proList, this.m_editorConfig.getOriginalObject());
        }
    }

    protected void detachListeners() {
        if (this.m_listening) {
            this.m_editorConfig.getUpdatedObject().removeObjectListener(this.m_newObjList);
            this.m_editorConfig.getProvider().removeObjectListener(this.m_proList);
            this.m_listening = false;
        }
    }

    private void enterPanel() {
        if (this.m_panel != null && !this.m_entered) {
            this.prepareForEnter();
            this.m_entered = true;
            this.m_panel.onEntry(new TraversableContext(this.m_ns, 0));
            this.attachListeners();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commitCurrentWrapper() {
        if (this.m_ns == null) return;
        if (this.m_commitImmediately == null) {
            Holder commitHolder;
            this.m_commitImmediately = commitHolder = new Holder((Object)false);
            try {
                AsynchronousComponentWrapper.commitCurrentWrapper(this.m_ns, false, false);
                if (!((Boolean)commitHolder.get()).booleanValue()) return;
                this.commitToProvider();
                return;
            }
            finally {
                this.m_commitImmediately = null;
            }
        } else {
            DBLog.getLogger((Object)((Object)this)).fine("commitCurrentWrapper already in progress");
        }
    }

    private void exitPanel() {
        if (this.m_panel != null && this.m_entered) {
            try {
                this.m_lastTraversable = (BaseEditorPanel)((Object)this.m_ns.find(BaseEditorPanel.class));
                this.m_panel.onExit(new TraversableContext(this.m_ns, 0));
                this.m_entered = false;
            }
            catch (TraversalException te) {
                DBLog.getLogger((Object)((Object)this)).severe(te.getMessage());
            }
        }
        this.detachListeners();
    }

    private void reenter() {
        if (this.m_panel != null && !this.isUpdateInProcess()) {
            this.m_reenterInProgress = true;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DBObjectOverviewEditor.this.m_reenterInProgress = false;
                    try {
                        DBObjectOverviewEditor.this.exitPanel();
                        DBObjectOverviewEditor.this.m_editorConfig.getOriginalObject().copyTo((DBObject)DBObjectOverviewEditor.this.m_editorConfig.getUpdatedObject(), true);
                        DBObjectOverviewEditor.this.enterPanel();
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Error re-entering panel", e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public final boolean isUpdateInProcess() {
        return this.m_updateInProgress || this.m_reenterInProgress;
    }

    protected void processCommit(DBObjectChange change) {
        Holder<Boolean> commitImmediately = this.m_commitImmediately;
        if (commitImmediately != null) {
            commitImmediately.set((Object)true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBObjectOverviewEditor.this.commitToProvider();
                }
            });
        }
    }

    protected void prepareForEnter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitToProvider() {
        boolean reenter = false;
        this.m_updateInProgress = true;
        try {
            DBEditorConfig config = this.m_editorConfig;
            if (config != null) {
                ProviderOperator op = new ProviderOperator(config.getProvider(), this.getContext());
                if (op.updateObjects(config)) {
                    DBEditorFactory factory = DBEditorFactoryRegistry.getEditFactory(this.m_node);
                    if (factory instanceof BaseDBEditorFactory) {
                        ((BaseDBEditorFactory)factory).commitPerformed(config, this.m_panelLib);
                    }
                } else {
                    reenter = true;
                }
            }
        }
        finally {
            this.m_updateInProgress = false;
        }
        if (reenter || this.reenterAfterCommmit()) {
            this.reenter();
        }
    }

    protected boolean reenterAfterCommmit() {
        return false;
    }

    public Component getDefaultFocusComponent() {
        BaseEditorPanel currentPanel = this.getBaseEditorPanel();
        Component retval = null;
        if (currentPanel != null) {
            retval = currentPanel.getDefaultFocusComponent();
        }
        if (retval == null) {
            retval = super.getDefaultFocusComponent();
        }
        return retval;
    }

    protected BaseEditorPanel getBaseEditorPanel() {
        return this.m_ns == null ? null : (BaseEditorPanel)((Object)this.m_ns.get(BaseEditorPanel.class));
    }

    private class ReenterListener
    extends DBObjectListener {
        private ReenterListener() {
        }

        public void objectUpdated(DBObjectChange change) {
            DBObjectOverviewEditor.this.reenter();
        }
    }

    private class CommitListener
    extends DBObjectListener {
        private CommitListener() {
        }

        public void objectUpdated(DBObjectChange change) {
            if (!DBObjectOverviewEditor.this.m_updateInProgress) {
                DBObjectOverviewEditor.this.m_updateInProgress = true;
                DBObjectOverviewEditor.this.processCommit(change);
            }
        }
    }
}

