/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.dialogs.MessageDialog;

public class DBMessageDialog {
    public static boolean useDialog() {
        return Ide.isRunning() && !IdeUtil.isHeadless() && Ide.getMainWindow() != null;
    }

    public static void showErrorDialog(String message, Object loggerContext, Level logLevel) {
        DBMessageDialog.showErrorDialog(message, loggerContext, logLevel, null, null);
    }

    public static void showErrorDialog(String message, Object loggerContext, Level logLevel, String title, String helpID) {
        if (DBMessageDialog.useDialog()) {
            MessageDialog.error((Component)DBMessageDialog.getDialogParent(), (Object)message, (String)title, (String)helpID);
        } else if (logLevel != null) {
            DBLog.getLogger((Object)loggerContext).log(logLevel, message);
        }
    }

    public static void showErrorDialog(Exception e, Object loggerContext, Level logLevel) {
        DBMessageDialog.showErrorDialog(e, loggerContext, logLevel, null, null, null);
    }

    public static void showErrorDialog(Exception e, Object loggerContext, Level logLevel, String message, String title, String helpID) {
        if (DBMessageDialog.useDialog()) {
            if (e instanceof DBException) {
                DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), title, message, (DBException)((Object)e), helpID);
            } else {
                Throwable cause = e.getCause();
                if (cause instanceof DBException) {
                    DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), title, message, (DBException)cause, helpID);
                } else {
                    String msg = e.getMessage();
                    if (message != null) {
                        msg = message + " : " + msg;
                    }
                    if (msg == null) {
                        msg = msg + "";
                    }
                    DBMessageDialog.showErrorDialog(msg, loggerContext, logLevel, title, helpID);
                }
            }
        } else if (logLevel != null) {
            DBLog.getLogger((Object)loggerContext).log(logLevel, message, e);
        }
    }

    public static Component getDialogParent() {
        Window retval = null;
        if (DBMessageDialog.useDialog() && (retval = IdeUtil.findActiveModalWindow()) == null) {
            retval = Ide.getMainWindow();
        }
        return retval;
    }
}

