/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.ideimpl.db.controls.BigDataAccessParamsTable;
import oracle.ideimpl.db.controls.BigDataFieldsTable;
import oracle.ideimpl.db.controls.BigDataJsonEntriesTable;
import oracle.ideimpl.db.controls.BigDataTablePropertiesTable;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.TableCellEditorWithPopup;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataFields;
import oracle.javatools.db.ora.bigdata.BigDataJsonArray;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.ora.bigdata.BigDataJsonObject;
import oracle.javatools.db.ora.bigdata.BigDataTableProperties;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ExtendedTextField;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

class BigDataValueCellEditor
extends AbstractCellEditor
implements ExtendedTable.ExtendedTableCellEditor {
    private static final String BASE_NAME = "BigDataValueCellEditor";
    private final BigDataAccessParamsTable m_paramsTable;
    private final DBObjectProvider m_provider;
    private final Relation m_relation;
    private String m_parameterName;
    private TableCellEditor m_delegate;
    private ValueCellEditor m_defaultEd;
    private Map<String, TableCellEditor> m_delegates = new HashMap<String, TableCellEditor>();
    private final ExtendedTable.ExtendedTableModelListener m_childTableListener;

    BigDataValueCellEditor(BigDataAccessParamsTable table, DBObjectProvider provider, Relation relation) {
        this.m_paramsTable = table;
        this.m_provider = provider;
        this.m_relation = relation;
        this.m_childTableListener = new ExtendedTable.ExtendedTableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                BigDataValueCellEditor.this.m_paramsTable.fireCellEditedEvent();
            }

            @Override
            public void cellValueEdited(TableModelEvent e) {
                BigDataValueCellEditor.this.m_paramsTable.fireCellEditedEvent();
            }
        };
    }

    private TableCellEditor getDelegate() {
        TableCellEditor retval = this.m_delegates.get(this.m_parameterName);
        if (retval == null) {
            if (BigDataJsonEntry.getJsonEntryNames((String)this.m_parameterName) != null) {
                retval = new JsonCellEditor();
            } else if (BigDataAccessParameterMetadata.isLocationParameter((String)this.m_parameterName)) {
                retval = new LoggingCellEditor();
            } else if ("com.oracle.bigdata.fields".equals(this.m_parameterName)) {
                retval = new FieldsCellEditor();
            } else if ("com.oracle.bigdata.tblproperties".equals(this.m_parameterName)) {
                retval = new TablePropertiesCellEditor();
            } else if (BigDataAccessParameterMetadata.hasAllowedParameterValues((String)this.m_parameterName, (Relation)this.m_relation, (DBObjectProvider)this.m_provider)) {
                retval = new AllowedValuesCellEditor();
            }
            if (retval != null) {
                this.m_delegates.put(this.m_parameterName, retval);
            }
        }
        if (retval == null) {
            if (this.m_defaultEd == null) {
                this.m_defaultEd = new ValueCellEditor();
            }
            retval = this.m_defaultEd;
        }
        return retval;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.m_delegate != null) {
            this.m_delegate.stopCellEditing();
        }
        boolean retval = super.stopCellEditing();
        this.m_delegate = null;
        return retval;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.m_parameterName = (String)table.getValueAt(row, 0);
        this.m_delegate = this.getDelegate();
        return this.m_delegate.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public void prepareComponent(Component component) {
        if (this.m_delegate instanceof ExtendedTable.ExtendedTableCellEditor) {
            ((ExtendedTable.ExtendedTableCellEditor)this.m_delegate).prepareComponent(component);
        }
    }

    @Override
    public Object getCellEditorValue() {
        Object retval = null;
        if (this.m_delegate != null) {
            retval = this.m_delegate.getCellEditorValue();
        }
        return retval;
    }

    private class TablePropertiesCellEditor
    extends PopupTableCellEditor<BigDataTablePropertiesTable> {
        private TablePropertiesCellEditor() {
        }

        @Override
        protected BigDataTablePropertiesTable createTable(BigDataAccessParameter param) throws DBException {
            DBUtil.ensureObjectBuilt((DBObject)param, (String[])new String[]{"parameterValueFragment"});
            BigDataTableProperties frag = (BigDataTableProperties)param.getParameterValueFragment();
            BigDataTablePropertiesTable retval = new BigDataTablePropertiesTable();
            retval.setTableProperties(frag);
            return retval;
        }

        @Override
        protected String getText(BigDataTablePropertiesTable table) {
            BigDataTableProperties props = table.getTableProperties();
            return props == null ? null : props.getSQLText();
        }
    }

    private class FieldsCellEditor
    extends PopupTableCellEditor<BigDataFieldsTable> {
        private FieldsCellEditor() {
        }

        @Override
        protected BigDataFieldsTable createTable(BigDataAccessParameter param) throws DBException {
            DBUtil.ensureObjectBuilt((DBObject)param, (String[])new String[]{"parameterValueFragment"});
            BigDataFields frag = (BigDataFields)param.getParameterValueFragment();
            BigDataFieldsTable retval = new BigDataFieldsTable();
            retval.setFields(frag);
            return retval;
        }

        @Override
        protected String getText(BigDataFieldsTable table) {
            return table.getFields().getSQLText();
        }
    }

    private class AllowedValuesCombo
    extends AbstractLazyCombo {
        private AllowedValuesCombo() {
        }

        @Override
        protected List getModelEntries() {
            return BigDataAccessParameterMetadata.getAllowedParameterValues((String)BigDataValueCellEditor.this.m_parameterName, (Relation)BigDataValueCellEditor.this.m_relation, (DBObjectProvider)BigDataValueCellEditor.this.m_provider);
        }
    }

    private class AllowedValuesCellEditor
    extends DefaultCellEditor
    implements ExtendedTable.ExtendedTableCellEditor {
        AllowedValuesCellEditor() {
            super(new AllowedValuesCombo());
            JComboBox combo = (JComboBox)this.getComponent();
            combo.setEditable(true);
            combo.setName("BigDataValueCellEditor.AllowedValuesCombo");
            this.getEditorComponent().setName(combo.getName() + "-editor");
            combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AllowedValuesCellEditor.this.selectFirstQuotedString();
                }
            });
        }

        private JTextComponent getEditorComponent() {
            JComboBox combo = (JComboBox)this.getComponent();
            return (JTextComponent)combo.getEditor().getEditorComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return ((JComboBox)this.getComponent()).getEditor().getItem();
        }

        @Override
        public void prepareComponent(Component component) {
            final JTextComponent ed = this.getEditorComponent();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ed.isVisible()) {
                        AllowedValuesCellEditor.this.selectFirstQuotedString();
                    }
                }
            });
        }

        private void selectFirstQuotedString() {
            JTextComponent ed = this.getEditorComponent();
            int QUOT = 39;
            String text = ed.getText();
            int opening = text.indexOf(39);
            if (opening >= 0) {
                int closing;
                boolean found = false;
                int i = closing = opening + 1;
                while (closing < text.length()) {
                    if (text.charAt(closing) == '\'') {
                        if (closing < text.length() - 1 && text.charAt(closing + 1) == '\'') {
                            ++closing;
                        } else {
                            found = true;
                            break;
                        }
                    }
                    ++closing;
                }
                if (found) {
                    ed.select(opening + 1, closing);
                }
            }
        }
    }

    private class LoggingCellEditor
    extends ValueCellEditor {
        private final JPanel m_panel;
        private final JLabel m_dirLabel;
        private final DBObjectChooser m_dirChooser;
        private final JLabel m_fileLabel;
        private final JTextField m_fileField;

        LoggingCellEditor() {
            this.m_dirLabel = new JLabel();
            this.m_dirChooser = new DBObjectChooser("DIRECTORY");
            this.m_fileLabel = new JLabel();
            this.m_fileField = new JTextField();
            this.m_dirChooser.setProvider(BigDataValueCellEditor.this.m_provider);
            this.m_dirChooser.setEditable(true);
            Schema sys = new Schema("SYS");
            this.m_dirChooser.setContextDBObjectID(TemporaryObjectID.createID((DBObject)sys));
            this.m_dirChooser.setOnlyReferenceIDNeeded(true);
            this.m_panel = new JPanel();
            DBUIResourceHelper reshelp = this.getResourceHelper();
            reshelp.resLabel(this.m_dirLabel, this.m_dirChooser, DBTypeDisplayRegistry.getSingularDisplayName("DIRECTORY") + ":", "Directory");
            reshelp.resLabel(this.m_fileLabel, this.m_fileField, UIBundle.get("EXTTAB_FILE_NAME_TEMP"), "FileName");
        }

        @Override
        protected boolean supportsPopup(JTable table, Object value, int row, int column) {
            return true;
        }

        @Override
        protected void initPopup(JPanel popupPanel) {
            String value = this.getEditor().getText();
            ReferenceID dirID = null;
            String fileName = null;
            if (value != null) {
                String[] bits = value.split(":", 2);
                if (bits.length == 1) {
                    fileName = bits[0];
                } else {
                    dirID = new ReferenceID("DIRECTORY", "SYS", BigDataValueCellEditor.this.m_provider.getInternalName(bits[0]));
                    fileName = bits[1];
                }
            }
            this.m_dirChooser.setDBObjectID((DBObjectID)dirID);
            if (ModelUtil.hasLength(fileName) && this.isQuoted(fileName)) {
                fileName = fileName.substring(1, fileName.length() - 1);
                fileName = fileName.replace("''", "'");
            }
            this.m_fileField.setText(fileName);
            popupPanel.removeAll();
            DBUILayoutHelper layout = new DBUILayoutHelper(popupPanel);
            layout.setMargins(8);
            layout.add(this.m_dirLabel);
            layout.add(this.m_dirChooser);
            layout.nextRow();
            layout.add(this.m_fileLabel);
            layout.add(this.m_fileField);
            layout.layout();
        }

        private boolean isQuoted(String str) {
            int quot = 39;
            int length = str.length();
            return length > 1 && str.charAt(0) == '\'' && str.charAt(length - 1) == '\'';
        }

        @Override
        protected Integer getPreferredPopupHeight() {
            return null;
        }

        @Override
        protected void commitPopup() {
            String retval;
            String dirName = DBUtil.getDBObjectName((DBObjectID)this.m_dirChooser.getDBObjectID());
            this.m_dirChooser.cancel();
            String fileName = this.m_fileField.getText();
            if (ModelUtil.hasLength((String)fileName) && !this.isQuoted(fileName)) {
                fileName = "'" + fileName.replace("'", "''") + "'";
            }
            if (ModelUtil.hasLength((String)dirName)) {
                retval = BigDataValueCellEditor.this.m_provider.getExternalName(dirName, "DIRECTORY") + ":";
                if (fileName != null) {
                    retval = retval + fileName;
                }
            } else {
                retval = fileName;
            }
            this.getEditor().setText(retval);
        }
    }

    private class JsonCellEditor
    extends PopupTableCellEditor<BigDataJsonEntriesTable> {
        private JsonCellEditor() {
        }

        @Override
        protected BigDataJsonEntriesTable createTable(BigDataAccessParameter param) throws DBException {
            Tuple jsonEntryNames = BigDataJsonEntry.getJsonEntryNames((String)BigDataValueCellEditor.this.m_parameterName);
            String errorMessage = null;
            SQLFragment frag = null;
            try {
                DBUtil.ensureObjectBuilt((DBObject)param, (String[])new String[]{"parameterValueFragment"});
                frag = param.getParameterValueFragment();
            }
            catch (DBException dbe) {
                BigDataAccessParameterMetadata.TemplateValue template = BigDataAccessParameterMetadata.getParameterTemplateValue((String)BigDataValueCellEditor.this.m_parameterName);
                if (template != null && ModelUtil.areEqual((Object)template.toString(), (Object)param.getParameterValue())) {
                    BigDataJsonObject obj = new BigDataJsonObject();
                    obj.addBigDataEntry(new BigDataJsonEntry((String)jsonEntryNames.object1(), null));
                    frag = obj;
                }
                DBLog.getLogger((Object)this).fine(dbe.getMessage());
                errorMessage = dbe.getMessage();
            }
            if (errorMessage == null) {
                if (!(frag instanceof BigDataJsonArray)) {
                    BigDataJsonArray arr = new BigDataJsonArray();
                    if (frag != null) {
                        arr.addArgument(frag);
                    }
                    frag = arr;
                }
                try {
                    BigDataJsonEntriesTable table = new BigDataJsonEntriesTable((String)jsonEntryNames.object1(), (String)jsonEntryNames.object2());
                    table.setBigDataJsonArray((BigDataJsonArray)frag, param, BigDataValueCellEditor.this.m_relation);
                    return table;
                }
                catch (IllegalStateException ise) {
                    DBLog.getLogger((Object)this).fine(ise.getMessage());
                }
            }
            throw new DBException((DBObject)param, errorMessage);
        }

        @Override
        protected String getText(BigDataJsonEntriesTable table) {
            BigDataJsonArray arr = table.getBigDataJsonArray();
            return arr == null ? null : arr.getSQLText();
        }

        @Override
        protected boolean supportsPopup(JTable table, Object value, int row, int column) {
            return BigDataJsonEntry.getJsonEntryNames((String)BigDataValueCellEditor.this.m_parameterName) != null;
        }
    }

    private abstract class PopupTableCellEditor<T extends ExtendedTable>
    extends ValueCellEditor {
        private T m_table;

        private PopupTableCellEditor() {
        }

        protected abstract T createTable(BigDataAccessParameter var1) throws DBException;

        protected abstract String getText(T var1);

        @Override
        protected void initPopup(JPanel popupPanel) {
            popupPanel.removeAll();
            this.m_table = null;
            String text = this.getEditor().getText();
            BigDataAccessParameter param = (BigDataAccessParameter)BigDataValueCellEditor.this.m_provider.getObjectFactory().newObject(BigDataAccessParameter.class);
            param.setName(BigDataValueCellEditor.this.m_parameterName);
            param.setParameterValue(text);
            try {
                this.m_table = this.createTable(param);
                popupPanel.setLayout(new BorderLayout());
                popupPanel.add((Component)((ExtendedTable)this.m_table).getComponent(), "Center");
                ((ExtendedTable)this.m_table).addTableModelListener(BigDataValueCellEditor.this.m_childTableListener);
            }
            catch (DBException dbe) {
                this.layoutInvalidValuePopup(popupPanel, dbe.getMessage());
            }
            popupPanel.setPreferredSize(null);
        }

        @Override
        protected Integer getPreferredPopupHeight() {
            return this.m_table == null ? null : super.getPreferredPopupHeight();
        }

        @Override
        protected void commitPopup() {
            if (this.m_table != null) {
                ((ExtendedTable)this.m_table).removeTableModelListener(BigDataValueCellEditor.this.m_childTableListener);
                ((ExtendedTable)this.m_table).stopCellEditing();
                if (((ExtendedTable)this.m_table).isModelDirty()) {
                    this.getEditor().setText(this.getText(this.m_table));
                }
            }
        }

        @Override
        protected boolean supportsPopup(JTable table, Object value, int row, int column) {
            return true;
        }
    }

    private class ValueCellEditor
    extends TableCellEditorWithPopup
    implements ExtendedTable.ExtendedTableCellEditor {
        ValueCellEditor() {
            super(BigDataValueCellEditor.BASE_NAME, true, true, OracleIcons.getIcon((String)"edit.png"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component retval = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            BigDataAccessParameterMetadata.TemplateValue template = BigDataAccessParameterMetadata.getParameterTemplateValue((String)BigDataValueCellEditor.this.m_parameterName);
            if (template != null && (value == null || "".equals(value))) {
                this.getEditor().setText(template.toString());
            }
            return retval;
        }

        @Override
        public void prepareComponent(Component component) {
            ExtendedTextField ed = this.getEditor();
            SwingUtilities.invokeLater(new Runnable((JTextComponent)ed){
                final /* synthetic */ JTextComponent val$ed;
                {
                    this.val$ed = jTextComponent;
                }

                @Override
                public void run() {
                    if (this.val$ed.isVisible()) {
                        this.val$ed.requestFocusInWindow();
                        final BigDataAccessParameterMetadata.TemplateValue template = BigDataAccessParameterMetadata.getParameterTemplateValue((String)BigDataValueCellEditor.this.m_parameterName);
                        if (template != null) {
                            final String before = template.getBefore();
                            final String text = this.val$ed.getText();
                            if (text != null && before != null && text.startsWith(before)) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (val$ed.isVisible()) {
                                            int index = before.length();
                                            if (text.length() > index) {
                                                int end = -1;
                                                String after = template.getAfter();
                                                if (after != null) {
                                                    char next = after.charAt(0);
                                                    end = text.indexOf(next, index);
                                                }
                                                if (end < 0) {
                                                    end = index;
                                                }
                                                val$ed.select(index, end);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return BigDataAccessParameterMetadata.checkLineBreaks((String)this.getEditor().getText());
        }

        protected final void layoutInvalidValuePopup(JPanel popupPanel, String errorMessage) {
            DBUILayoutHelper layout = new DBUILayoutHelper(popupPanel);
            layout.setMargins(10);
            layout.add((Component)new JWrappedLabel(UIBundle.format("EXTTAB_INVALID_VALUE", errorMessage == null ? "" : errorMessage)), 2, 1);
            JButton clear = new JButton();
            this.getResourceHelper().resButton(clear, UIBundle.get("EXTTAB_CLEAR_VALUE"), "Clear");
            clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueCellEditor.this.clearText();
                }
            });
            layout.nextRow();
            layout.add(clear);
            layout.pushLeft();
            layout.nextRow();
            layout.pushUp();
            layout.layout();
        }

        private void clearText() {
            this.getEditor().setText(null);
            if (this.isPopupShowing()) {
                this.hidePopup();
                this.showPopup();
            }
        }

        @Override
        protected void initPopup(JPanel popupPanel) {
        }

        @Override
        protected void commitPopup() {
        }

        @Override
        protected boolean supportsPopup(JTable table, Object value, int row, int column) {
            return false;
        }
    }
}

