/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.ora.OracleIndexPartitions;

public class IndexPartitionColumnsWrapper
extends ComponentWrapper<JComboBox> {
    public IndexPartitionColumnsWrapper() {
        super(new JComboBox(new DefaultComboBoxModel()));
    }

    @Override
    public Object getPropertyValue() {
        ComboBoxModel model = ((JComboBox)this.getActiveComponent()).getModel();
        DBObjectID stopAt = ((DBObject)model.getSelectedItem()).getID();
        ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
        if (model.getSize() > 0) {
            int i = 0;
            DBObjectID current = null;
            do {
                current = ((DBObject)model.getElementAt(i)).getID();
                colIDs.add(current);
            } while (++i < model.getSize() && !stopAt.equals(current));
        }
        return colIDs.toArray(new DBObjectID[colIDs.size()]);
    }

    @Override
    public void setPropertyValue(Object val) {
        ComboBoxModel model = ((JComboBox)this.getActiveComponent()).getModel();
        if (val instanceof DBObjectID[] && ((DBObjectID[])val).length > 0) {
            DBObjectID[] cols = (DBObjectID[])val;
            DBObjectID last = cols[cols.length - 1];
            try {
                model.setSelectedItem(last.resolveID());
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)this).log(Level.WARNING, dbe.getMessage(), dbe);
            }
        } else {
            model.setSelectedItem(null);
        }
    }

    @Override
    public void processComponent(boolean editable, boolean allowRecreate) {
        super.processComponent(editable, allowRecreate);
        this.populateCombo();
    }

    @Override
    protected void initialiseComponent() {
        ((JComboBox)this.getActiveComponent()).setRenderer(new DBObjectRenderer(false));
    }

    @Override
    protected void initialiseComponentListener() {
        ((JComboBox)this.getActiveComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    IndexPartitionColumnsWrapper.this.fireChangeEvent();
                }
            }
        });
    }

    @Override
    public String getPropertyDisplayName() {
        return UIBundle.get("INDEX_PARTITIONS_LAST_COLUMN");
    }

    private void populateCombo() {
        Column[] cols;
        DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.getActiveComponent()).getModel();
        model.removeAllElements();
        for (Column col : cols = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)((Index)this.getUpdatedObject()))) {
            model.addElement(col);
        }
        ((JComboBox)this.getActiveComponent()).setModel(model);
    }
}

